/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class Coord
implements DataIO {
    public static final Comparator LINEID_ORDER = new LineIDOrder();
    public static final int BYTESIZE = 12;
    public double time;
    public int lineID;

    public Coord(double in_time, int in_task) {
        this.time = in_time;
        this.lineID = in_task;
    }

    public Coord(Coord in_vertex) {
        this.time = in_vertex.time;
        this.lineID = in_vertex.lineID;
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeDouble(this.time);
        outs.writeInt(this.lineID);
    }

    public Coord(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.time = ins.readDouble();
        this.lineID = ins.readInt();
    }

    public int getByteSize() {
        return 12;
    }

    public String toString() {
        return "(" + (float)this.time + ", " + this.lineID + ")";
    }

    private static class LineIDOrder
    implements Comparator {
        private LineIDOrder() {
        }

        public int compare(Object o1, Object o2) {
            Coord coord1 = (Coord)o1;
            Coord coord2 = (Coord)o2;
            return coord1.lineID - coord2.lineID;
        }
    }
}

