/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog2;

import java.io.DataInputStream;
import java.io.IOException;
import logformat.clog2.LineID;

public class RecHeader {
    private static final int BYTESIZE = 24;
    public double time;
    private int icomm;
    private int rank;
    private int thread;
    public int rectype;
    public int gthdLineID;

    public RecHeader() {
        this.time = Double.MIN_VALUE;
        this.icomm = Integer.MIN_VALUE;
        this.rank = Integer.MIN_VALUE;
        this.thread = Integer.MIN_VALUE;
        this.rectype = Integer.MIN_VALUE;
        this.gthdLineID = Integer.MIN_VALUE;
    }

    public RecHeader(DataInputStream istm) {
        this.readFromDataStream(istm);
    }

    public int readFromDataStream(DataInputStream istm) {
        try {
            this.time = istm.readDouble();
            this.icomm = istm.readInt();
            this.rank = istm.readInt();
            this.thread = istm.readInt();
            this.rectype = istm.readInt();
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        this.gthdLineID = LineID.computeGlobalThreadID(this.icomm, this.rank, this.thread);
        return 24;
    }

    public int getProcessLineID() {
        return LineID.computeGlobalProcessID(this.icomm, this.rank);
    }

    public int skipBytesFromDataStream(DataInputStream in) {
        try {
            in.skipBytes(24);
        }
        catch (IOException ioerr) {
            ioerr.printStackTrace();
            return 0;
        }
        return 24;
    }

    public int getRecType() {
        return this.rectype;
    }

    public String toString() {
        return "RecHeader[ time=" + this.time + ", icomm=" + this.icomm + ", rank=" + this.rank + ", thread=" + this.thread + ", rectype=" + this.rectype + " ]";
    }
}

