/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.CategoryRatios;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public class CategorySummary
extends CategoryRatios
implements DataIO {
    public static final int BYTESIZE = 16;
    public static final Comparator COUNT_ORDER = new CountOrder();
    private long num_real_objs;

    public CategorySummary() {
        this.num_real_objs = 0L;
    }

    public CategorySummary(float new_incl_r, float new_excl_r, long new_num_real_objs) {
        super(new_incl_r, new_excl_r);
        this.num_real_objs = new_num_real_objs;
    }

    public CategorySummary(CategorySummary type_smy) {
        super(type_smy);
        this.num_real_objs = type_smy.num_real_objs;
    }

    public long getDrawableCount() {
        return this.num_real_objs;
    }

    public void addDrawableCount(long new_num_real_objs) {
        this.num_real_objs += new_num_real_objs;
    }

    public void writeObject(DataOutput outs) throws IOException {
        super.writeObject(outs);
        outs.writeLong(this.num_real_objs);
    }

    public CategorySummary(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        super.readObject(ins);
        this.num_real_objs = ins.readLong();
    }

    public String toInfoBoxString(int print_status) {
        return super.toInfoBoxString(print_status) + ", count=" + this.num_real_objs;
    }

    public String toString() {
        return super.toString() + ", count=" + this.num_real_objs;
    }

    private static class CountOrder
    implements Comparator {
        private CountOrder() {
        }

        public int compare(Object o1, Object o2) {
            CategorySummary type_smy1 = (CategorySummary)o1;
            CategorySummary type_smy2 = (CategorySummary)o2;
            long diff = type_smy1.num_real_objs - type_smy2.num_real_objs;
            return diff < 0L ? -1 : (diff == 0L ? 0 : 1);
        }
    }
}

