/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.pipe;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.InputAPI;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import base.drawable.Topology;
import base.drawable.YCoordMap;
import java.util.Iterator;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TreeDir;
import logformat.slog2.TreeDirValue;
import logformat.slog2.input.InputLog;

public class PipedInputLog
extends InputLog
implements InputAPI {
    private int next_kind_idx;
    private TopologyIterator itr_topo = null;
    private CategoryIterator itr_objdef = null;
    private LineIDMapIterator itr_lineIDmap = null;
    private DrawableIterator itr_dobj = null;

    public PipedInputLog(String pathname) {
        super(pathname);
    }

    public void initialize() {
        super.initialize();
        this.itr_topo = new TopologyIterator(-1);
    }

    public Kind peekNextKind() {
        switch (this.next_kind_idx) {
            case -1: {
                if (this.itr_topo.hasNext()) {
                    return Kind.TOPOLOGY;
                }
                this.itr_objdef = new CategoryIterator(3);
            }
            case 3: {
                if (this.itr_objdef.hasNext()) {
                    return Kind.CATEGORY;
                }
                this.itr_lineIDmap = new LineIDMapIterator(4);
            }
            case 4: {
                if (this.itr_lineIDmap.hasNext()) {
                    return Kind.YCOORDMAP;
                }
                this.itr_dobj = new DrawableIterator(2);
            }
            case 1: 
            case 2: {
                if (this.itr_dobj.hasNext()) {
                    if (this.itr_dobj.isNextComposite()) {
                        return Kind.COMPOSITE;
                    }
                    return Kind.PRIMITIVE;
                }
            }
            case 0: {
                return Kind.EOF;
            }
        }
        System.err.println("PipedInputLog.peekNextKind(): Error!\n\tUnknown Kind index: " + this.next_kind_idx);
        return null;
    }

    public Topology getNextTopology() {
        return (Topology)this.itr_topo.next();
    }

    public Category getNextCategory() {
        return (Category)this.itr_objdef.next();
    }

    public YCoordMap getNextYCoordMap() {
        return ((LineIDMap)this.itr_lineIDmap.next()).toYCoordMap();
    }

    public Primitive getNextPrimitive() {
        return (Primitive)this.itr_dobj.next();
    }

    public Composite getNextComposite() {
        return (Composite)this.itr_dobj.next();
    }

    public void close() {
        super.close();
    }

    private class DrawableIterator
    implements Iterator {
        private final Drawable.Order TRACE_ORDER = Drawable.INCRE_FINALTIME_ORDER;
        private Iterator dobj_itr;
        private Drawable next_dobj;

        public DrawableIterator(int kind_idx) {
            PipedInputLog.this.next_kind_idx = kind_idx;
            TreeDir treedir = PipedInputLog.super.getTreeDir();
            TreeDirValue root_dir = (TreeDirValue)treedir.get(treedir.firstKey());
            TimeBoundingBox timeframe = new TimeBoundingBox(root_dir.getTimeBoundingBox());
            this.dobj_itr = PipedInputLog.super.iteratorOfRealDrawables(timeframe, this.TRACE_ORDER, 0);
            this.next_dobj = this.dobj_itr.hasNext() ? (Drawable)this.dobj_itr.next() : null;
        }

        public boolean hasNext() {
            return this.next_dobj != null;
        }

        public Object next() {
            Drawable loosen_dobj = this.next_dobj;
            this.next_dobj = this.dobj_itr.hasNext() ? (Drawable)this.dobj_itr.next() : null;
            return loosen_dobj;
        }

        public boolean isNextComposite() {
            return this.next_dobj instanceof Composite;
        }

        public void remove() {
        }
    }

    private class LineIDMapIterator
    implements Iterator {
        private Iterator lineIDmap_itr;
        private LineIDMap next_lineIDmap;

        public LineIDMapIterator(int kind_idx) {
            PipedInputLog.this.next_kind_idx = kind_idx;
            LineIDMapList lineIDmaps = PipedInputLog.super.getLineIDMapList();
            this.lineIDmap_itr = lineIDmaps.iterator();
            this.next_lineIDmap = this.lineIDmap_itr.hasNext() ? (LineIDMap)this.lineIDmap_itr.next() : null;
        }

        public boolean hasNext() {
            return this.next_lineIDmap != null;
        }

        public Object next() {
            LineIDMap loosen_lineIDmap = this.next_lineIDmap;
            this.next_lineIDmap = this.lineIDmap_itr.hasNext() ? (LineIDMap)this.lineIDmap_itr.next() : null;
            return loosen_lineIDmap;
        }

        public void remove() {
        }
    }

    private class CategoryIterator
    implements Iterator {
        private Iterator objdef_itr;
        private Category next_objdef;

        public CategoryIterator(int kind_idx) {
            PipedInputLog.this.next_kind_idx = kind_idx;
            CategoryMap objdefs = PipedInputLog.super.getCategoryMap();
            this.objdef_itr = objdefs.values().iterator();
            this.next_objdef = this.objdef_itr.hasNext() ? (Category)this.objdef_itr.next() : null;
        }

        public boolean hasNext() {
            return this.next_objdef != null;
        }

        public Object next() {
            Category loosen_objdef = this.next_objdef;
            this.next_objdef = this.objdef_itr.hasNext() ? (Category)this.objdef_itr.next() : null;
            return loosen_objdef;
        }

        public void remove() {
        }
    }

    private class TopologyIterator
    implements Iterator {
        private int num_topology_returned;

        public TopologyIterator(int kind_idx) {
            PipedInputLog.this.next_kind_idx = kind_idx;
            this.num_topology_returned = 0;
        }

        public boolean hasNext() {
            return this.num_topology_returned < 3;
        }

        public Object next() {
            switch (this.num_topology_returned) {
                case 0: {
                    this.num_topology_returned = 1;
                    return Topology.EVENT;
                }
                case 1: {
                    this.num_topology_returned = 2;
                    return Topology.STATE;
                }
                case 2: {
                    this.num_topology_returned = 3;
                    return Topology.ARROW;
                }
            }
            System.err.println("All Topologies have been returned.");
            return null;
        }

        public void remove() {
        }
    }
}

