/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class Line {
    private static double Max_LineSeg2Pt_DistSQ = 10.0;

    public static void setPixelClosenessTolerance(int pix_dist) {
        Max_LineSeg2Pt_DistSQ = pix_dist * pix_dist + 1;
    }

    private static int drawForward(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        int jTail;
        int iTail;
        int jHead;
        int iHead;
        int iFinal;
        int iStart = coord_xform.convertTimeToPixel(start_time);
        if (last_drawn_pos.coversArrow(iStart, iFinal = coord_xform.convertTimeToPixel(final_time))) {
            return 0;
        }
        last_drawn_pos.set(iStart, iFinal);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        boolean isStartVtxInImg = iStart > 0;
        boolean isFinalVtxInImg = iFinal < coord_xform.getImageWidth();
        double slope = 0.0;
        if (!isStartVtxInImg || !isFinalVtxInImg) {
            if (iStart != iFinal) {
                slope = (double)(jFinal - jStart) / (double)(iFinal - iStart);
            } else {
                return 0;
            }
        }
        if (isStartVtxInImg) {
            iHead = iStart;
            jHead = jStart;
        } else {
            iHead = 0;
            jHead = (int)Math.rint((double)jStart - slope * (double)iStart);
        }
        if (isFinalVtxInImg) {
            iTail = iFinal;
            jTail = jFinal;
        } else {
            iTail = coord_xform.getImageWidth();
            jTail = (int)Math.rint((double)jFinal + slope * (double)(iTail - iFinal));
        }
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        g.setColor(color);
        g.drawLine(iHead, jHead, iTail, jTail);
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        return 1;
    }

    public static boolean containsPixel(CoordPixelXform coord_xform, Point pt, double start_time, float start_ypos, double final_time, float final_ypos) {
        double yPt;
        double xPt;
        double yFinal;
        double xFinal;
        double yStart;
        double xStart = coord_xform.convertTimeToPixel(start_time);
        double distSQ = Line2D.ptSegDistSq(xStart, yStart = (double)coord_xform.convertRowToPixel(start_ypos), xFinal = (double)coord_xform.convertTimeToPixel(final_time), yFinal = (double)coord_xform.convertRowToPixel(final_ypos), xPt = (double)pt.x, yPt = (double)pt.y);
        return distSQ < Max_LineSeg2Pt_DistSQ;
    }

    public static int draw(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double start_time, float start_ypos, double final_time, float final_ypos) {
        if (start_time < final_time) {
            return Line.drawForward(g, color, stroke, coord_xform, last_drawn_pos, start_time, start_ypos, final_time, final_ypos);
        }
        return Line.drawForward(g, color, stroke, coord_xform, last_drawn_pos, final_time, final_ypos, start_time, start_ypos);
    }
}

