/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Routines {
    private static final String UnitIndentStr = "   ";
    private static final double MATH_LOG_10 = Math.log(10.0);
    private static final double COLOR_FACTOR = 0.85;

    public static void listAllComponents(Component comp, int ilevel) {
        if (comp == null) {
            return;
        }
        StringBuffer rep = new StringBuffer();
        for (int ii = 0; ii < ilevel; ++ii) {
            rep.append(UnitIndentStr);
        }
        rep.append(comp.toString());
        System.out.println(rep.toString());
        if (comp instanceof Container) {
            Component[] child_comps = ((Container)comp).getComponents();
            for (int idx = 0; idx < child_comps.length; ++idx) {
                Routines.listAllComponents(child_comps[idx], ilevel + 1);
            }
        }
    }

    public static void setComponentAndChildrenCursors(Component comp, Cursor csr) {
        if (comp == null) {
            return;
        }
        comp.setCursor(csr);
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            for (int ii = 0; ii < comps.length; ++ii) {
                Routines.setComponentAndChildrenCursors(comps[ii], csr);
            }
        }
    }

    public static void setShortJComponentSizes(JComponent comp, Dimension pref_size) {
        Dimension min_size = new Dimension(0, pref_size.height);
        Dimension max_size = new Dimension(Short.MAX_VALUE, pref_size.height);
        comp.setMinimumSize(min_size);
        comp.setMaximumSize(max_size);
        comp.setPreferredSize(pref_size);
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension correctSize(Dimension size, Insets insets) {
        if (insets != null) {
            size.width += insets.left + insets.right;
            if (size.width > Short.MAX_VALUE) {
                size.width = Short.MAX_VALUE;
            }
            size.height += insets.top + insets.bottom;
            if (size.height > Short.MAX_VALUE) {
                size.height = Short.MAX_VALUE;
            }
        }
        return size;
    }

    public static int getAdjNumOfTextColumns(Component textcomp, int num_numeric_columns) {
        FontMetrics metrics = textcomp.getFontMetrics(textcomp.getFont());
        int num_char_columns = (int)Math.ceil((double)num_numeric_columns * (double)metrics.charWidth('1') / (double)metrics.charWidth('m'));
        return num_char_columns;
    }

    public static double getTimeRulerIncrement(double t_incre) {
        double incre = t_incre;
        double incre_expo = Math.ceil(Math.log(incre) / MATH_LOG_10);
        double incre_ftr = Math.pow(10.0, incre_expo);
        double tmp_mant = incre / incre_ftr;
        double incre_mant = tmp_mant < 0.1125 ? 0.1 : (tmp_mant < 0.1625 ? 0.125 : (tmp_mant < 0.225 ? 0.2 : (tmp_mant < 0.325 ? 0.25 : (tmp_mant < 0.45 ? 0.4 : (tmp_mant < 0.75 ? 0.5 : 1.0)))));
        return incre_mant * incre_ftr;
    }

    public static double getTimeRulerFirstMark(double t_init, double t_incre) {
        double quotient = Math.floor(t_init / t_incre);
        return quotient * t_incre;
    }

    public static Color getSlightBrighterColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int ii = 6;
        if (red == 0 && green == 0 && blue == 0) {
            return new Color(ii, ii, ii);
        }
        if (red > 0 && red < ii) {
            red = ii;
        }
        if (green > 0 && green < ii) {
            green = ii;
        }
        if (blue > 0 && blue < ii) {
            blue = ii;
        }
        return new Color(Math.min((int)((double)red / 0.85), 255), Math.min((int)((double)green / 0.85), 255), Math.min((int)((double)blue / 0.85), 255));
    }

    public static Color getSlightDarkerColor(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.85), 0), Math.max((int)((double)color.getGreen() * 0.85), 0), Math.max((int)((double)color.getBlue() * 0.85), 0));
    }

    public static boolean isLeftMouseButton(MouseEvent mouse_evt) {
        return SwingUtilities.isLeftMouseButton(mouse_evt) && !mouse_evt.isControlDown();
    }

    public static boolean isRightMouseButton(MouseEvent mouse_evt) {
        return SwingUtilities.isRightMouseButton(mouse_evt) || SwingUtilities.isLeftMouseButton(mouse_evt) && mouse_evt.isControlDown();
    }
}

