/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineMove
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;
    private DefaultTreeModel tree_model;

    public ActionTimelineMove(Window parent_window, ToolBarStatus in_toolbar, YaxisTree in_tree) {
        this.root_window = parent_window;
        this.toolbar = in_toolbar;
        this.tree = in_tree;
        this.tree_model = (DefaultTreeModel)this.tree.getModel();
    }

    public void actionPerformed(ActionEvent event) {
        MutableTreeNode child;
        int idx;
        if (Debug.isActive()) {
            Debug.println("Action for Move Timeline button");
        }
        if (this.tree.getSelectionCount() != 1) {
            Dialogs.error(this.root_window, "ONE selected tree node is needed as an insertion point!");
            return;
        }
        TreePath selected_path = this.tree.getSelectionPath();
        TreePath[] child_paths = this.tree.getFromCutAndPasteBuffer();
        if (child_paths == null || child_paths.length < 1) {
            Dialogs.warn(this.root_window, "Nothing has been marked for relocation!");
            return;
        }
        if (!this.tree.isPathLevelSameAsThatOfCutAndPasteBuffer(selected_path)) {
            Dialogs.error(this.root_window, "The level of insertion point has different level than that of marked timelines. Select another insertion point!");
            return;
        }
        Enumeration[] enum_paths = new Enumeration[child_paths.length];
        boolean[] isBufferedPathExpanded = new boolean[child_paths.length];
        for (idx = 0; idx < child_paths.length; ++idx) {
            enum_paths[idx] = this.tree.getExpandedDescendants(child_paths[idx]);
            if (Debug.isActive()) {
                Debug.println("action_timeline_move(): emum_paths[" + idx + "] = " + enum_paths[idx]);
            }
            if (this.tree.isExpanded(child_paths[idx])) {
                isBufferedPathExpanded[idx] = true;
                this.tree.collapsePath(child_paths[idx]);
                continue;
            }
            isBufferedPathExpanded[idx] = false;
        }
        for (idx = 0; idx < child_paths.length; ++idx) {
            child = (MutableTreeNode)child_paths[idx].getLastPathComponent();
            this.tree_model.removeNodeFromParent(child);
            if (!Debug.isActive()) continue;
            Debug.println("\tCut " + child);
        }
        TreePath parent_path = selected_path.getParentPath();
        if (Debug.isActive()) {
            Debug.println("action_timeline_move(): parent_path = " + parent_path);
        }
        MutableTreeNode parent = (MutableTreeNode)parent_path.getLastPathComponent();
        MutableTreeNode selected = (MutableTreeNode)selected_path.getLastPathComponent();
        int insertion_idx = ((DefaultMutableTreeNode)parent).getIndex(selected) + 1;
        for (idx = 0; idx < child_paths.length; ++idx) {
            child = (MutableTreeNode)child_paths[idx].getLastPathComponent();
            this.tree_model.insertNodeInto(child, parent, insertion_idx + idx);
            if (Debug.isActive()) {
                Debug.println("\tPaste " + child + " next to " + selected);
            }
            TreePath prefix_path = parent_path.pathByAddingChild(child);
            if (isBufferedPathExpanded[idx]) {
                this.tree.expandPath(prefix_path);
            }
            if (enum_paths[idx] == null) continue;
            Enumeration paths = enum_paths[idx];
            while (paths.hasMoreElements()) {
                TreePath old_path = (TreePath)paths.nextElement();
                if (Debug.isActive()) {
                    Debug.print("action_timeline_move(): " + old_path);
                }
                TreePath new_path = this.getReplacedPath(prefix_path, old_path);
                if (Debug.isActive()) {
                    Debug.println(" is restored as " + new_path);
                }
                this.tree.expandPath(new_path);
            }
        }
        this.tree.clearCutAndPasteBuffer();
        this.tree.update_leveled_paths();
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(false);
        this.toolbar.getTimelineDeleteButton().setEnabled(false);
        this.toolbar.resetYaxisTreeButtons();
    }

    private TreePath getReplacedPath(TreePath prefix_path, TreePath old_path) {
        MutableTreeNode common_node = (MutableTreeNode)prefix_path.getLastPathComponent();
        TreePath new_path = prefix_path.getParentPath();
        DefaultMutableTreeNode last_node = (DefaultMutableTreeNode)old_path.getLastPathComponent();
        Enumeration<TreeNode> nodes = last_node.pathFromAncestorEnumeration(common_node);
        while (nodes.hasMoreElements()) {
            new_path = new_path.pathByAddingChild(nodes.nextElement());
        }
        return new_path;
    }
}

