/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import viewer.common.Const;
import viewer.common.Routines;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableObject;

public class RulerTime
extends ScrollableObject {
    private static final long serialVersionUID = 4500L;
    private static final Font FONT = Const.FONT;
    private static final int FONT_SIZE = FONT.getSize();
    private static final int TICKMARK_HEIGHT = 10;
    private static final int I_FONT_BASELINE = 10 + FONT_SIZE + 5;
    private static final int VIEW_HEIGHT = I_FONT_BASELINE + 5;
    private double tRange = 0.0;
    private double tIncrement = 0.0;
    private DecimalFormat fmt = (DecimalFormat)NumberFormat.getInstance();

    public RulerTime(ModelTime model) {
        super(model);
        this.fmt.applyPattern("#,##0.00######");
    }

    public Dimension getMinimumSize() {
        if (Debug.isActive()) {
            Debug.println("RulerTime: min_size = (0," + VIEW_HEIGHT + ")");
        }
        return new Dimension(0, VIEW_HEIGHT);
    }

    public Dimension getMaximumSize() {
        if (Debug.isActive()) {
            Debug.println("RulerTime: max_size = (32767," + VIEW_HEIGHT + ")");
        }
        return new Dimension(Short.MAX_VALUE, VIEW_HEIGHT);
    }

    public int getJComponentHeight() {
        return VIEW_HEIGHT;
    }

    protected void initializeAllOffImages(TimeBoundingBox imgs_times) {
    }

    protected void finalizeAllOffImages(TimeBoundingBox imgs_times) {
    }

    protected void drawOneOffImage(Image offImage, TimeBoundingBox timebounds) {
        if (Debug.isActive()) {
            Debug.println("RulerTime: drawOneOffImage()'s offImage = " + offImage);
        }
        if (offImage != null) {
            int offImage_width = offImage.getWidth(this);
            int offImage_height = offImage.getHeight(this);
            Graphics offGraphics = offImage.getGraphics();
            offGraphics.setColor(Color.white);
            offGraphics.fillRect(0, 0, offImage_width, offImage_height);
            offGraphics.setFont(FONT);
            offGraphics.setColor(Color.black);
            if (timebounds.getDuration() != this.tRange) {
                this.tRange = timebounds.getDuration();
                this.tIncrement = this.tRange / 20.0;
                this.tIncrement = Routines.getTimeRulerIncrement(this.tIncrement);
            }
            String text = null;
            if (Debug.isActive()) {
                Debug.print("RulerTime.drawOffImage at : ");
            }
            double t_init = timebounds.getEarliestTime();
            int i_X_0 = super.time2pixel(t_init);
            double tInitMark = Routines.getTimeRulerFirstMark(t_init, this.tIncrement);
            double tFinalMark = timebounds.getLatestTime() + this.tIncrement;
            for (double time = tInitMark; time < tFinalMark; time += this.tIncrement) {
                int i_X = super.time2pixel(time) - i_X_0;
                offGraphics.drawLine(i_X, 1, i_X, 10);
                text = this.fmt.format(time);
                offGraphics.drawString(text, i_X - 3, I_FONT_BASELINE);
                if (!Debug.isActive()) continue;
                Debug.print(time + ":" + i_X + ", ");
            }
            if (Debug.isActive()) {
                Debug.println("|");
            }
            offGraphics.dispose();
        }
    }

    public InfoDialog getPropertyAt(Point view_click, TimeBoundingBox vport_times) {
        return super.getTimePropertyAt(view_click);
    }
}

