/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import viewer.common.TopWindow;
import viewer.zoomable.ViewportTimeYaxis;

public class SearchDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 4400L;
    private Window root_window;
    private ViewportTimeYaxis viewport;
    private Container root_panel;
    private JPanel btn_panel;
    private JButton close_btn;

    public SearchDialog(Frame frame, ViewportTimeYaxis vport) {
        super(frame, "Search Box");
        this.root_window = frame;
        this.viewport = vport;
        this.init();
    }

    private void init() {
        super.setDefaultCloseOperation(0);
        this.root_panel = super.getContentPane();
        this.root_panel.setLayout(new BoxLayout(this.root_panel, 1));
        this.btn_panel = new JPanel();
        this.close_btn = new JButton("close");
        this.close_btn.addActionListener(this);
        this.close_btn.setAlignmentX(0.5f);
        this.btn_panel.add(this.close_btn);
        this.btn_panel.setAlignmentX(0.0f);
        Dimension panel_max_size = this.btn_panel.getPreferredSize();
        panel_max_size.width = Short.MAX_VALUE;
        this.btn_panel.setMaximumSize(panel_max_size);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.setVisible(false);
                SearchDialog.this.viewport.eraseSearchedDrawable();
                SearchDialog.this.viewport.repaint();
            }
        });
        super.setVisible(false);
    }

    private void setVisibleAtLocation(Point global_pt) {
        this.setLocation(global_pt);
        this.pack();
        this.setVisible(true);
        this.toFront();
    }

    public void setVisibleAtDefaultLocation() {
        Rectangle rect = null;
        Point loc_pt = null;
        JFrame frame = TopWindow.First.getWindow();
        if (frame != null) {
            rect = frame.getBounds();
            loc_pt = new Point(rect.x + rect.width, rect.y);
        } else {
            rect = this.root_window.getBounds();
            loc_pt = new Point(rect.x + rect.width, rect.y);
        }
        this.setVisibleAtLocation(loc_pt);
    }

    public void replace(Component cmpo_panel) {
        this.root_panel.removeAll();
        this.root_panel.add(cmpo_panel);
        this.root_panel.add(this.btn_panel);
        super.invalidate();
        super.validate();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.close_btn) {
            super.setVisible(false);
            this.viewport.eraseSearchedDrawable();
            this.viewport.repaint();
        }
    }
}

