/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.Drawable;
import base.drawable.Primitive;
import base.drawable.TimeBoundingBox;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import logformat.slog2.FileBlockPtr;
import logformat.slog2.LineIDMap;
import logformat.slog2.TreeNodeID;

public abstract class BufForObjects
extends TimeBoundingBox {
    protected static final int BYTESIZE = 34;
    public static final Order INCRE_INDEX_ORDER = new Order(TreeNodeID.INCRE_INDEX_ORDER);
    public static final Order DECRE_INDEX_ORDER = new Order(TreeNodeID.DECRE_INDEX_ORDER);
    private TreeNodeID ID = new TreeNodeID(0, 0);
    private FileBlockPtr blockptr = new FileBlockPtr();

    protected BufForObjects() {
    }

    public void setTreeNodeID(TreeNodeID new_ID) {
        this.ID.depth = new_ID.depth;
        this.ID.xpos = new_ID.xpos;
    }

    public TreeNodeID getTreeNodeID() {
        return this.ID;
    }

    public boolean isLeaf() {
        return this.ID.isLeaf();
    }

    public boolean isPossibleRoot() {
        return this.ID.isPossibleRoot();
    }

    public void setFileBlockPtr(long in_fptr, int in_size) {
        this.blockptr.setFileBlockPtr(in_fptr, in_size);
    }

    public FileBlockPtr getFileBlockPtr() {
        return this.blockptr;
    }

    public long getFilePointer() {
        return this.blockptr.getFilePointer();
    }

    public int getBlockSize() {
        return this.blockptr.getBlockSize();
    }

    public abstract int getByteSize();

    public abstract void add(Primitive var1);

    public abstract void empty();

    public abstract int getNumOfDrawables();

    public abstract int getNumOfPrimitives();

    public abstract Iterator nestableBackIterator(TimeBoundingBox var1, boolean var2);

    public abstract Iterator nestlessBackIterator(TimeBoundingBox var1);

    public abstract Iterator nestableForeIterator(TimeBoundingBox var1, boolean var2);

    public abstract Iterator nestlessForeIterator(TimeBoundingBox var1);

    public abstract LineIDMap getIdentityLineIDMap();

    protected static LineIDMap toIdentityLineIDMap(Collection obj_coll) {
        LineIDMap lineIDmap = new LineIDMap(1);
        Iterator objs_itr = obj_coll.iterator();
        while (objs_itr.hasNext()) {
            Drawable dobj = (Drawable)objs_itr.next();
            Integer[] lineIDs = dobj.getArrayOfLineIDs();
            for (int idx = 0; idx < lineIDs.length; ++idx) {
                lineIDmap.put(lineIDs[idx], new Integer[]{lineIDs[idx]});
            }
        }
        return lineIDmap;
    }

    public void writeObject(DataOutput outs) throws IOException {
        super.writeObject(outs);
        this.ID.writeObject(outs);
        this.blockptr.writeObject(outs);
    }

    public void readObject(DataInput ins) throws IOException {
        super.readObject(ins);
        this.ID.readObject(ins);
        this.blockptr.readObject(ins);
    }

    public String toString() {
        return this.ID.toString() + " " + super.toString() + " " + this.blockptr.toString();
    }

    public static class Order
    implements TreeNodeID.Order {
        private TreeNodeID.Order treenode_order;

        public Order(TreeNodeID.Order tnode_order) {
            this.treenode_order = tnode_order;
        }

        public boolean isIncreasingIndexOrdered() {
            return this.treenode_order.isIncreasingIndexOrdered();
        }

        public int compare(Object o1, Object o2) {
            BufForObjects buf4objs1 = (BufForObjects)o1;
            BufForObjects buf4objs2 = (BufForObjects)o2;
            return this.treenode_order.compare(buf4objs1.ID, buf4objs2.ID);
        }
    }
}

