/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viewer.common.LabeledTextField;

public class LabeledFloatSlider
extends LabeledTextField
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1300L;
    private static final int SLIDER_MIN = 0;
    private static final int SLIDER_MAX = 10000;
    private static final int SLIDER_EXTENT = 10000;
    private JSlider slider;
    private float fmin;
    private float fmax;
    private float fextent;

    public LabeledFloatSlider(String label, float min_label, float max_label) {
        super(true, label, "0.0##");
        this.fmin = min_label;
        this.fmax = max_label;
        this.fextent = this.fmax - this.fmin;
        int ival = 5000;
        this.slider = new JSlider(0, 0, 10000, ival);
        this.slider.setPaintLabels(true);
        float fval = this.ivalue2flabel(ival);
        Hashtable<Integer, JLabel> label_table = new Hashtable<Integer, JLabel>();
        JLabel tick_mark = new JLabel(this.fmt.format(this.fmin));
        if (FONT != null) {
            tick_mark.setFont(FONT);
        }
        label_table.put(new Integer(0), tick_mark);
        tick_mark = new JLabel(this.fmt.format(fval));
        if (FONT != null) {
            tick_mark.setFont(FONT);
        }
        label_table.put(new Integer(ival), tick_mark);
        tick_mark = new JLabel(this.fmt.format(this.fmax));
        if (FONT != null) {
            tick_mark.setFont(FONT);
        }
        label_table.put(new Integer(10000), tick_mark);
        this.slider.setLabelTable(label_table);
        this.slider.setBorder(BorderFactory.createLoweredBevelBorder());
        this.slider.setAlignmentX(0.0f);
        this.slider.addChangeListener(this);
        super.addActionListener(this);
        super.add(this.slider);
    }

    private float ivalue2flabel(int ival) {
        return this.fextent / 10000.0f * (float)(ival - 0) + this.fmin;
    }

    private int flabel2ivalue(float fval) {
        return Math.round(10000.0f / this.fextent * (fval - this.fmin)) + 0;
    }

    public void setFloat(float fval) {
        int ival = this.flabel2ivalue(fval);
        if (ival <= 0) {
            ival = 1;
            fval = this.ivalue2flabel(ival);
        }
        if (ival >= 10000) {
            ival = 9999;
            fval = this.ivalue2flabel(ival);
        }
        super.setFloat(fval);
        this.slider.setValue(ival);
    }

    public void stateChanged(ChangeEvent evt) {
        int ival = this.slider.getValue();
        if (ival <= 0) {
            ival = 1;
            this.slider.setValue(ival);
        }
        if (ival >= 10000) {
            ival = 9999;
            this.slider.setValue(ival);
        }
        float fval = this.ivalue2flabel(ival);
        super.setFloat(fval);
    }

    public void actionPerformed(ActionEvent evt) {
        float fval = super.getFloat();
        int ival = this.flabel2ivalue(fval);
        if (ival <= 0) {
            ival = 1;
            super.setFloat(this.ivalue2flabel(ival));
        }
        if (ival >= 10000) {
            ival = 9999;
            super.setFloat(this.ivalue2flabel(ival));
        }
        this.slider.setValue(ival);
    }
}

