/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.drawable.TimeBoundingBox;
import base.io.DataIO;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import logformat.slog2.FileBlockPtr;

public class TreeDirValue
implements DataIO {
    public static final int BYTESIZE = 28;
    private TimeBoundingBox timebounds;
    private FileBlockPtr blockptr;

    public TreeDirValue(TimeBoundingBox timebox, FileBlockPtr fblkptr) {
        this.timebounds = timebox;
        this.blockptr = fblkptr;
    }

    public double getEarliestTime() {
        return this.timebounds.getEarliestTime();
    }

    public double getLatestTime() {
        return this.timebounds.getLatestTime();
    }

    public TimeBoundingBox getTimeBoundingBox() {
        return this.timebounds;
    }

    public long getFilePointer() {
        return this.blockptr.getFilePointer();
    }

    public int getBlockSize() {
        return this.blockptr.getBlockSize();
    }

    public void writeObject(DataOutput outs) throws IOException {
        this.timebounds.writeObject(outs);
        this.blockptr.writeObject(outs);
    }

    public TreeDirValue(DataInput ins) throws IOException {
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        this.timebounds = new TimeBoundingBox(ins);
        this.blockptr = new FileBlockPtr(ins);
    }

    public String toString() {
        return "DirVal[ " + this.timebounds + ", " + this.blockptr + " ]";
    }
}

