/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIcon;
import viewer.legends.CategoryIconEditor;
import viewer.legends.CategoryIconRenderer;
import viewer.legends.GenericHeaderRenderer;
import viewer.legends.LegendTableModel;
import viewer.legends.OperationBooleanMenu;
import viewer.legends.OperationNumberMenu;
import viewer.legends.OperationStringMenu;
import viewer.legends.TableColumnHandler;
import viewer.legends.TableHeaderHandler;

public class LegendTable
extends JTable {
    private static final long serialVersionUID = 2500L;
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private LegendTableModel table_model;
    private TableColumnModel column_model;
    private JTableHeader table_header;

    public LegendTable(CategoryMap categoryMap) {
        this.table_model = new LegendTableModel(categoryMap);
        super.setModel(this.table_model);
        super.setDefaultRenderer(CategoryIcon.class, new CategoryIconRenderer());
        super.setDefaultEditor(CategoryIcon.class, new CategoryIconEditor());
        super.setAutoResizeMode(0);
        super.setIntercellSpacing(new Dimension(2, 2));
        super.setShowHorizontalLines(false);
        super.setShowVerticalLines(true);
        this.column_model = super.getColumnModel();
        this.table_header = this.getTableHeader();
        this.setColumnHeaderRenderers();
        this.initColumnSize();
    }

    private void setColumnHeaderRenderers() {
        int n = this.table_model.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.column_model.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (i != 0) {
                JPopupMenu jPopupMenu;
                tableCellRenderer = new GenericHeaderRenderer(this, i);
                ((GenericHeaderRenderer)tableCellRenderer).initPressablePullDownTab();
                tableColumn.setHeaderRenderer(tableCellRenderer);
                switch (i) {
                    case 1: {
                        jPopupMenu = new OperationStringMenu(this, i);
                        break;
                    }
                    case 2: 
                    case 3: {
                        jPopupMenu = new OperationBooleanMenu(this, i);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        jPopupMenu = new OperationNumberMenu(this, i);
                        break;
                    }
                    default: {
                        jPopupMenu = null;
                    }
                }
                MouseAdapter mouseAdapter = new TableHeaderHandler(this, i, jPopupMenu);
                this.table_header.addMouseListener(mouseAdapter);
                mouseAdapter = new TableColumnHandler(this, i, jPopupMenu);
                this.addMouseListener(mouseAdapter);
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = new GenericHeaderRenderer(this, i);
                tableColumn.setHeaderRenderer(tableCellRenderer);
                continue;
            }
            ((JComponent)((Object)tableCellRenderer)).setToolTipText(this.table_model.getColumnToolTip(i));
        }
    }

    private void initColumnSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = super.getIntercellSpacing();
        int n4 = this.table_model.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            int n5;
            TableColumn tableColumn = this.column_model.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, i);
            Dimension dimension2 = component.getPreferredSize();
            Insets insets = ((JComponent)component).getInsets();
            int n6 = dimension2.width + dimension.width + insets.left + insets.right;
            tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = super.getDefaultRenderer(this.table_model.getColumnClass(i));
            }
            component = tableCellRenderer.getTableCellRendererComponent(this, this.table_model.getColumnMaxValue(i), false, false, 0, i);
            Dimension dimension3 = component.getPreferredSize();
            Insets insets2 = component instanceof CategoryIconRenderer ? ((JComponent)component).getInsets() : EMPTY_INSETS;
            int n7 = dimension3.width + insets2.left + insets2.right;
            if (n7 > n6) {
                tableColumn.setPreferredWidth(n7);
                if (i < 4) {
                    n += n7;
                }
            } else {
                tableColumn.setPreferredWidth(n6);
                if (i < 4) {
                    n += n6;
                }
            }
            if ((n5 = dimension3.height + insets2.top + insets2.bottom) <= n3) continue;
            n3 = n5;
        }
        super.setRowHeight(n3);
        int n8 = this.table_model.getRowCount();
        n2 = n8 > 25 ? n3 * 25 : n3 * n8;
        super.setPreferredScrollableViewportSize(new Dimension(n, n2));
    }
}

