/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineMark
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;

    public ActionTimelineMark(Window window, ToolBarStatus toolBarStatus, YaxisTree yaxisTree) {
        this.root_window = window;
        this.toolbar = toolBarStatus;
        this.tree = yaxisTree;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Debug.isActive()) {
            Debug.println("Action for Mark Timeline button");
        }
        if (this.tree.getSelectionCount() < 1) {
            Dialogs.error(this.root_window, "At least ONE tree node needs to be marked!");
            return;
        }
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        for (int i = 0; i < treePathArray.length; ++i) {
            MutableTreeNode mutableTreeNode = (MutableTreeNode)treePathArray[i].getLastPathComponent();
            if (!Debug.isActive()) continue;
            if (this.tree.isExpanded(treePathArray[i])) {
                Debug.println("\tselected an expanded node " + mutableTreeNode);
                continue;
            }
            Debug.println("\tselected a collapsed node " + mutableTreeNode);
        }
        this.tree.renewCutAndPasteBuffer();
        if (!this.tree.isCutAndPasteBufferUniformlyLeveled(treePathArray)) {
            Dialogs.error(this.root_window, "The tree nodes are NOT selected from the same level!  Select again.");
            return;
        }
        this.tree.addToCutAndPasteBuffer(treePathArray);
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(true);
        this.toolbar.getTimelineDeleteButton().setEnabled(true);
    }
}

