/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ToolBarStatus;
import viewer.zoomable.YaxisTree;

public class ActionTimelineMove
implements ActionListener {
    private Window root_window;
    private ToolBarStatus toolbar;
    private YaxisTree tree;
    private DefaultTreeModel tree_model;

    public ActionTimelineMove(Window window, ToolBarStatus toolBarStatus, YaxisTree yaxisTree) {
        this.root_window = window;
        this.toolbar = toolBarStatus;
        this.tree = yaxisTree;
        this.tree_model = (DefaultTreeModel)this.tree.getModel();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MutableTreeNode mutableTreeNode;
        int n;
        if (Debug.isActive()) {
            Debug.println("Action for Move Timeline button");
        }
        if (this.tree.getSelectionCount() != 1) {
            Dialogs.error(this.root_window, "ONE selected tree node is needed as an insertion point!");
            return;
        }
        TreePath treePath = this.tree.getSelectionPath();
        TreePath[] treePathArray = this.tree.getFromCutAndPasteBuffer();
        if (treePathArray == null || treePathArray.length < 1) {
            Dialogs.warn(this.root_window, "Nothing has been marked for relocation!");
            return;
        }
        if (!this.tree.isPathLevelSameAsThatOfCutAndPasteBuffer(treePath)) {
            Dialogs.error(this.root_window, "The level of insertion point has different level than that of marked timelines. Select another insertion point!");
            return;
        }
        Enumeration[] enumerationArray = new Enumeration[treePathArray.length];
        boolean[] blArray = new boolean[treePathArray.length];
        for (n = 0; n < treePathArray.length; ++n) {
            enumerationArray[n] = this.tree.getExpandedDescendants(treePathArray[n]);
            if (Debug.isActive()) {
                Debug.println("action_timeline_move(): emum_paths[" + n + "] = " + enumerationArray[n]);
            }
            if (this.tree.isExpanded(treePathArray[n])) {
                blArray[n] = true;
                this.tree.collapsePath(treePathArray[n]);
                continue;
            }
            blArray[n] = false;
        }
        for (n = 0; n < treePathArray.length; ++n) {
            mutableTreeNode = (MutableTreeNode)treePathArray[n].getLastPathComponent();
            this.tree_model.removeNodeFromParent(mutableTreeNode);
            if (!Debug.isActive()) continue;
            Debug.println("\tCut " + mutableTreeNode);
        }
        TreePath treePath2 = treePath.getParentPath();
        if (Debug.isActive()) {
            Debug.println("action_timeline_move(): parent_path = " + treePath2);
        }
        MutableTreeNode mutableTreeNode2 = (MutableTreeNode)treePath2.getLastPathComponent();
        MutableTreeNode mutableTreeNode3 = (MutableTreeNode)treePath.getLastPathComponent();
        int n2 = ((DefaultMutableTreeNode)mutableTreeNode2).getIndex(mutableTreeNode3) + 1;
        for (n = 0; n < treePathArray.length; ++n) {
            mutableTreeNode = (MutableTreeNode)treePathArray[n].getLastPathComponent();
            this.tree_model.insertNodeInto(mutableTreeNode, mutableTreeNode2, n2 + n);
            if (Debug.isActive()) {
                Debug.println("\tPaste " + mutableTreeNode + " next to " + mutableTreeNode3);
            }
            TreePath treePath3 = treePath2.pathByAddingChild(mutableTreeNode);
            if (blArray[n]) {
                this.tree.expandPath(treePath3);
            }
            if (enumerationArray[n] == null) continue;
            Enumeration enumeration = enumerationArray[n];
            while (enumeration.hasMoreElements()) {
                TreePath treePath4 = (TreePath)enumeration.nextElement();
                if (Debug.isActive()) {
                    Debug.print("action_timeline_move(): " + treePath4);
                }
                TreePath treePath5 = this.getReplacedPath(treePath3, treePath4);
                if (Debug.isActive()) {
                    Debug.println(" is restored as " + treePath5);
                }
                this.tree.expandPath(treePath5);
            }
        }
        this.tree.clearCutAndPasteBuffer();
        this.tree.update_leveled_paths();
        this.toolbar.getTimelineMarkButton().setEnabled(true);
        this.toolbar.getTimelineMoveButton().setEnabled(false);
        this.toolbar.getTimelineDeleteButton().setEnabled(false);
        this.toolbar.resetYaxisTreeButtons();
    }

    private TreePath getReplacedPath(TreePath treePath, TreePath treePath2) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)treePath.getLastPathComponent();
        TreePath treePath3 = treePath.getParentPath();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.pathFromAncestorEnumeration(mutableTreeNode);
        while (enumeration.hasMoreElements()) {
            treePath3 = treePath3.pathByAddingChild(enumeration.nextElement());
        }
        return treePath3;
    }
}

