/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import base.drawable.Coord;
import base.drawable.CoordPixelXform;
import base.drawable.Drawable;
import base.drawable.DrawnBox;
import base.drawable.DrawnBoxSet;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import base.topology.Arrow;
import base.topology.Event;
import base.topology.Line;
import base.topology.State;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Primitive
extends Drawable
implements MixedDataIO {
    private static final int INIT_BYTESIZE = 2;
    private Coord[] vertices;
    private int last_vtx_idx;

    public Primitive() {
        this.vertices = null;
    }

    public Primitive(int n) {
        this.vertices = new Coord[n];
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Category category, int n) {
        super(category);
        this.vertices = new Coord[n];
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Primitive primitive) {
        super(primitive);
        Coord[] coordArray = primitive.vertices;
        this.vertices = new Coord[coordArray.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = new Coord(coordArray[i]);
        }
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(Category category, Primitive primitive) {
        super(category, primitive);
        Coord[] coordArray = primitive.vertices;
        this.vertices = new Coord[coordArray.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            this.vertices[i] = new Coord(coordArray[i]);
        }
        this.last_vtx_idx = this.vertices.length - 1;
    }

    public Primitive(int n, double d, double d2, double[] dArray, int[] nArray, byte[] byArray) {
        super(n, byArray);
        super.setEarliestTime(d);
        super.setLatestTime(d2);
        int n2 = dArray.length;
        this.vertices = new Coord[n2];
        if (n2 == nArray.length) {
            for (int i = 0; i < n2; ++i) {
                this.vertices[i] = new Coord(dArray[i], nArray[i]);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                this.vertices[i] = new Coord(dArray[i], nArray[i / 2]);
            }
        }
    }

    @Override
    public int getNumOfPrimitives() {
        return 1;
    }

    @Override
    public int getByteSize() {
        int n = super.getByteSize() + 2;
        if (this.vertices != null && this.vertices.length > 0) {
            n += this.vertices.length * 12;
        }
        return n;
    }

    @Override
    public void writeObject(MixedDataOutput mixedDataOutput) throws IOException {
        super.writeObject(mixedDataOutput);
        int n = this.vertices.length;
        mixedDataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.vertices[i].writeObject(mixedDataOutput);
        }
    }

    public Primitive(MixedDataInput mixedDataInput) throws IOException {
        this.readObject(mixedDataInput);
    }

    @Override
    public void readObject(MixedDataInput mixedDataInput) throws IOException {
        super.readObject(mixedDataInput);
        short s = mixedDataInput.readShort();
        this.vertices = new Coord[s];
        for (int n = 0; n < this.vertices.length; n = (int)((short)(n + 1))) {
            this.vertices[n] = new Coord(mixedDataInput);
        }
        this.last_vtx_idx = this.vertices.length - 1;
        super.affectTimeBounds(this.vertices);
    }

    public void setVertex(int n, Coord coord) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.vertices.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + n + ", is out of range, [0.." + this.vertices.length + "].");
        }
        this.vertices[n] = coord;
        super.affectTimeBounds(coord);
    }

    public Coord getVertex(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.vertices.length) {
            throw new ArrayIndexOutOfBoundsException("input index, " + n + ", is out of range, [0.." + this.vertices.length + "].");
        }
        return this.vertices[n];
    }

    public void setVertices(Coord[] coordArray) throws IllegalArgumentException {
        if (coordArray.length != this.vertices.length) {
            throw new IllegalArgumentException("input array size, " + coordArray.length + ", is " + "different from the original, " + this.vertices.length);
        }
        this.vertices = coordArray;
        super.affectTimeBounds(this.vertices);
    }

    public Coord[] getVertices() {
        return this.vertices;
    }

    public List getListOfVertexLineIDs() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.vertices.length);
        for (int i = 0; i < this.vertices.length; ++i) {
            arrayList.add(new Integer(this.vertices[i].lineID));
        }
        return arrayList;
    }

    @Override
    public Integer[] getArrayOfLineIDs() {
        Integer[] integerArray = new Integer[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            integerArray[i] = new Integer(this.vertices[i].lineID);
        }
        return integerArray;
    }

    public void setStartVertex(Coord coord) {
        this.vertices[0] = coord;
        super.affectTimeBounds(coord);
    }

    public void setFinalVertex(Coord coord) {
        this.vertices[this.last_vtx_idx] = coord;
        super.affectTimeBounds(coord);
    }

    @Override
    public Coord getStartVertex() {
        return this.vertices[0];
    }

    @Override
    public Coord getFinalVertex() {
        return this.vertices[this.last_vtx_idx];
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Primitive[ " + super.toString() + " ");
        for (int i = 0; i < this.vertices.length; ++i) {
            stringBuffer.append(this.vertices[i].toString() + " ");
        }
        stringBuffer.append("]");
        stringBuffer.append(" bsize=" + this.getByteSize());
        return stringBuffer.toString();
    }

    @Override
    public boolean isTimeOrdered() {
        if (!super.isTimeOrdered()) {
            System.err.println("**** Violation of Causality ****\nOffending Primitive -> " + this);
            return false;
        }
        for (int i = 0; i <= this.last_vtx_idx; ++i) {
            if (super.contains(this.vertices[i].time)) continue;
            System.err.println("**** Out of Primitive Time Range ****\nOffending Primitive -> " + this + "\n" + "\t time coordinate " + i + " is out of range.");
            return false;
        }
        return true;
    }

    @Override
    public int drawState(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        return State.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastStatePos(n), (double)d, (float)f2, (double)d2, (float)f3);
    }

    @Override
    public int drawArrow(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        int n2 = (Integer)map.get(new Integer(coord2.lineID));
        return Arrow.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastArrowPos(n, n2), (double)d, (float)n, (double)d2, (float)n2);
    }

    @Override
    public int drawEvent(Graphics2D graphics2D, CoordPixelXform coordPixelXform, Map map, DrawnBoxSet drawnBoxSet, ColorAlpha colorAlpha) {
        Coord coord = this.getStartVertex();
        double d = coord.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        float f = (float)n - 0.25f;
        float f2 = (float)n - 0.5f;
        float f3 = f2 + 1.0f;
        return Event.draw((Graphics2D)graphics2D, (Color)colorAlpha, null, (CoordPixelXform)coordPixelXform, (DrawnBox)drawnBoxSet.getLastEventPos(n), (double)d, (float)f, (float)f2, (float)f3);
    }

    @Override
    public boolean isPixelInState(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        int n = super.getRowID();
        float f = super.getNestingFactor();
        float f2 = (float)n - f / 2.0f;
        float f3 = f2 + f;
        return State.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f2, (double)d2, (float)f3);
    }

    @Override
    public boolean isPixelOnArrow(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        Coord coord2 = this.getFinalVertex();
        double d = coord.time;
        double d2 = coord2.time;
        float f = ((Integer)map.get(new Integer(coord.lineID))).floatValue();
        float f2 = ((Integer)map.get(new Integer(coord2.lineID))).floatValue();
        return Line.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f, (double)d2, (float)f2);
    }

    @Override
    public boolean isPixelAtEvent(CoordPixelXform coordPixelXform, Map map, Point point) {
        Coord coord = this.getStartVertex();
        double d = coord.time;
        int n = (Integer)map.get(new Integer(coord.lineID));
        float f = (float)n - 0.5f;
        float f2 = f + 1.0f;
        return Event.containsPixel((CoordPixelXform)coordPixelXform, (Point)point, (double)d, (float)f, (float)f2);
    }

    @Override
    public boolean containSearchable() {
        return super.getCategory().isVisiblySearchable();
    }
}

