/*
 * Decompiled with CFR 0.152.
 */
package viewer.histogram;

import base.drawable.Topology;
import base.statistics.CategoryTimeBox;
import base.statistics.CategoryWeightF;
import base.statistics.Summarizable;
import base.statistics.TimeAveBox;
import base.topology.SummaryState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import viewer.common.Const;
import viewer.common.Routines;
import viewer.legends.CategoryLabel;
import viewer.zoomable.TimeFormat;

public class InfoPanelForSummary
extends JPanel {
    private static final long serialVersionUID = 12100L;
    private static final Component STRUT = Box.createHorizontalStrut(10);
    private static final Component GLUE = Box.createHorizontalGlue();
    private static final String FORMAT = "0.0#";
    private static DecimalFormat nfmt = null;
    private static TimeFormat tfmt = null;
    private static Border Normal_Border = null;

    public InfoPanelForSummary(JTree tree_view, String[] y_colnames, Summarizable summarizable) {
        super.setLayout(new BoxLayout(this, 1));
        if (nfmt == null) {
            nfmt = (DecimalFormat)NumberFormat.getInstance();
            nfmt.applyPattern(FORMAT);
        }
        if (tfmt == null) {
            tfmt = new TimeFormat();
        }
        if (Normal_Border == null) {
            Normal_Border = BorderFactory.createEtchedBorder();
        }
        Topology topo = summarizable.getTopology();
        int rowID_start = summarizable.getStartRowID();
        int rowID_final = summarizable.getFinalRowID();
        Object clicked_obj = summarizable.getClickedObject();
        String type_name = " Summary " + topo + " ";
        Border border = null;
        CategoryLabel label_type = null;
        if (clicked_obj instanceof CategoryTimeBox) {
            CategoryWeightF twgf = ((CategoryTimeBox)clicked_obj).getCategoryWeightF();
            label_type = new CategoryLabel(twgf.getCategory());
            border = BorderFactory.createTitledBorder(Normal_Border, type_name, 1, 2, Const.FONT, Color.magenta);
        } else {
            label_type = new CategoryLabel(type_name, topo, SummaryState.ForeColor);
            border = Normal_Border;
        }
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BoxLayout(top_panel, 0));
        top_panel.add(STRUT);
        top_panel.add(label_type);
        top_panel.add(GLUE);
        top_panel.setBorder(border);
        top_panel.setAlignmentX(0.0f);
        Dimension panel_max_size = top_panel.getPreferredSize();
        panel_max_size.width = Short.MAX_VALUE;
        top_panel.setMaximumSize(panel_max_size);
        super.add(top_panel);
        TextAreaBuffer textbuf = new TextAreaBuffer(tree_view, y_colnames);
        textbuf.setEndRowIDsText(topo, rowID_start, rowID_final);
        if (clicked_obj instanceof CategoryTimeBox) {
            textbuf.setCategoryTimeBoxText((CategoryTimeBox)clicked_obj);
        } else {
            textbuf.setTimeAveBoxText((TimeAveBox)clicked_obj);
        }
        textbuf.finalized();
        int num_cols = textbuf.getColumnCount();
        int num_rows = textbuf.getRowCount();
        JTextArea text_area = new JTextArea(textbuf.toString());
        int adj_num_cols = Routines.getAdjNumOfTextColumns(text_area, num_cols);
        num_cols = (int)Math.ceil((double)adj_num_cols * 85.0 / 100.0);
        text_area.setColumns(num_cols);
        text_area.setRows(num_rows);
        text_area.setEditable(false);
        text_area.setLineWrap(true);
        JScrollPane scroller = new JScrollPane(text_area);
        scroller.setAlignmentX(0.0f);
        super.add(scroller);
    }

    private class TextAreaBuffer {
        private JTree tree_view;
        private String[] y_colnames;
        private StringBuffer strbuf;
        private String strbuf2str;
        private int num_cols;
        private int num_rows;

        public TextAreaBuffer(JTree in_tree_view, String[] in_y_colnames) {
            this.tree_view = in_tree_view;
            this.y_colnames = in_y_colnames;
            this.strbuf = new StringBuffer();
            this.strbuf2str = null;
            this.num_cols = 0;
            this.num_rows = 0;
        }

        public void finalized() {
            this.strbuf2str = this.strbuf.toString();
            int num_lines = this.getNumOfLines();
            this.num_rows = num_lines <= 3 ? 3 : 4;
        }

        public int getColumnCount() {
            return this.num_cols;
        }

        public int getRowCount() {
            return this.num_rows;
        }

        public String toString() {
            return this.strbuf2str;
        }

        private int getNumOfLines() {
            if (this.strbuf2str != null) {
                int num_lines = 1;
                int ipos = 0;
                int str_length = this.strbuf2str.length();
                while (ipos >= 0 && ipos < str_length) {
                    if ((ipos = this.strbuf2str.indexOf(10, ipos)) < 0) continue;
                    ++num_lines;
                    ++ipos;
                }
                return num_lines;
            }
            return -1;
        }

        public void setEndRowIDsText(Topology topo, int rowID_start, int rowID_final) {
            if (topo.isArrow()) {
                int idx;
                StringBuffer linebuf = new StringBuffer("Between");
                Object[] y_labels = this.tree_view.getPathForRow(rowID_start).getPath();
                for (idx = 1; idx < y_labels.length; ++idx) {
                    linebuf.append(" " + this.y_colnames[idx - 1] + "=" + y_labels[idx]);
                }
                if (this.num_cols < linebuf.length()) {
                    this.num_cols = linebuf.length();
                }
                ++this.num_rows;
                this.strbuf.append(linebuf.toString());
                linebuf = new StringBuffer("   and   ");
                y_labels = this.tree_view.getPathForRow(rowID_final).getPath();
                for (idx = 1; idx < y_labels.length; ++idx) {
                    linebuf.append(" " + this.y_colnames[idx - 1] + "=" + y_labels[idx]);
                }
                if (this.num_cols < linebuf.length()) {
                    this.num_cols = linebuf.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + linebuf.toString());
            } else {
                StringBuffer linebuf = new StringBuffer("At");
                Object[] y_labels = this.tree_view.getPathForRow(rowID_start).getPath();
                for (int idx = 1; idx < y_labels.length; ++idx) {
                    linebuf.append(" " + this.y_colnames[idx - 1] + "=" + y_labels[idx]);
                }
                if (this.num_cols < linebuf.length()) {
                    this.num_cols = linebuf.length();
                }
                ++this.num_rows;
                this.strbuf.append(linebuf.toString());
            }
        }

        private int getPrintStatus(Topology topo) {
            if (topo.isState()) {
                if (SummaryState.isDisplayTypeEqualWeighted()) {
                    return 0;
                }
                if (SummaryState.isDisplayTypeExclusiveRatio()) {
                    return 2;
                }
                return 1;
            }
            return 1;
        }

        public void setCategoryTimeBoxText(CategoryTimeBox typebox) {
            CategoryWeightF twgf = typebox.getCategoryWeightF();
            int print_status = this.getPrintStatus(twgf.getCategory().getTopology());
            ++this.num_rows;
            this.strbuf.append("\n" + CategoryWeightF.getPrintTitle(print_status));
            String twgf_str = twgf.toInfoBoxString(print_status);
            if (this.num_cols < twgf_str.length()) {
                this.num_cols = twgf_str.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + twgf_str);
        }

        public void setTimeAveBoxText(TimeAveBox avebox) {
            CategoryTimeBox[] typeboxes = avebox.arrayOfCategoryTimeBoxes();
            CategoryWeightF twgf = typeboxes[0].getCategoryWeightF();
            Topology avebox_topo = twgf.getCategory().getTopology();
            StringBuffer linebuf = new StringBuffer("Averaged Number of Real ");
            linebuf.append(avebox_topo + "s = ");
            linebuf.append(nfmt.format(avebox.getAveNumOfRealObjects()));
            if (this.num_cols < linebuf.length()) {
                this.num_cols = linebuf.length();
            }
            ++this.num_rows;
            this.strbuf.append("\n" + linebuf.toString());
            int print_status = this.getPrintStatus(avebox_topo);
            ++this.num_rows;
            this.strbuf.append("\n" + CategoryWeightF.getPrintTitle(print_status));
            for (int idx = 0; idx < typeboxes.length; ++idx) {
                twgf = typeboxes[idx].getCategoryWeightF();
                String twgf_str = twgf.toInfoBoxString(print_status);
                if (this.num_cols < twgf_str.length()) {
                    this.num_cols = twgf_str.length();
                }
                ++this.num_rows;
                this.strbuf.append("\n" + twgf_str);
            }
        }
    }
}

