/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.output;

import base.drawable.Category;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import logformat.clogTOdrawable.InputLog;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TraceName;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeTrunk;

public class ClogToSlog2 {
    private static short num_children_per_node = 0;
    private static int leaf_bytesize = 0;
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static boolean continue_when_violation;
    private static String help_msg;

    public static final void main(String[] args) {
        Kind next_kind;
        double prev_dobj_endtime = Double.NEGATIVE_INFINITY;
        out_filename = null;
        ClogToSlog2.parseCmdLineArgs(args);
        if (out_filename == null) {
            out_filename = TraceName.getDefaultSLOG2Name(in_filename);
        }
        CategoryMap objdefs = new CategoryMap();
        HashMap<Topology, Category> shadefs = new HashMap<Topology, Category>();
        long Nobjs = 0L;
        Date time1 = new Date();
        InputLog dobj_ins = new InputLog(in_filename);
        OutputLog slog_outs = new OutputLog(out_filename);
        if (leaf_bytesize > 0) {
            slog_outs.setTreeLeafByteSize(leaf_bytesize);
        }
        if (num_children_per_node > 0) {
            slog_outs.setNumChildrenPerNode(num_children_per_node);
        }
        TreeTrunk treetrunk = new TreeTrunk(slog_outs, shadefs);
        Date time2 = new Date();
        while ((next_kind = dobj_ins.peekNextKind()) != Kind.EOF) {
            Category objdef;
            if (next_kind == Kind.TOPOLOGY) {
                Topology topo = dobj_ins.getNextTopology();
                objdef = Category.getShadowCategory(topo);
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                shadefs.put(topo, objdef);
                continue;
            }
            if (next_kind == Kind.CATEGORY) {
                objdef = dobj_ins.getNextCategory();
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                continue;
            }
            if (next_kind == Kind.PRIMITIVE) {
                Primitive prime_obj = dobj_ins.getNextPrimitive();
                prime_obj.resolveCategory(objdefs);
                ++Nobjs;
                if (enable_endtime_check) {
                    double curr_dobj_endtime;
                    if (!prime_obj.isTimeOrdered()) {
                        System.out.println("**** Primitive Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (prev_dobj_endtime > (curr_dobj_endtime = prime_obj.getLatestTime())) {
                        System.err.println("***** Violation of Increasing Endtime Order! *****\n   previous drawable endtime ( " + prev_dobj_endtime + " ) " + " > current drawable endtiime ( " + curr_dobj_endtime + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    prev_dobj_endtime = curr_dobj_endtime;
                }
                treetrunk.addDrawable(prime_obj);
                continue;
            }
            System.err.println("ClogToSlog2: Unrecognized return from peekNextKind() = " + next_kind);
        }
        if (treetrunk.flushToFile()) {
            objdefs.removeUnusedCategories();
            slog_outs.writeCategoryMap(objdefs);
            LineIDMapList lineIDmaps = new LineIDMapList();
            lineIDmaps.add(treetrunk.getIdentityLineIDMap());
            slog_outs.writeLineIDMapList(lineIDmaps);
            slog_outs.close();
            dobj_ins.close();
        } else {
            slog_outs.close();
            dobj_ins.close();
            System.err.println("Error: No drawable is found in the trace " + in_filename);
            File slog_file = new File(out_filename);
            if (slog_file.isFile() && slog_file.exists()) {
                System.err.println("       Removing the remnants of the file " + out_filename + " .....");
                slog_file.delete();
            }
            System.exit(1);
        }
        Date time3 = new Date();
        System.out.println("\n");
        System.out.println("Number of Drawables = " + Nobjs);
        System.out.println("Number of Unmatched Events = " + dobj_ins.getNumberOfUnMatchedEvents());
        System.out.println("Total ByteSize of the logfile = " + dobj_ins.getTotalBytesRead());
        System.out.println("timeElapsed between 1 & 2 = " + (time2.getTime() - time1.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (time3.getTime() - time2.getTime()) + " msec");
    }

    private static int parseByteSize(String size_str) {
        int idxOfKilo = Math.max(size_str.indexOf(107), size_str.indexOf(75));
        int idxOfMega = Math.max(size_str.indexOf(109), size_str.indexOf(77));
        if (idxOfKilo > 0) {
            return Integer.parseInt(size_str.substring(0, idxOfKilo)) * 1024;
        }
        if (idxOfMega > 0) {
            return Integer.parseInt(size_str.substring(0, idxOfMega)) * 1024 * 1024;
        }
        return Integer.parseInt(size_str);
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        in_filename = null;
        enable_endtime_check = false;
        continue_when_violation = false;
        if (argv.length == 0) {
            System.out.println(help_msg);
            System.out.flush();
            System.exit(0);
        }
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    String arg_str;
                    if (argv[idx].equals("-h") || argv[idx].equals("--h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-tc")) {
                        enable_endtime_check = true;
                        continue_when_violation = false;
                        err_msg.append("\n endtime_order_check_exit = true");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-tcc")) {
                        enable_endtime_check = true;
                        continue_when_violation = true;
                        err_msg.append("\n endtime_order_check_stay = true");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-nc")) {
                        arg_str = argv[++idx];
                        num_children_per_node = Short.parseShort(arg_str);
                        err_msg.append("\n number_of_children_per_node = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ls")) {
                        arg_str = argv[++idx];
                        leaf_bytesize = ClogToSlog2.parseByteSize(arg_str);
                        err_msg.append("\n max_byte_size_of_leaf_node = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-o")) {
                        out_filename = argv[++idx].trim();
                        err_msg.append("\n output_filename = " + out_filename);
                        ++idx;
                        if (out_filename.endsWith(".slog2")) continue;
                        System.err.println("Warning: The suffix of the output filename is NOT \".slog2\".");
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + ClogToSlog2.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (ArrayIndexOutOfBoundsException idxerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + ClogToSlog2.indexOrderStr(idx) + " command line argument.");
            idxerr.printStackTrace();
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + ClogToSlog2.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("The Program needs a CLOG filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        help_msg = "Usage: java slog2.output.Clog2Slog [options] clog_filename.\n options: \n\t [-h|--h|-help|--help]             \t Display this message.\n\t [-tc]                             \t Check increasing endtime order,\n\t                                   \t exit when 1st violation occurs.\n\t [-tcc]                            \t Check increasing endtime order,\n\t                                   \t continue when violations occur.\n\t [-nc number_of_children_per_node] \t Default value is 2.\n\t [-ls max_byte_size_of_leaf_node]  \t Default value is 65536.\n\t [-o output_filename_with_slog2_suffix]\n\n note: \"max_byte_size_of_leaf_node\" can be specified with suffix k, K, m or M,\n       where k or K stands for kilobyte, m or M stands for megabyte.\n       e.g. 64k means 65536 bytes.\n";
    }
}

