
#define MW_SET(name,value) g_object_set_data(G_OBJECT(MainWindow),name,(gpointer)value)
#define MW_REF (name,value) g_object_set_data_full(G_OBJECT(MainWindow),name,(gpointer)value);
#define MW_GET(name) g_object_get_data(G_OBJECT(MainWindow),name)

#define MPL_ERROR -1
#define USER_CANCELED 64
#define MPL_TEMP_DIR "/tmp/"
#define CFG_FILE  "options"
#define CFG_DIR "/.mplinux/"
#define CFG_PLAY_LIST "mpman.m3u"
#define CFG_NEW 1
#define CFG_OK 2

#define FLASH 1
#define SMARTCAM 3
#define SMART 2

// Gettext i18n support
#ifdef NLS
#include <libintl.h>
#include <locale.h>
#define _(String) gettext (String)
#endif

#ifndef NLS
#define _(String) String
#endif

#define gettext_noop(String) String
#define N_(String) gettext_noop (String)

struct s_PlayListEntry {
     GString* name;
     GString* ID3name;
	 GString* ID3name_utf8;
     gint filesize;
} ;

typedef struct s_PlayListEntry PlayListEntry;

extern GtkWindow* MainWindow;


void create_main_window( GtkWindow** return_window);
void  create_file_properties_window();
void create_file_info_window();
void create_options_window();
void create_about_window();
gboolean right_treeview_Refresh(GtkWidget *widgy,gpointer user_data);
gboolean StartupConnect(gpointer data);
void menuitem_LoadPlaylist(gpointer callback_data,
			   guint  callback_action,
			   GtkWidget *widget);
void menuitem_SavePlaylist(gpointer callback_data,
			   guint  callback_action,
			   GtkWidget *widget);


typedef void (*CancelFunc)(gboolean a);
typedef float (*ProgressFunc)();

gpointer CreateWaitDialog(GThreadFunc func,gpointer data,
			  CancelFunc cancel_func, ProgressFunc pfunc, gchar* text);


PlayListEntry* pl_New(gchar* name,gchar* ID3name,gint filesize);
void pl_Remove(PlayListEntry* remove);
PlayListEntry* pl_AddFile(gchar* filename);
// must free list after use
GList* pl_AddDirectory(gchar* dirname);
void pl_AddDirectoryCancel(gboolean a);
struct mp3_info* pl_GetMp3Info(gchar* filename);
// must free list after use
GList* pl_LoadList(gchar* filename);
int pl_SaveList(GList* list,gchar* filename);
GList* pl_RandomizeList(guint freemem);
float pl_LoadListProgress();
gchar* strip_path(gchar* filename);

// see playlist.c
void pl_MegaHack(int i);
GList* pl_GetPlayList();

// must free list after use
GList* mpl_RefreshList();
gchar* mpl_ErrorString();
gint  mpl_LastError();
gint mpl_DeleteFile(gint index);
gint mpl_SendFile(gchar* filename,gchar* text);
gboolean mpl_CheckForDevice();
gint mpl_GetFile(gint index,gchar* dirname);
gint mpl_ReorderFiles(gchar* order,guchar size);
void mpl_CloseDevice();
void mpl_SelectMemory(gint a);
void mpl_PrintDebugInfo(gint a);
gint mpl_SendFileNonMp3(gchar* filename);
gint mpl_FormatMedia(char x);
float mpl_GetReadWriteProgress();
void mpl_cancel_operation(gboolean a);
void mpl_set_device_id(int use_id, gchar* vendor, gchar* product);

int cfg_Init();
void cfg_Write(gchar* sec,gchar* name,gchar* value);
char* cfg_Read(gchar* sec,gchar*name,gchar* fallback);
char* cfg_ReadSection(gchar* sec);
void cfg_Save();

void ButtonRelief  (GtkWidget *widget,gpointer data);
#ifdef NLS
gchar* convert_if_needed(gchar* text);
#endif
