#include <iostream>
#include <algorithm>
#include <string>
#include <vector>

#include <wx/string.h>

#include "BasicVolumeFormat.h"

using namespace jcs;
using namespace std;

///
/**
 */
BasicVolumeFormat::BasicVolumeFormat(const char* filename, 
				     const char* header_extension,
				     const char* raw_extension) 
    : mFileName(wxString(filename, wxConvLocal)), 
      mHeaderExtension(wxString(header_extension, wxConvLocal)), 
      mRawExtension(wxString(raw_extension, wxConvLocal))
{
    wxFileName::Mkdir(mFileName.GetPath(wxPATH_GET_VOLUME), 0777, wxPATH_MKDIR_FULL);
}

///
/**
 */
BasicVolumeFormat::~BasicVolumeFormat()
{
    if (mHeaderFile.is_open()) mCloseHeaderFile();
    if (mRawDataFile.is_open()) mCloseRawDataFile();
}


///
/**
   \param mode Open mode for file.
   \return Status code.
*/
int
BasicVolumeFormat::mOpenHeaderFile(std::ios::openmode mode) 
{
    if (!mFileName.IsOk())
	return 0;
    if (mHeaderFile.is_open())
	mHeaderFile.close();

    mHeaderFile.clear();

    mFileName.SetExt(mHeaderExtension);

    std::string filename(mFileName.GetFullPath().mb_str(wxConvLocal));
    mHeaderFile.open(filename.c_str(), mode);

    return mHeaderFile.good();
}


/// Writes 'n_bytes' of 'data'.
/** Overwrites a non-open file, appends to an open file.
    \param data Pointer to data to be written.
    \param n_bytes Number of bytes to write.
    \return Status code, 0 on file failure, 1 on success.
*/
int
BasicVolumeFormat::AppendRawData(char* data, size_t n_bytes)
{
    int retval = 0;
    wxString extUsed;
    ios_base::openmode o_mode = ios::out | ios::binary;

    if (mRawExtension != _T("")) {
	extUsed = mRawExtension;
	o_mode |= ios::trunc;
    }
    else {
	extUsed = mHeaderExtension;
	o_mode |= ios::app;
    }
    mFileName.SetExt(extUsed);

    if (mFileName.IsOk()) {

	if (!mRawDataFile.is_open()) {
	    if (mRawExtension != _T(""))
		mRawDataFile.clear();
	    mRawDataFile.open(mFileName.GetFullPath().mb_str(wxConvLocal), o_mode);
	}

	if (mRawDataFile.good()) {
	    mRawDataFile.write(data, n_bytes);
	    retval = 1;
	}
    }
    return retval;
}
