#ifndef DICOMFILE_TXX_
#define DICOMFILE_TXX_

#include <sstream>
#include <iostream>

#include "DicomFile.h"
#include "Dictionary.h"

#include <wx/utils.h>

using namespace std;

namespace jcs {

// Find dicom element, convert to value of type T
template<class T> int
DicomFile::Find(DicomElement d, T& rValue) 
{
	if (!mInputFile.good()) 
		mInputFile.clear();

	if (!FindElement(d, mInputFile)) {
		return 0;
	}
	mInputFile.seekg(- static_cast<std::streamoff>(d.value_length), 
		std::ios::cur);

	int retval = mReadValue(d, rValue, mInputFile); 
	return retval;
}

// Find dicom element using string from dicom dict.
template<class T> int
DicomFile::Find(const string& s, T& rValue) 
{
	int retval = Find(mDicom->Lookup(s), rValue);
	return retval;
}

template<class T> int
DicomFile::FindInStream(std::istream& input, DicomElement d, T& rValue) 
{
	if (!input.good()) 
		input.clear();

	if (!FindElement(d, input)) {
		return 0;
	}
	input.seekg(- static_cast<std::streamoff>(d.value_length), 
		std::ios::cur);

	int retval = mReadValue(d, rValue, input);
	return retval;
}

///
/** Retrieve data_length bytes of pixel data
    It's up to the caller to send correct type and data_length!
    \param data
    \param data_length
    \param slope
    \param intercept
    \param frame
    \return 1
*/
template<class T> int
DicomFile::PixelData(std::vector<T>& data, std::streamsize data_length, double slope, double intercept, int frame)
{
	if (!mInputFile.is_open()) return 0;
	mInputFile.clear();

	mInputFile.seekg(GetPixelDataStart());
	mInputFile.seekg(data_length * frame,
			 std::ios::cur);

	data.resize(data_length/sizeof(T));
	mInputFile.read(reinterpret_cast<char*>(&data.front()), data_length);

	// This test is not mathematically necessary, but saves a do-nothing
	// iteration through the data.
	if ((slope != 1) || (intercept != 0))
	  for (typename std::vector<T>::iterator it = data.begin(); it != data.end(); ++it)
	    // Casting avoids compiler warnings.
	    *it = static_cast<T>(static_cast<double>(*it) * slope + intercept);

	return 1;
}


///
/** alt version with buffer, used for rgb image 
 */
template<class T> int
DicomFile::PixelData(T* data, std::streamsize data_length)
{
	if (!mInputFile.is_open()) return 0;
	mInputFile.clear();

	mInputFile.seekg(mBeginning);

	DicomElement element;
	mReadNextElement(element, mInputFile);
	while ((mInputFile.good()) && (element.tag != Tag("PixelData"))) {
		mReadNextElement(element, mInputFile);
	} 
	mInputFile.seekg(-data_length, std::ios::cur);

	mInputFile.read(reinterpret_cast<char*>(data), data_length);

	return 1;
}


template<class T> int
DicomFile::mReadValue(DicomElement d, T& rValue, std::istream& input) 
{
	if (!input.good() || (d.value_length == 0))
		return 0;

	std::vector<string> v;
	if (ReadMap.count(d.vr))
		v = ReadMap[d.vr](input, d.value_length);
	else 
		v = ReadMap["UN"](input, d.value_length);
		
	//  remove leading spaces
	v.front().erase(0, v.front().find_first_not_of(' '));

	std::stringstream ss;
	ss << v.front();
	ss >> rValue;

	return 1;
}


// Byte-swapping routine for all types.
template<class T> T
DicomFile::ByteSwap(T value_to_swap) {
	return value_to_swap;
}

}

#endif
