/// DicomTag.cpp
/**
*/

#include "DicomTag.h"

using namespace jcs;

///
/** DicomTags are equal iff both group numbers and element numbers are equal.
*/
bool
DicomTag::operator== (const DicomTag& rhs) const 
{
  return((group == rhs.group) && (element == rhs.element));
}


///
/** DicomTags are not equal if the object references are not equal.
*/
bool
DicomTag::operator!= (const DicomTag& rhs) const 
{
  return !(*this == rhs);
}


///
/** A DicomTag is less than another DicomTag if its group number is less than
    the other's group number.  If group numbers are equal, then compare the
    element numbers.
*/
bool
DicomTag::operator< (const DicomTag& rhs) const
{
  return((group < rhs.group) || ((group == rhs.group) && (element < rhs.element)));
}


///
/** Same as with < operator, but with opposite sense.
*/
bool
DicomTag::operator> (const DicomTag& rhs) const
{
  return((group > rhs.group) || ((group == rhs.group) && (element > rhs.element)));
}

std::istream &
jcs::operator>> (std::istream &in, DicomTag &dt)
{
  in.read((char *)&(dt.group), sizeof(dt.group));
  in.read((char *)&(dt.element), sizeof(dt.element));
  return in;
}

///
/** This is how we stream out a DicomTag.  Form should be like
    '(xxxx,xxxx)', where xxxx is a hexadecimal number.
*/
std::ostream &
jcs::operator<< (std::ostream& out, const DicomTag& rhs)
{
  out << std::hex << '(';
  out.fill('0');
  out.width(4);
  out << rhs.group << ',';
  out.width(4); 
  out << rhs.element << ')' << ' ';
  out << std::dec;
  return out;
}
