/// DicomTag.h
/** Structure represents a DICOM tag as a group and element tuple.
*/

#ifndef DICOMTAG_H_
#define DICOMTAG_H_

#include <map>
#include <vector>
#include <string>
#include <istream>
#include <iostream>

#include <wx/defs.h>

namespace jcs {
  struct DicomTag {
    
    DicomTag() {}
    DicomTag(wxUint16 g, wxUint16 e) : group(g), element(e) {}
    
    wxUint16 group;
    wxUint16 element;
    
    bool operator== (const DicomTag &rhs) const;
    bool operator!= (const DicomTag &rhs) const;
    bool operator<  (const DicomTag &rhs) const;
    bool operator>  (const DicomTag &rhs) const;
    friend std::istream &operator>>(std::istream &in, DicomTag &dt);
  };
  std::istream &operator>>(std::istream &in, DicomTag &dt);
  std::ostream &operator<<( std::ostream &out, const DicomTag &rhs );
}

#endif
