/// MetaHeader.cpp
/**
*/

#include "MetaHeader.h"

using namespace jcs;

bool
MetaHeader::isMetaHeaderElement(DicomElementInstance de)
{
  bool retval = false;
  if (de.tag.group == 0x0002) {
    retval = true;
  }
  return retval;
}

wxUint8
MetaHeader::getMainTransferSyntaxCode()
{
  wxUint8 retval;
  std::vector<DicomElementInstance>::iterator it = mhElements.begin();
  std::vector<DicomElementInstance>::iterator it_end = mhElements.end();
  for (; it < it_end; ++it) {
    //std::cout << "Meta compare: " << it->tag << " and " << DT_MFTRANSFERSYNTAX << std::endl;
    if (it->tag == DT_MFTRANSFERSYNTAX) {
      //std::cout << "MF syntax: " << it->value << std::endl;
      if (it->value.compare(LEE_UID))
        retval = LEE_CODE;
      if (it->value.compare(LEI_UID))
        retval = LEI_CODE;
      if (it->value.compare(BEE_UID))
        retval = BEE_CODE;
      break;
    }
  }
  //std::cout << "MF syntax: " << retval << std::endl;
  return retval;
}


std::istream &
jcs::operator>> (std::istream &in, MetaHeader &mh)
{
  DicomElementInstance de;
  de.transferSyntaxCode = LEE_CODE;
  std::streampos save_position;
  while (1) {
    save_position = in.tellg();
    in >> de;
    //std::cout << "metaheader de: " << de.tag << std::endl;
    if (mh.isMetaHeaderElement(de)) {
      mh.mhElements.push_back(de);
      de.value.assign("");
    }
    else {
      in.seekg(save_position);
      break;
    }
  }
  return in;
}
