//cdt /// OptionsDialogs.cpp
//cdt /**
//cdt  */
//cdt 
//cdt #include <string>
//cdt #include <wx/wxprec.h>
//cdt #include <wx/spinctrl.h>
//cdt #include <wx/statline.h>
//cdt 
//cdt #include "OptionsDialogs.h"
//cdt #include "OutputterBase.h"
//cdt #include "OutputFactory.h"
//cdt #include "NewSpmOutputter.h"
//cdt #include "NewMetaOutputter.h"
//cdt #include "NewBvOutputter.h"
//cdt #include "NiftiOutputter.h"
//cdt #include "AnalyzeOutputter.h"
//cdt 
//cdt using namespace jcs;
//cdt 
//cdt int 
//cdt jcs::ShowOptionsDlg(int type, OutputterBase* outputter)
//cdt {
//cdt   bool rebuild = 0;
//cdt 
//cdt   switch (type) {
//cdt 
//cdt   case OutputFactory::SPM : {
//cdt     SpmOptionsDlg* dlg = new SpmOptionsDlg(dynamic_cast<NewSpmOutputter*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy();}
//cdt     break;
//cdt 
//cdt   case OutputFactory::META : {
//cdt     MetaOptionsDlg* dlg = new MetaOptionsDlg(dynamic_cast<NewMetaOutputter*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy(); }
//cdt     break;
//cdt 
//cdt   case OutputFactory::NIFTI : {
//cdt     NiftiOptionsDlg* dlg = new NiftiOptionsDlg(dynamic_cast<NiftiOutputterBase*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy(); }
//cdt     break;
//cdt 
//cdt   case OutputFactory::ANALYZE : {
//cdt     AnalyzeOptionsDlg* dlg = new AnalyzeOptionsDlg(dynamic_cast<AnalyzeOutputter*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy(); }
//cdt     break;
//cdt 
//cdt   case OutputFactory::FSL : {
//cdt     NiftiOptionsDlg* dlg = new NiftiOptionsDlg(dynamic_cast<NiftiOutputterBase*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy(); }
//cdt     break;
//cdt 
//cdt   case OutputFactory::BV : {
//cdt     BvOptionsDlg* dlg = new BvOptionsDlg(dynamic_cast<NewBvOutputter*>(outputter));
//cdt     if (dlg->ShowModal() == wxID_OK) rebuild = dlg->NeedsRebuild();
//cdt     dlg->Destroy(); }
//cdt     break;
//cdt 
//cdt   default : {
//cdt     NoOptionsDlg* dlg = new NoOptionsDlg();
//cdt     dlg->ShowModal();
//cdt     dlg->Destroy(); }
//cdt   }
//cdt 
//cdt   return static_cast<int>(rebuild);
//cdt }
//cdt 
//cdt 
//cdt int 
//cdt jcs::ShowOverride(int type, OutputterBase* outputter, const string& series_uid)
//cdt {
//cdt   int needsRebuild = 0;
//cdt   if (type == OutputFactory::BV) {
//cdt     wxLogMessage(_("It is not possible override default options for BrainVoyager output."));
//cdt     return needsRebuild;
//cdt   }
//cdt   Basic3DOutputter* basicOutputter = dynamic_cast<Basic3DOutputter*>(outputter);
//cdt   OverrideDlg dlg;
//cdt   dlg.dimCheck->SetValue(basicOutputter->GetDimensionality(series_uid) == 4);
//cdt   dlg.skipSpin->SetValue(basicOutputter->GetSkip(series_uid));
//cdt   if (dlg.ShowModal() == wxID_OK) {
//cdt     if (dlg.dimCheck->GetValue())
//cdt       basicOutputter->SetDimensionality(series_uid, 4);
//cdt     else
//cdt       basicOutputter->SetDimensionality(series_uid, 3);
//cdt     basicOutputter->SetSkip(series_uid, dlg.skipSpin->GetValue());
//cdt     needsRebuild = 1;
//cdt   }
//cdt   return needsRebuild;  
//cdt }
//cdt 