#pragma warning( disable : 4786 )

#if defined(__WXGTK__) || defined(__WXMOTIF__)
        #include <wx/wx.h>
#endif

#include <wx/wxprec.h>
#include <wx/frame.h>

#include <vector>
#include <string>
#include <algorithm>
#include <functional>

#include "InfoFrame.h"

using std::vector;
using std::string;


InfoFrame::InfoFrame(wxWindow* parent, vector<string> info) 
: wxFrame(parent, -1, _T("Series info"))
{
	wxBoxSizer* frameSizer = new wxBoxSizer(wxVERTICAL);

	mTextCtrl = new wxTextCtrl(this, -1, _T(""),
		wxDefaultPosition, wxSize(400,400), wxTE_MULTILINE | 
		wxTE_READONLY | wxTE_RICH);

	frameSizer->Add(mTextCtrl, 1, wxEXPAND);

//	std::for_each(info.begin(), info.end(),
//		std::bind1st(std::mem_fun1(&InfoFrame::AddString), this));

	vector<string>::iterator it = info.begin();
	vector<string>::iterator it_end = info.end();
	while (it != it_end) {
		AddString(*it);
		++it;
	}

	SetSizer(frameSizer);

	frameSizer->Fit(this);

}

int
InfoFrame::AddString(string& s)
{
	mTextCtrl->AppendText(wxString(s.c_str(), wxConvLocal));
	mTextCtrl->AppendText(_T("\n"));

	return 1;
}
