/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CFORMMOTIONMODEL_H
#define CFORMMOTIONMODEL_H

//(*Headers(CFormMotionModel)
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/notebook.h>
#include <wx/button.h>
#include <wx/radiobut.h>
#include <wx/panel.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)

// The "custom class" mpWindow, from the wxMathPlot libray by David Schalig
//  See http://sourceforge.net/projects/wxmathplot
#include <mrpt/otherlibs/mathplot/mathplot.h>

class CFormMotionModel: public wxDialog
{
public:

    CFormMotionModel(wxWindow* parent,wxWindowID id = -1);
    virtual ~CFormMotionModel();

    //(*Identifiers(CFormMotionModel)
    static const long ID_STATICTEXT1;
    static const long ID_BUTTON1;
    static const long ID_STATICTEXT4;
    static const long ID_TEXTCTRL1;
    static const long ID_STATICTEXT2;
    static const long ID_STATICTEXT3;
    static const long ID_TEXTCTRL2;
    static const long ID_STATICTEXT5;
    static const long ID_STATICTEXT6;
    static const long ID_TEXTCTRL3;
    static const long ID_STATICTEXT7;
    static const long ID_STATICTEXT26;
    static const long ID_TEXTCTRL15;
    static const long ID_STATICTEXT27;
    static const long ID_STATICTEXT8;
    static const long ID_TEXTCTRL4;
    static const long ID_STATICTEXT9;
    static const long ID_STATICTEXT10;
    static const long ID_TEXTCTRL5;
    static const long ID_STATICTEXT11;
    static const long ID_BUTTON10;
    static const long ID_BUTTON2;
    static const long ID_BUTTON8;
    static const long ID_PANEL2;
    static const long ID_STATICTEXT12;
    static const long ID_TEXTCTRL6;
    static const long ID_STATICTEXT13;
    static const long ID_STATICTEXT14;
    static const long ID_TEXTCTRL7;
    static const long ID_STATICTEXT15;
    static const long ID_STATICTEXT16;
    static const long ID_TEXTCTRL8;
    static const long ID_STATICTEXT17;
    static const long ID_STATICTEXT18;
    static const long ID_TEXTCTRL9;
    static const long ID_STATICTEXT19;
    static const long ID_STATICTEXT20;
    static const long ID_TEXTCTRL10;
    static const long ID_STATICTEXT21;
    static const long ID_STATICTEXT29;
    static const long ID_TEXTCTRL17;
    static const long ID_STATICTEXT30;
    static const long ID_STATICTEXT31;
    static const long ID_TEXTCTRL18;
    static const long ID_STATICTEXT32;
    static const long ID_BUTTON11;
    static const long ID_BUTTON3;
    static const long ID_BUTTON9;
    static const long ID_PANEL3;
    static const long ID_NOTEBOOK1;
    static const long ID_RADIOBUTTON1;
    static const long ID_BUTTON6;
    static const long ID_CHECKBOX1;
    static const long ID_STATICTEXT34;
    static const long ID_TEXTCTRL19;
    static const long ID_STATICTEXT33;
    static const long ID_TEXTCTRL20;
    static const long ID_RADIOBUTTON2;
    static const long ID_STATICTEXT22;
    static const long ID_TEXTCTRL11;
    static const long ID_BUTTON4;
    static const long ID_BUTTON7;
    static const long ID_STATICTEXT23;
    static const long ID_TEXTCTRL12;
    static const long ID_BUTTON5;
    static const long ID_STATICTEXT25;
    static const long ID_TEXTCTRL13;
    static const long ID_TEXTCTRL14;
    static const long ID_TEXTCTRL16;
    static const long ID_PANEL1;
    static const long ID_STATICTEXT24;
    static const long ID_CUSTOM1;
    static const long ID_STATICTEXT28;
    static const long ID_CUSTOM2;
    //*)

protected:

    //(*Handlers(CFormMotionModel)
    void OnbtnOkClick(wxCommandEvent& event);
    void OnbtnGaussOKClick(wxCommandEvent& event);
    void OnbtnThrunOkClick(wxCommandEvent& event);
    void OnInit(wxInitDialogEvent& event);
    void OnrbFileSelect(wxCommandEvent& event);
    void OnrbLoadedSelect(wxCommandEvent& event);
    void OnbtnGetFromCurrentClick(wxCommandEvent& event);
    void OnbtnSimulateClick(wxCommandEvent& event);
    void OnbtnSimulateThrunClick(wxCommandEvent& event);
    void OnbtnResetGaussClick(wxCommandEvent& event);
    void OnButton1Click(wxCommandEvent& event);
    void OnbtnResetThrunClick(wxCommandEvent& event);
    void OnbtnPickInputClick(wxCommandEvent& event);
    void OnbtnPickOutClick(wxCommandEvent& event);
    void OnbtnGetFromFileClick(wxCommandEvent& event);
    void OncbAllClick(wxCommandEvent& event);
    //*)

public:

    //(*Declarations(CFormMotionModel)
    wxTextCtrl* edG_A2;
    wxStaticText* StaticText24;
    wxTextCtrl* txtAy;
    wxStaticText* StaticText22;
    wxTextCtrl* edRangeFrom;
    wxTextCtrl* edG_A1;
    wxFlexGridSizer* FlexGridSizer8;
    wxTextCtrl* txtAphi;
    wxFlexGridSizer* FlexGridSizer1;
    wxFlexGridSizer* FlexGridSizer2;
    wxButton* btnGetFromCurrent;
    wxPanel* Panel1;
    wxStaticText* StaticText21;
    wxStaticText* StaticText13;
    wxStaticText* StaticText14;
    wxStaticText* StaticText15;
    wxBoxSizer* BoxSizer3;
    wxTextCtrl* edNumParts;
    wxCheckBox* cbAll;
    wxButton* btnPickInput;
    wxTextCtrl* edAddXY;
    wxStaticText* StaticText32;
    wxStaticText* StaticText17;
    wxStaticText* StaticText28;
    wxTextCtrl* edG_A4;
    wxTextCtrl* edA3;
    wxButton* btnSimulateThrun;
    wxTextCtrl* txtOutputFile;
    wxFlexGridSizer* FlexGridSizer7;
    wxStaticText* StaticText20;
    wxStaticText* StaticText18;
    wxFlexGridSizer* FlexGridSizer4;
    wxStaticText* StaticText1;
    wxButton* btnPickOut;
    wxRadioButton* rbFile;
    wxStaticText* StaticText10;
    wxStaticText* StaticText16;
    wxTextCtrl* edRangeTo;
    wxFlexGridSizer* FlexGridSizer6;
    wxPanel* Panel2;
    wxStaticText* StaticText3;
    wxButton* btnOk;
    wxButton* btnThrunOk;
    wxStaticText* StaticText23;
    wxFlexGridSizer* FlexGridSizer3;
    wxNotebook* PageControl1;
    wxTextCtrl* edG_A3;
    wxButton* btnSimulate;
    wxTextCtrl* txtAx;
    wxButton* btnResetGauss;
    wxStaticText* StaticText8;
    wxStaticText* StaticText34;
    wxStaticText* StaticText12;
    wxBoxSizer* BoxSizer4;
    wxButton* btnResetThrun;
    wxButton* btnGetFromFile;
    wxTextCtrl* edMinStdPHI;
    wxPanel* Panel3;
    wxStaticText* StaticText7;
    mpWindow* plotSamplesPHI;
    wxTextCtrl* edA1;
    mpWindow* plotSamplesXY;
    wxRadioButton* rbLoaded;
    wxStaticText* StaticText4;
    wxStaticText* StaticText5;
    wxStaticText* StaticText30;
    wxStaticText* StaticText2;
    wxStaticText* StaticText27;
    wxButton* btnGaussOK;
    wxStaticText* StaticText26;
    wxTextCtrl* edMinStdXY;
    wxStaticText* StaticText6;
    wxTextCtrl* edAddPhi;
    wxTextCtrl* edA2;
    wxTextCtrl* txtInputFile;
    wxStaticText* StaticText19;
    wxStaticText* StaticText29;
    wxFlexGridSizer* FlexGridSizer5;
    wxTextCtrl* edA4;
    wxStaticText* StaticText9;
    wxStaticText* StaticText33;
    wxStaticText* StaticText31;
    wxStaticText* StaticText11;
    wxStaticText* StaticText25;
    wxBoxSizer* BoxSizer5;
    wxStaticBoxSizer* StaticBoxSizer1;
    //*)

    // Layers for the 2D graphs:
    mpFXYVector     *lyAction2D_XY;
    mpFXYVector     *lyAction2D_PHI;

private:
    void loadFromGaussian();
    void loadFromThrun();

    void applyToLoadedRawlog();
    void applyToRawlogFile();

    void drawRandomSamples();
    void showOptionsInDialog();

    DECLARE_EVENT_TABLE()
};

#endif
