/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_math_H
#define _mrpt_math_H

#include "math/distributions.h"
#include "math/fourier.h"
#include "math/utils.h"
#include "math/vector_ops.h"

#include "math/CLevenbergMarquardt.h"
#include "math/CQuaternion.h"

#include "math/CHistogram.h"
#include "math/CMatrix.h"
#include "math/CMatrixD.h"
#include "math/CMatrixB.h"
#include "math/CMatrixTemplateObjects.h"

#include "math/CGraphPartitioner.h"
#include "math/CPolygon.h"
#include "math/geometry.h"
#include "math/CVectorTemplate.h"

#include "math/CSplineInterpolator1D.h"
#endif
