/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace mrpt::system;
using namespace std;

void TestHist()
{
	CHistogram              hist(0,100,10);
	hist.add(86);
	hist.add(7);
	hist.add(45);

	cout << "Histogram test:" << endl;
	cout << "Should be 1: " << hist.getBinCount(0) << endl;          // Result: "1"
	cout << "Should be 0.33: " << hist.getBinRatio(0) << endl;          // Result: "0.33"
}

// ------------------------------------------------------
//				TestRandomGenerators
// ------------------------------------------------------
void TestRandomGenerators()
{
	size_t i;

	mrpt::random::Randomize();

	// Uniform numbers integers:
	{
		FILE	*f=os::fopen("samples_uniform_int.txt","wt");
		for (i=0;i<10000;i++)
			fprintf(f,"%u\n", mrpt::random::RandomUniInt() );
		os::fclose(f);
	}

	// Uniform numbers:
	{
		FILE	*f=os::fopen("samples_uniform.txt","wt");
		for (i=0;i<10000;i++)
			fprintf(f,"%f\n", mrpt::random::RandomUni(-1.0f,1.0f) );
		os::fclose(f);
	}

	// Gaussian
	{
		FILE	*f=os::fopen("samples_gaussian.txt","wt");

		for (i=0;i<10000;i++)
			fprintf(f,"%f ", mrpt::random::RandomNormal(5,3) );
		os::fclose(f);
	}

	// Gaussian multidimensional
	{
		FILE	*f=os::fopen("samples_mvg.txt","wt");
		CMatrix		cov(2,2);
		cov(0,0) = 1e-1f;
		cov(0,1) = -0.06f;
		cov(1,0) = -0.06f;
		cov(1,1) = 1e-1f;

		vector_float	x;
		mrpt::random::Randomize();

		for (i=0;i<10000;i++)
		{
			mrpt::random::randomNormalMultiDimensional(cov,x);
			for (int d=0;d<2;d++)
				fprintf(f,"%f ", x[d] );
			fprintf(f,"\n");
		}
		os::fclose(f);

		f=os::fopen("samples_mvg_method2.txt","wt");
		std::vector<vector_float>	xs;
		mrpt::random::randomNormalMultiDimensionalMany(cov,10000, xs);
		for (i=0;i<xs.size();i++)
		{
			for (int d=0;d<2;d++)
				fprintf(f,"%f ", xs[i][d] );
			fprintf(f,"\n");
		}
		os::fclose(f);

	}
}

// ------------------------------------------------------
//						MAIN
// ------------------------------------------------------
int main()
{
	try
	{
		TestHist();
		TestRandomGenerators();

		return 0;
	} catch (std::exception &e)
	{
		std::cout << "MRPT exception caught: " << e.what() << std::endl;
		return -1;
	}
	catch (...)
	{
		printf("Untyped exception!!");
		return -1;
	}
}

