/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
// Cam.cpp: implementation of the CCam class.
//

#include "Cam.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction

CCam::CCam()
{
    capture = NULL;
}

CCam::~CCam()
{
	close();
}

//////////////////////////////////////////////////////////////////////

void CCam::open()
{
	open(0);
}

void CCam::open(int index)
{
	if(!isOpen())
	{
		capture = cvCaptureFromCAM(index);
	}
}

void CCam::open(const char* file)
{
	if(!isOpen())
	{
		capture = cvCaptureFromFile(file);
	}
}

void CCam::close()
{
	if(isOpen())
		cvReleaseCapture(&capture);
}

bool CCam::isOpen()
{
	return (capture != NULL);
}

//////////////////////////////////////////////////////////////////////

IplImage *CCam::getFrame()
{
	if(isOpen())
		return cvQueryFrame(capture);
	return NULL;
}

//////////////////////////////////////////////////////////////////////

CvCapture *CCam::getCapture()
{
	if(isOpen())
		return capture;
	return NULL;
}

//////////////////////////////////////////////////////////////////////

double CCam::getPosMSec()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_POS_MSEC);
	return 0;
}

double CCam::getPosFrames()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_POS_FRAMES);
	return 0;
}

double CCam::getPosAVIRatio()
{
	if(isOpen())
		return (int)cvGetCaptureProperty(capture, CV_CAP_PROP_POS_AVI_RATIO);
	return 0;
}

double CCam::getWidth()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_FRAME_WIDTH);
	return 0;
}

double CCam::getHeight()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_FRAME_HEIGHT);
	return 0;
}

double CCam::getFPS()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_FPS);
	return 0;
}

double CCam::getFourCC()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_FOURCC);
	return 0;
}

double CCam::getFrameCount()
{
	if(isOpen())
		return cvGetCaptureProperty(capture, CV_CAP_PROP_FRAME_COUNT);
	return 0;
}

void CCam::setPosMSec(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_POS_MSEC, value);
}

void CCam::setPosFrames(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_POS_FRAMES, value);
}

void CCam::setPosAVIRatio(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_POS_AVI_RATIO, value);
}

void CCam::setWidth(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_FRAME_WIDTH, value);
}

void CCam::setHeight(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_FRAME_HEIGHT, value);
}

void CCam::setFPS(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_FPS, value);
}

void CCam::setFourCC(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_FOURCC, value);
}

void CCam::setFrameCount(double value)
{
	if(isOpen())
		cvSetCaptureProperty(capture, CV_CAP_PROP_FRAME_COUNT, value);
}

void CCam::openVideoFormatDlg()
{
    if(isOpen())
    {
		//cvCapDlgVideoFormat(capture);
    }
}

void CCam::openVideoSourceDlg()
{
    if(isOpen())
    {
		//cvCapDlgVideoSource(capture);
    }
}
