/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2004-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

/** \page ChangeLog Change Log
 *

<p> <b>Note:</b> <i>If you are displaying a local version of this page and you have not built the whole HTML documentation, the links above will be broken. Either build the documentation invoking <code>make documentation_html</code> or browse it on-line <a href="http://babel.isa.uma.es/mrpt/" target="_blank">here</a>.</i></p>

  <a name="0.6.5">
  <h2>Version 0.6.5: Released 8-Feb-2009.</h2></a>
	- New method for 3D-ICP, aligning pairs of 3D point clouds using a KD-tree for looking for correspondences and Horn's equation for each iteration. See the class mrpt::slam::CICP, mrpt::slam::CMetricMapsAlignmentAlgorithm::Align3D, and the <a href="http://babel.isa.uma.es/mrpt/index.php/3D-ICP_Example" >tutorial page</a>.
	- Added class COpenGLStandardObject to render custom objects using OpenGL primitives like GL_TRIANGLES or GL_QUAD_STRIP (Pablo Moreno).
	- CText now accepts color changes (Pablo Moreno).
	- Added "contains" method for CSetOfObjects (Pablo Moreno).
	- Added methods for loading matrices from MATLAB-like strings. See  mrpt::math::CMatrixTemplate<T>::fromMatlabStringFormat  and mrpt::utils::CConfigFileBase::read_matrix.
	- New method for computing the mahalanobis distance. See mrpt::math::mahalanobisDistance
	- Levenberg-Marquardt and many other functions in mrpt::random converted into templates.
	- Added some minor methods to graphic classes, especially CSetOfLines (Pablo Moreno).
	- Matrix's method to save as plain text has been extended with the possibility of adding user comments and selecting the output format. See  mrpt::math::TMatrixTextFileFormat.
	- Added ray trace simulation methods to CRenderizable and every children class except for C3DSScene, CEllipsoid, CCylinder, CGeneralizedCylinder, CPolyhedron and some classes which don't represent any surfaced object (Pablo Moreno).
	- Added some classes to mrpt::opengl namespace (Pablo Moreno):
		- CAngularObservationMesh to represent a 3D world obtained from a set of traced rays.
		- CCylinder to represent a cylinder, cone or truncated cylinder.
		- CGeneralizedCylinder to represent a generalized cylinder with an axis roughly perpendicular to the Z coordinate.
		- CPolyhedron to represent any object without curves. Includes methods to create common polyhedron, although still lacks some geometric methods.
	- CRenderizable::setColor method now works properly (affecting every child) when used in a CSetOfObjects or CSetOfTriangles (Pablo Moreno).
	- Added method mrpt::CMatrixTemplateNumeric::rank to calculate the rank of a matrix (Pablo Moreno).
	- mrpt::gui windows now correctly detect key-strokes on both the console and the windows themselves. Key codes can be obtained from the method mrpt::gui::CDisplayWindow::waitForKey
	- Header files defining the mrpt fonts (used in mrpt::utils::CMRPTCanvas) have been removed from the external headers and are internal now.
	- OpenGL objects now have a scale factor. See mrpt::opengl::CRenderizable::setScale
	- Added type mrpt::math::CMatrixLongDouble for matrices of "long double" (becomes "double" if the compiler does not suppor them).
	- New namespaces:
		- mrpt::vision::pinhole with functions related to camera projection models.
		- mrpt::utils::metaprogramming for grouping the metaprogramming classes.
	- Points and poses constructors from other classes that imply a loss of information are defined as explicit, e.g. CPose3D -> CPose2D, etc...
	- Fixed unnecessary link dependencies on 3ds,zlib & ann libs when linking as DLL in Windows.
	- Quick method mrpt::opengl::COpenGLScene::saveToFile to save 3D scenes.
	- New method for automated camera calibration: mrpt::vision::checkerBoardCameraCalibration
	- Important changes to improve the design of mrpt::opengl classes: "render" method is "const", more set/get methods instead of public members, etc.
	- New exception class mrpt::utils::CExceptionEOF, used to distinguish between normal and erroneous EOFs found while de-serializing objects from a stream.
	- Added method for RTK GPS path reconstruction: mrpt::topography::path_from_rtk_gps
	- New math methods:  mrpt::math::unwrap2PiSequence, mrpt::math::averageWrap2Pi
	- Added template function mrpt::utils::find_in_vector for searching an element in any std::vector container (like "find" in other containers).
	- New interpolation methods for 1D functions: mrpt::math::interpolate2points, mrpt::math::leastSquareLinearFit.
	- CStream::printf now correctly returns an "int" instead of "void".
	- Types vector_XXX moved from global to "mrpt" namespace.
	- New color types mrpt::utils::TColor & mrpt::utils::TColorf.
	- Added support for exclusion areas to mark sensed point as invalid in laser scanners. See C2DRangeFinderAbstract::loadExclusionAreas
	- New method CPose3D::composePoint for more efficient 3D pose+point composition.
	- New examples:
		- icp3D: Demonstration of usage for 3D-ICP.
		- rayTrace: Demo of 3D ray tracing (Pablo Moreno).
		- leastSquares: Demonstration of linear least squares interpolation.
	- SceneViewer3D:
		- New menu action "Take snapshot" (F2).
	- RawLogViewer:
		- New combo-box for selecting among different, automatically detected paths for external images. For example, this allows quickly changing between rectified and original images.
		- All I/O file operations now support the gz-compressed format.
		- Edit dialog: Support for multiple selections instead of the old combos.
		- Menu "regenerate GPS" timestamps now allows operating over several sensor labels at once.
		- "Raw Map" module: Now builds 3D maps from sequences with 3 RTK GPS.
	- Support for configuration blocks in rawlogs. See mrpt::slam::CRawlog::getCommentTextAsConfigFile
	- Many improvements in the CMake build system for Linux systems, as part of the Fedora package review process (Thanks to Mamoru Tasaka).
	- BUG FIXES:
		- Error when compiling without GL/GLUT under Linux (Thanks to Chun-Wei for reporting).
		- Wrong computation of the likelihood in COccupancyGridMap2D::computeObservationLikelihood_CellsDifference (Thanks to Fabian Menges, SF <a href="https://sourceforge.net/tracker2/?func=detail&atid=993006&aid=2570053&group_id=205280" >2570053</a>).
		- mrpt::utils::ObjectToString won't really save the object as a string.
		- mrpt::utils::format now works for strings of arbitrarily large lengths.
		- Visual Studio: Exception when mrpt::utils::format tries to generate a too long string.
		- Wrong name of mrpt-zlib libs when compiling without wxWidgets and as DLL.
		- Compilation of app grid-matching fails (SF <a href="https://sourceforge.net/tracker2/?func=detail&aid=2490011&group_id=205280&atid=993006" >2490011</a>, Fabian Menges).
		- CPose3DInterpolator: Solved spureous transitions when "yaw" crosses the +-PI threshold.
		- RawLogViewer: Comments text block was lost after some edit operations.
		- Fixed all the warnings: "dpkg-shlibdeps: warning: dependency on ... could be avoided if ... were not uselessly linked against it (they use none of its symbols)".
		- Fixed an issue with architectures with big endiannes. Fixed Debian bug <a href="http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=509366" > #509366 </a>.


  <a name="0.6.4">
  <h2>Version 0.6.4: Released 20-Dec-2008 (SVN: 696).</h2></a>
	- Full support for compiling all the libraries as DLLs under Windows.
	- Topography helper methods are now grouped in a new namespace: mrpt::topography
	- New class mrpt::utils::CConsoleRedirector for redirecting all the output from std::cout / std::cerr to a log file.
	- New methods in mrpt::utils::CDebugOutputCapable for making easy reporting messages to both the console and a log file.
	- New boolean matrix classes: mrpt::math::CMatrixBool and mrpt::math::CMatrixB
	- mrpt::opengl container classes now have a templatized getByClass<>() method.
	- New interface class for generic PTU called CPtuBase. (Jose Raul Ruiz Sarmiento)
	- New classes for Directed Perception PTU-46-17.5 and PTU Hokuyo interfacing. See class mrpt::hwdrivers::CPtu and mrpt::hwdrivers::CPtuHokuyo. (Jose Raul Ruiz Sarmiento)
	- Fixed the destination of MRPTConfig.cmake in "make install" (and debian packages) such CMake can now automatically find MRPT without asking the user.
	- Added the target "make uninstall" for Linux/Unix systems.
	- New predefined 3D objects (By Miguel Angel Espada Bernal). See http://babel.isa.uma.es/mrpt/index.php/Predefined_3D_Objects
	- Added mime type files for installation in Linux systems (FreeDesktop-compatible, e.g. KDE, Gnome).
	- Created test targets. Use: "make", "make test"
	- Better portability with new HAVE_XXX entries in the "config.h" file.
	- Compilation with MinGW/GCC under Windows now supported. Refer to the <a href="http://babel.isa.uma.es/mrpt/index.php/Guide:Installing_MinGW_(GCC_for_Windows)" > guide on the wiki </a>.
	- Occupancy grids now have an alternative method to insert laser scans (now set by default), which takes into account the "widening" of the laser beams with distance. See the insertionOptions member of mrpt::slam::COccupancyGridMap, and also <a href="http://babel.isa.uma.es/mrpt/index.php/Occupancy_Grids" >the gridmaps tutorial</a>.
	- New configuration pragma MRPT_ALWAYS_CHECKS_DEBUG_MATRICES, enabled by default. The old MRPT_ALWAYS_CHECKS_DEBUG is not disabled by default for speed up in a number of classes under Release compilation.
	- New class for pixel color retrieval with sub-pixel accuracy from images with transformed coordinates. See mrpt::utils::CMappedImage
	- New image processing operations: rectify, Median and Gaussian filter, etc... In mrpt::utils::CMRPTImage.
	- New method to merge several multivariate Gaussians in a Gaussian mixture (SOG) by minimizing the KL-divergence. See mrpt::poses::CPosePDFSOG::mergeModes.
	- Application SceneViewer renamed to SceneViewer3D to solve the Debian bug <a href="http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=505272" > #505272 </a>.
	- New class mrpt::opengl::CSetOfTexturedTriangles for arbitrary shapes in 3D scenes with textures (by Vicente Arevalo).
	- Preview of image capture is posible in rawlog-grabber, thru new option in mrpt::hwdrivers::CCameraSensor.
	- Added support for grabbing FireWire cameras using the library dc1394-2 (The Windows port of dc1394-2 is not released yet). See the new class mrpt::vision::CImageGrabber_dc1394.
	- New methods in matrix classes (and for vectors in mrpt::math::loadVector) for initializing directly from const C arrays.
	- RawlogViewer:
		- Many small improvements in laser & image animations.
		- New menu commands for transforming rawlogs, manipulating gps data, etc...
	- rawlog-grabber:
		- Camera sensors now save images to a external directory. This format is also supported by RawlogViewer and dramatically reduces the cost of visualizing and loading large rawlogs.
		- Support for high-speed & high-resolution IEEE1394 cameras through the class mrpt::hwdrivers::CCameraSensor -> grabber_type = dc1394.
	- New examples:
		- ptuDPerception: Example of use performs a simple scan.
		- ptuHokuyo: A demostration of how coordinate ptu and hokuyo for obtain a map of points that we show using a opengl window.
		- sog-merge: Algorithm for merging SOG pose pdfs.
		- pioneerRobotDemo: A demonstration of connection to a Pioneer robot (ActiveMedia Robotics) and some data requests.
		- gps-coordinates:  Computation of XYZ local coordinates between two precise GPS measurements.
	- New applications:
		- grid-matching: A demonstration of algorithms for occupancy grid map matching. See the <a href="http://babel.isa.uma.es/mrpt/index.php/Applications" >application page</a>.
		- stereo-calib-gui: A tool for calibrating stereo cameras. Based on code from the new OpenCV 1.1.0 and the OpenCV book (requires OpenCV 1.1.0).
	- BUG FIXES:
		- removeObject didn't work in mrpt::opengl classes.
		- mrpt::utils::CConfigFile reported keys as non-existing if they existed but the actual value was an empty string.
		- occupancy grid map: Potential seg.fault when inserting a laser scan with the first range being invalid.
		- color gradient in mrpt::opengl::CPointCloud was lost with time when color_from_z=true.
		- mrpt::system::extractFileExtension flag for ignore gz extensions didn't work.
		- Serialization is now compatible between systems with different endianness.
		- Fail to compile with GCC 4.4, Debian bug <a href="http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=505668" > #505668 </a>. Thanks to Martin Michlmayr.
		- Hopefuly fixed all wrong calculations of very precise (x,y,z) coordinates from latitude, longitude and height, in mrpt::slam::CObservationGPS.
		- Wrong data grabbed from xSens IMU: Gyroscope data saved as XYZ velocities. In mrpt::hwdrivers::CIMUXSens
		- Possible lock when reading from a serial port from two different objects mrpt::hwdrivers::CSerialPort
		- mrpt::system::os::getch: Now really does NOT wait for an enter, but just one keystroke in Linux.
		- mrpt::system::extractFileName didn't work for filenames already without an extension.
		- mrpt::utils::CMemoryChunk led to segmentation faults since the re-implementation with smart pointers.
		- Wrongly report missing parser for de-serializing a mrpt::slam::CSimplePointsMap object in the lastest binary format.
		- OpenGL render system had an inconsistence with the internal MRPT representation of 3D objects (by Pablo Moreno Olalla).

  <a name="0.6.3">
  <h2>Version 0.6.3: Released 23-Oct-2008.</h2></a>
	- Updated "INSTALL-COMPILE.html"
	- mrpt::gui windows can now be used also from user GUIs. This was previously possible from console apps only.
	- Supports compiling without OpenCV.
	- BUG FIXES:
		- GridmapNavSimul crashes on exit, for Windows only (SF <a href="https://sourceforge.net/tracker2/?func=detail&aid=2189710&group_id=205280&atid=993006" >2189710</a>).
		- Fixed possible compiling errors related to Boost (Thanks Xuan Vu!).
		- Wrong headers in some embedded jpeglib sources (Thanks Hai Li!).

  <a name="0.6.2">
  <h2>Version 0.6.2: Released 21-Oct-2008.</h2></a>
	- <b>IMPORTANT CHANGES</b>:
		- All metric maps now accept full 6D poses for evaluating observation likelihood, and rbpf-slam now always uses internally  6D poses.
		- mrpt::vision now integrates SIFT features computation thru Hess' C library (http://web.engr.oregonstate.edu/~hess/) (by Francisco Angel Moreno).
		- Many bug fixes, and new samples and applications.

	- Detailed list of changes:
		- All metric maps now accept full 6D poses for evaluating observation likelihood.
		- Added new macros for easier RTTI: IS_CLASS and IS_DERIVED.
		- New sensor class compatible with rawlog-grabber: A camera image grabber. See mrpt::hwdrivers::CCameraSensor.
		- xSens IMU MTi now works on both Windows & Linux with the new xSens software sources.
		- mrpt::hwdrivers::CIMUXSens now asks the IMU for calibrated acc. & gyr. data as well.
		- New methods in mrpt::math.
		- Linux & gcc only: Use --as-needed to avoid executables depending on useless .so libraries.
		- mrpt::gui::CDisplayWindow3D now can save the render canvas directy as a sequence of images, which helps to create videos from real-time animations.
		- mrpt::bayes::CParticleFilterCapable::computeResampling now implements all 4 resampling algorithms.
		- mrpt::vision now integrates SIFT features computation thru Hess' C library (http://web.engr.oregonstate.edu/~hess/) (by Francisco Angel Moreno).
		- mrpt::math::CMatrixTemplateNumeric::loadFromTextFile: Lines starting with '%' or '#' are interpreted as comments and ignored.
		- New methods in mrpt::utils::CMRPTImage for fast flip and Red-Blue swap.
		- More efficient capture of video in mrpt::vision::CImageGrabber_OpenCV (by Vicente Arevalo).
		- Applications renamed for consistency:
			- "pf-localization"
			- "rawlog-grabber"
		- New class mrpt::poses::CPoseRandomSampler to efficiently draw samples from any 2D/3D pose PDF. Used to refactor code in some SLAM classes. E.g: pf-localization is now 20% faster.
		- Boost libraries are required for compiling some parts of MRPT. Follow the updated instructions in http://babel.isa.uma.es/mrpt/index.php/Building_and_Installing_Instructions.
		- mrpt::utils::CReferencedMemBlock redesigned: it was too obscure, now it's based on a simpler stlplus::smart_ptr
		- mrpt::utils::CFileOutputStream & mrpt::utils::CFileInputStream now has default constructors and "open" methods.
		- mrpt::opengl::CPlanarLaserScan implemented.
		- mrpt::slam::COccupancyGridMap2D: Simulator of laser scans now includes an optional noise in bearing angles.
		- rbpf-slam:
			- New version 0.3: A full 6D state if always kept, even if the robot moves on a flat surface only. This enables experimenting with 6D SLAM approaches based on particle filtering.
		- RawLogViewer, changes:
			- Proper display of IMU observations with all their data fields.
			- Dialog "Edit" now also processes files gz-compressed.
			- Dialog "Motion model" allows modification of a part of the rawlog only.
		- New examples:
			- feature_extraction: Test for image feature detection using KLT, Harris and SIFTs.
			- resampling-test: Particle filtering resampling schemes.
		- New applications:
			- ro-localization: Range-Only Localization with particle filters. See <a href="http://babel.isa.uma.es/mrpt/index.php/Applications" >its wiki page</a>.
			- simul-grid: A command-line application to simulate rawlogs of laser scans using a world modelled by a grid map.
			- GridmapNavSimul: A GUI application which simulates a robot controlled by a joystick and generate rawlogs with noisy odometry and laser scans plus ground truth. See <a href="http://babel.isa.uma.es/mrpt/index.php/Applications" >the wiki</a>.
		- BUGS FIXED:
			- Link errors in examples if paths have blank spaces.
			- ReactiveNavigationDemo crashes with VFF method (Xuan Vu: SF <a href="https://sourceforge.net/tracker2/?func=detail&aid=2183187&group_id=205280&atid=993006" >#2183187</a>).
			- RawlogViewer crashes when opening logs with embedded images (Xuan Vu: SF <a href="https://sourceforge.net/tracker2/?func=detail&aid=2182167&group_id=205280&atid=993006" >#2182167</a>).
			- USB laser scanner data acquisition: wrong bit mask in mm mode.
			- rawlog-grabber: Loss of 1 observation per grabbing period fixed.
			- mrpt::utils::CFileStream: Error when opening a file for append (fomAppend) and the file didn't exist.
			- mrpt::slam:COccupancyGridMap2D: fixed marking as occupied cells at the end of truncated rays when shorter than the "maxDistanceInsertion".
			- mrpt::vision::CImageGrabber_OpenCV didn't report an error when reaching the end of a video file.
			- Timestamps were lost in mrpt::slam::CAction 's when copied.
			- Linker errors when compiling an external application using MRPTConfig.cmake with GCC and in Debug.
			- Wrong destruction of critical sections when embedded into objects within smart_ptr's.
			- mrpt::slam::CActionRobotMovement2D: Wrong copy of objects with the = operator.
			- mrpt::utils::CFileGZOutputStream crashes if "close" called instead of closing at destructor.
			- Errors compiling with BUILD_ARIA=0.

  <a name="0.6.1">
  <h2>Version 0.6.1: Released 27-Aug-2008.</h2></a>
	- HOKUYO communications reconnect even if USB cable unplugged & plugged again.
	- New, more robust version of Linux serial port.
	- particleFilterApplication now supports ".gz" input files as well.
	- "zlib" & "jpeglib" included as separate libraries, for Windows in the case of not having wxWidgets.
	- xmlParser library files (src/core/utils/xmlparser/*): Legal issue fixed by replacing license with a BSD-like license from Frank Vanden Berghen (thanks!).
	- New target (Linux only): "make documentation_tutorial".
	- New examples:
		- gravity3d: Demonstration of 3D animation and physics simulation.
	- New applications:
		- simul-landmarks
		- simul-beacons
	- BUGS FIXED:
		- Communications with HOKUYO in Linux eventually crashes.
		- Error in "make install", tried to copy tutorial.ps.gz intended for Debian packages. (Thanks sisyphus me)
		- Wrong text format of dates & times in mrpt::system functions.
		- Mismatched new / free[] solved in mrpt::system::createThread (Linux).
		- Applications icp-slam, kf-slam, rbpf-slam didn't recognize gz-compressed rawlogs.
	- All Debian scripts & files moved away from MRPT source tree for consistency.

  <a name="0.6.0">
  <h2>Version 0.6.0: Released 14-Aug-2008.</h2></a>

	- <b>IMPORTANT CHANGES</b>:
		- All classes reorganized into a new set of namespaces. Existing user-code out of MRPT will not compile, though changes typically imply just changing the names of the included files and adding some "using namespace XXX;" lines.
		- Better support of user applications using CMake command "FIND_PACKAGE( MRPT REQUIRED )". Refer to: http://babel.isa.uma.es/mrpt/index.php/Writing_applications_with_the_MRPT_C%2B%2B_Library
		- Pointers have been passed to smart pointer all across the code.
		- RawLog files: a new "observations-only" format has been introduced, and now all rawlog are saved compressed using "gzip" automatically (they are decompressed automatically to the user when loaded). Alternatively the user can rename a rawlog file to "name.rawwlog.gz", then use standard tools to extract the uncompressed version, if necessary.
		- The MRPT libraries can now be compiled as a shared library (.dll/.so), by setting MRPT_BUILD_SHARED_LIB from the CMake GUI.
		- New hardware libraries supported:
			- Cross-platform (Windows/Linux) library ARIA (distributed by ActivMedia Robotics under GNU GPL) integrated into MRPT. Select the appropriate switch in CMake to enable it. See hwdrivers::CActivMediaRobotBase.
			- New hardware driver for XSens inertial measuring units (IMU). See hwdrivers::CIMUXSens.
		- New applications:
			- RawLogGrabber, for gathering data in real-time from a robotic platform. See wiki page: http://babel.isa.uma.es/mrpt/index.php/Application:RawLogGrabber
			- hmtMapViewer, an inspection tool for HMT-SLAM. See wiki page: http://babel.isa.uma.es/mrpt/index.php/HMT-SLAM:An_Open_Source_Implementation
		- Visual Studio 6 is not supported anymore from now on: it's a too old compiler, buggy, and lacks many modern C++ features.
		- Many bugs fixed.

	- All changes:
		- Many additions to conform to Debian packaging standards and freedesktop.org standard files for creating application menus, etc.
		- Added new "colored points" map & opengl objects. See mrpt::slam::CColouredPointMap and mrpt::opengl::CPointCloudColoured.
		- SceneViewer also is able to read from .gz'd files (.3Dscene files, but can be renamed to .3Dscene.gz if desired).
		- Management of local and UTC times clarifies with new methods. See mrpt::system, time functions.
		- Added a new class for transparent disk-swapped loading of very large datasets. see mrpt::slam::CRawlogXXL.
		- Exception handling prepared to correctly manage bad_alloc exceptions (for out of memory scenarios).
		- Added a 1D function interpolator using splines. See mrpt::math::CSplineInterpolator1D.
		- Added a 6D poses interpolator, using splines. See mrpt::poses::CPose3DInterpolator.
		- Removed built-in zlib library, replaced by wxWidget's one.
		- Added support for easy read and write of .gz files. For the automatic streams, see mrpt::utils::CFileGZInputStream and mrpt::utils::CFileGZOutputStream. For manual operation, see mrpt::compress::zip.
		- New opengl object: mrpt::opengl::C3DSScene for importing complete scenes from 3D Studio files (using the open source lib3ds library, Copyright (C) 1996-2007 by Jan Eric Kyprianidis <www.kyprianidis.com> ).
		- Class for storing rawlogs renamed as "mrpt::slam::CRawlog", and enabled for the new observation-only <a href="http://babel.isa.uma.es/mrpt/index.php/http://babel.isa.uma.es/mrpt/index.php/Rawlog_Format">rawlog file format</a>.
		- Introduced precompiled headers for a dramatic reduction of compilation time thru the header <mrpt/core.h>.
		- The method CSerializable::duplicate has been optimized using directly the derived class copy constructor instead of a temporary memory buffer.
		- Created a new metric map: grid map of heights. See mrpt::slam::CHeightGridMap2D.
		- Added a method for estimating the Jacobian of a function by finite differences. See math::estimateJacobian.
		- Source tree has undergone a re-ordering and rename. Now, libraries are named as: mrpt-core, mrpt-hwdrivers, mrpt-ann, etc. and all the sources are in <mrpt>/src.
		- Added generic class for Levenberg-Marquart optimization problems. See utils::CLevenbergMarquardt and the <a href="http://babel.isa.uma.es/mrpt/index.php/Levenberg%E2%80%93Marquardt_algorithm">wiki tutorial on the topic</a>.
		- Added communications support for the new HOKUYO UTM-30LX (Windows and Linux). Refer to the <a href="http://babel.isa.uma.es/mrpt/index.php/Example:HOKUYO_URG_Laser_Scanner" >wiki page</a>.
		- New method introduced to gas distribution mapping: optimized Kalman filter with constant time update. See mrpt::slam::CGasConcentrationGridMap2D.
		- The class utils::CTicTac now does not use dynamic memory, so it's constructor & destructor are faster.
		- Several optimizations applied to 2D and 3D geometry classes (poses::CPoseOrPoint derived ones).
		- Added cross-platform support for "alloca". See system::alloca.
		- Sources updated to be compatible with GCC 4.3 and Visual Studio C++ 2008.
		- Thread statistics now are also implemented for Linux. See system::getCurrentThreadTimes.
		- HWDRIVERS classes unified under the "generic sensor model". See hwdrivers::CGenericSensor.
		- 3D render canvas classes unified under the new class utils::WX_gui::CMyGLCanvas_Base.
		- Added serializable STL classes. See utils::vector_serializable, etc. See utils/stl_extensions.h
		- Added serialization to the whole mapping framework state in HMT-SLAM, and many related classes. See mrpt::hmtslam::CHMTSLAM.
		- lib_hwdrivers: Custom device-dependent initialization commands can be sent when opening a GPS interface. See hwdrivers::CGPSInterface.
		- Joysticks and game-pads fully supported now under both Windows and Linux. See hwdrivers::CJoystick.
		- Added new applications:
			- RawLogGrabber, for gathering data in real-time from a robotic platform. See wiki page: http://babel.isa.uma.es/mrpt/index.php/Application:RawLogGrabber
			- hmtMapViewer, an inspection tool for HMT-SLAM. See wiki page: http://babel.isa.uma.es/mrpt/index.php/HMT-SLAM:An_Open_Source_Implementation
		- Added new examples:
			- /samples/UTILS/fileSystemWatcher: Demonstrating watching of directory changes. Based on class utils::CFileSystemWatcher.
		- RawLogViewer:
			- A new facy custom tree view, extremely more efficient for very large datasets and with a time-line to graphically visualize timestamps.
			- Many new commands: resort from timestamps, regenerate timestamps from GPS observations, etc.
			- In the "raw-map" window the user can change now the number of types of maps to build from odometry + raw observations.
			- Implemented building a map from a rawlog with RTK GPS data. See "RawMap" dialog.
		- BUGS FIXED:
			- Textual representation of dates and times with seconds represented with just one digit.
			- Fixed wrong computation of transformation from GPS to local coordinates.
			- Exception raised if an empty CMRPTImage is serialized.
			- Wrong conversion of old serialization versions of gridmaps.
			- Parameters of a gas gridmap were ignored after loading from .ini.
			- Changing by hand the coordinates in mrpt::poses::CPose3D was not persistent when serializing the object.
			- Added missing "+ operators" to mrpt::poses::CPoint3D.
			- mrpt::slam::CSimplePointsMap: Serialization was not cross-platform (it used "unsigned long" data type).
			- mrpt::slam::CObservationGPS didn't save the "sensorPose" when streaming.

	- MAY-2008:
		- mrpt::poses::CPointsMap now also has a horizontal tolerance range for "horizontal" or "planar" maps.
		- Pseudorandom number generator algorithm Mersenne twister MT19937 implemented in utils::RandomGenerator for uniform distributions (in turn used for the rest). This assures same PRNs over different platforms.
		- gui::CDisplayWindowPlots now can also manage 2D bitmaps plots, that can be combined with 2D vectorial plots. See gui::CDisplayWindowPlots::image.
		- CPointsMap::compute3DMatchingRatio is now ~6 times faster (using KD-tree).
		- Missing implementation of KD-tree for 3D points in mrpt::poses::CPointsMap now complete.
		- Added support for file-system watching. See utils::CFileSystemWatcher.
		- SceneViewer:
			- New option to allow free rotation and zoom of the camera even for scenes with the flag "followCamera".
		- RawLogViewer:
			- Added importer for "rtl" log files.
			- Added capability to export several GPSs to text files.
			- Sensor labels appear in the tree view.
		- BUGS FIXED:
			- "mrpt::slam::CSensFrameProbSequence::operator =" was wrongly implemented.
			- In gridmaps (mrpt::slam::COccupancyGridMap2D):
				- Calling mrpt::slam::COccupancyGridMap2D::resizeGrid only supports growing the grid (not shrinking). This is now forced internally to fix impredictable results.
				- In some situations, inserting a 2D laser scan ray ending very close to the border didn't make the grid to extend its size, and may lead to memory corruption.
				- Disabled ROWSIZE_MULTIPLE_16 in mrpt::slam::COccupancyGridMap2D to avoid rare memory corruptions (bug to be tracked down if wanna enable it in the future again...).
			- Fixed support for Bumblebee in external applications through CMake system (MRPTconfig.cmake).
			- Wrong reporting of stacked exceptions messages.
			- Fixed wrong calculation of (x,y,z) coordinates from latitude, longitude and height, in mrpt::slam::CObservationGPS.
			- utils::CClientSocket did send debug information in the middle of actual data!. Thanks to Vicente Arevalo for reporting.

  <a name="0.5.5">
  <h2>Version 0.5.5: Released April 30, 2008.</h2></a>
	- APR-2008:
		- New 2D font render engine in utils::CMRPTCanvas. It now supports a number of different fonts, including CJK (Chinese-Japanese-Korean) characters.
		- HOKUYO URG04 laser scanner interface now works for Linux and Windows. See hwdrivers::CHokuyoURG and <a href="http://babel.isa.uma.es/mrpt/index.php/Example:HOKUYO_URG_Laser_Scanner" >the wiki page</a>.
		- Serialization format changed: added an end-flag and 5 bytes saved per dumped object. See the serialization description <a href="http://babel.isa.uma.es/mrpt/index.php/Serialization">here</a>.
		- Management of 3D scenes greatly improved through the introduction of multi-viewports. This has been a major change, but compatibility with old code has been maintained as much as possible. See opengl::COpenGLScene, or the <a href="http://babel.isa.uma.es/mrpt/index.php/Tutorial_3D_Scenes">tutorial</a>.
		- Generation of HTML and CHM documentation has been integrated in the project workspace, as "make documentation_XXX" for "make" or new projects in Visual Studio.
		- Occupancy grids reimplemented with a discrete representation of log-odds. Most common operations are now faster (e.g. inserting a laser scan is x10 faster!). See mrpt::slam::COccupancyGridMap and <a href="http://babel.isa.uma.es/mrpt/index.php/Occupancy_Grids" >the gridmaps tutorial</a>.
		- The file "MRPT_version.h" is now automatically updated from CMake with the version + SVN (if local copy is a repository).
		- Socket classes are now fully implemented for Linux and Windows. See utils::CClientTCPSocket and utils::CServerTCPSocket.
		- Added two new CStream classes: utils::CFileInputStream, utils::CFileOutputStream, specializations of the old utils::CFileStream.
		- File stream classes rewritten based on standard std::iostream classes (faster I/O). See utils::CFileStream.
		- Examples can now be built and run from any directory, through the new config file: "MRPT_examples_config.h".
		- Added support to any number of points map within mrpt::slam::CMultiMetricMap.
		- Added a new way to store images within utils::CMRPTImage: external storage in separate files, to enable managing very large rawlogs efficiently. It is transparent to the user, the images will be loaded automatically from disk when needed.
		- Options of mrpt::slam::COccupancyGridMap2D, mrpt::poses::CPointsMap and mrpt::slam:::CMultiMetricMap are now persistent (included in the serialization).
		- Macros max,min,max3,min3 passed to inline template functions, reusing std::max & std::min.
		- The following synchronization classes can now be safely copied (eg. within STL containers) and they still refer to the same OS's synchronization object: synch::CSemaphore, synch::CCriticalSection, synch::CEvent.
		- New class utils::CReferencedMemBlock for memory blocks that have to be shared between objects when copied with "=".
		- Major revision of many classes to satisfy design rules in Scott Meyers' "Effective C++ book" (-Weffc++ gcc option).
		- Added new examples:
			- /samples/MRML/pathPlanning: Demonstrating path finding in occupancy grid maps for circular robots.
			- /samples/MRML/benchmark-gridmap
			- /samples/MRML/gridMapLikelihoodCharacterization
			- /samples/HWDRIVERS/HOKUYO_laser_test: Added example for HOKUYO laser range finder.
		- Re-factorization of the main library (lib_MRPT) for faster rebuild and better modularity. New libraries in "/apps/lib_XXX":
			- lib_HMTSLAM.
			- lib_HWDRIVERS.
		- RawLogViewer version 2.2:
			- Now the user can choose the format (png,jpg,...) of the image files when generating image lists, transforming into external storage image observations, etc.
		- BUGS FIXED:
			- No timestamp saved in rawlogs for some observations.
			- Extra NULL character stored in type list in utils::CTypeSelector.

	- MAR-2008:
		- New classes added in file "UTILS/safe_pointers.h" for making classes with pointer members safer.
		- Added switches to CMake system to disable MRPT_TRY_START/END and ASSERT_ blocks, for speed up on well tested applications.
		- Added new class utils::CMemoryChunk.
		- Added a new application for building metric maps from ".simplemap" files.
		- Added a class for message passing between threads. See utils::CMessageQueue.
		- Created mrpt::slam::TKLDParams to unify KLD-sampling parameters across different classes.
		- mrpt::slam::CHybridMetricMap finally renamed mrpt::slam::CMultiMetricMapPDF, for consistency with mrpt::slam::CMultiMetricMap.
		- Particle filter classes re-organized: options are now kept in bayes::CParticleFilter, and steps are run with CParticleFilter::executeOn, to avoid pointers (less safe) and be more sensible.
		- Added a tolerance threshold for the pitch/roll of laser scans to be treated as "horizontal" in mrpt::slam::COccupancyGridMap2D.
		- A textual label added to all observations to describe its sensor (See CObservation::sensorLabel).
		- mrpt::slam::CSensoryFrame and mrpt::slam::CActionCollection now behave like STL containers (begin,end,iterator,erase,...); internal lists are protected.
		- All geometry, PDFs, and Kalman Filter classes passed from float -> double.
		- Added a new, more efficient implementation to bayes::CKalmanFilterCapable, processing one observation (not each scalar component) at once.
		- Added new fast operations to matrices. See math::CMatrixTemplateNumeric.
		- Fixed the small memory leak of the ANN library by calling annClose.
		- SceneViewer:
			- Scenes are compiled into OpenGL lists for efficiency.
		- RawLogViewer version 2.2:
			- Added a command to convert images of old rawlogs into delayed-load images.
			- Support for delayed-load images: now much larger rawlogs can be managed efficiently.
			- Added "compact rawlog" command: group consecutive actions & observations.
			- Added "loss-less decimation".
			- Added "edit rawlog" by name of sensor.
			- Now two monocular images can be displayed simultaneously in the "View images as video"-module.
			- Added "export/import to ALOG format".
		- BUGS FIXED:
			- Fixed compiling errors when compiling under Linux without GL/GLUT.
			- Wrong copy of 3D angles in CPose3DPDFGaussian::copyFrom.
			- Missing a valid, secure operator (operator =) for bayes::CParticleFilterData.
			- Compiling errors due to non-ASCII Spanish characters (thanks to Zhe Zhang).
			- Unpredictable result if a 2D laser scan with all invalid points is inserted in a pointsmap.

  <h2>Version 0.5.4: Released March 6, 2008.</h2>
	- MAR-2008:
		- Size variables in mrpt::poses::CPointsMap, math::CPolygon, and ReactiveNavigationLibrary passed to "size_t".
		- Thread join implemented in Windows.
		- Added a new class synch::CCriticalSectionLocker to assure consistent critical section leaving in any situation (exceptions, programmer's mistakes,...).
		- Implemented Iterative Kalman Filter (IKF). See bayes::CKalmanFilterCapable.
		- Next MRPT release will be published under the GNU GPL version 3 (comment blocks updated in all source files).
		- Correspondences between point maps implemented with KD-tree: "classic ICP" is now ~10x faster.
		- Removed wrong covariance estimation in mrpt::poses::CPointsMap::computeMatchingWith2D and added a new better one to mrpt::slam::CICP.
		- The library ANN (Approximate Nearest Neighbor) by Sunil Arya and David Mount (University of Maryland) has been integrated in the build tree.
		- Added an option to utils::CMRPTImage to disable ZIP compression when storing images.
		- Added the all new implementation of HMT-SLAM. See mrpt::slam::CHMTSLAM.
		- Fixed all 64-bit portability issues detected by Visual Studio 2005.
		- Created a repository of 3D objects in opengl::stock_objects.
		- COpenGLScene & opengl::CSetOfObjects now have the list of objects as "protected" for assure safe memory-management.
		- Added build options as switchs in the CMake build system for:
			- The GCC stdlibc++ "parallel mode". See http://algo2.iti.uni-karlsruhe.de/singler/mcstl/.
			- Selecting 8bits/16bits cell size in occupancy grid maps.
			- Enabling code profiling (GNU GCC only).
		- Added new applications:
			- icp-slam: A very naive mapping algorithm based on a single metric map & ICP laser scan alignment. See mrpt::slam::CMetricMapBuilderICP.
		- BUGS FIXED:
			- Copy operator of 6D poses didn't work always as expected.
			- Pose composition of 6D Gaussian poses (poses::CPose3DPDFGaussian) used wrong Jacobians.
	- FEB-2008:
		- Added a new application: camera-calib,  by Vicente Arevalo (University of Malaga).
		- Added "point size" property to UTILS:opengl::CPointCloud.
		- Windows only: OpenCV linked again as a DLL instead of a static library, in order to free 30Mb in MRPT packages, useless for non-Windows users.
		- RawlogViewer & SceneViewer: Directory of last opened file now saved when invoking programs with file as command-line argument.
		- Added a new mechanism for displaying mathematical graphs using MATLAB-like "plot" commands. See gui::CDisplayWindowPlots.
		- Visual Leak Detector integrated in the CMake build system.
		- Extended Kalman Filter implementation rewritten from scratch. See bayes::CKalmanFilterCapable.
		- Implemented missing operations (move,resize,...) in gui::CDisplayWindow & gui::CDisplayWindow3D.
		- New implementation of the Kalman Filter in mrpt::slam::CRangeBearingKFSLAM: 'a la Davison', orders of magnitude faster than naive Kalman (new version 0.2 of application "kf-slam").
		- Improved 3D/6D geometry implementation: x2 speed-up in (inverse) pose compositions (utils::CPoseOrPoint and derived classes).
		- Addition of a new matrix class: math::CMatrixFixed, for compile-time known sizes (more efficient??).
		- Fixed compiling errors if MRPT_HAS_WXWIDGETS = 0.
		- Generation of CMakeLists fully automated for samples.
		- Added support for "pkg-config libMRPT --libs --cflags" if the library is make install'ed,  UNIX only.
		- "Save as..." implemented in gui::CDisplayWindow.
		- Added new examples:
			- samples/UTILS/threadsTest, demonstrating the creation of threads and synchronization.
			- UTILS/benchmark-matrix.
			- samples/UTILS/bayesianTracking, implementing a very simple bearing & tracking problem with both a EKF and a particle filter (PF).
			- samples/UTILS/displayPlots.
			- MRML/grid-matching.
		- BUGS FIXED:
			- Core dump due to a wrong initialization of mrpt::slam::CSensoryFrame using the *copy constuctor*.
			- RawlogViewer: Changing a sensor pose in the "sensor/camera modification dialog" didn't change it for 6D poses.
			- utils::CDirectoryExplorer missed files under Windows when marked as FILE_ATTRIB_NORMAL.
			- Core dump (double free) if a matrix is set to size (0,0) and then resized again (it affected the new matrix loadFromTextFile method).
			- Inverted axes in CDisplayWindow3D & SceneViewer when camera elevation=-90deg.
			- Wrong generation of random samples in random::randomNormalMultiDimensional.
			- Missing synchronization within WxSubsystem's thread.
			- Not using double-buffering in SceneViewer.
			- Wrong simulation of bearing-range observations for any 6D pose in mrpt::slam::CLandmarksMap.
			- gui::CDisplayWindow & gui::CDisplayWindow3D timeout waiting to close windows after class destruction.

  <h2>Version 0.5.3  (First public release, January 31, 2008)</h2>
	- JAN-2008:
		- Small changes in CMake files to prepare first public source release.
		- utils::WxSubsystem created as a centralized manager of GUI windows in the MRPT using the cross-platform wxWidgets. Now used for CDisplayWindow & CDisplayWindow3D.
		- Application "ReactiveNavigationDemo" rewritten using wxWidgets and integrated in the MRPT CMake tree.
		- Bumblebee camera support integrated in CMake file system.
		- RawLogViewer 2.1 finished.
		- SceneViewer 1.1 finished.
		- New methods added to matrixes and to the MATH namespace.
		- "mrpt::slam::CSensFrameProbSequence" and "mrpt::slam::CIncrementalMapPartitioner" modified to work with full 3D/6D poses rather than planar robot poses only.
		- Added a working example of EKF-SLAM including a sample dataset.
		- Tree structure modified for clarity, clean up of files at the root directory.
		- RawLogViewer: Added viewer of mrpt::slam::CObservationBearingRange.
		- Added a new method to compute spherical coordinates of a 3D point from a 6D pose (see mrpt::poses::CPose3D).
		- MRPT_ALWAYS_CHECKS_DEBUG is now enabled by default.
		- Added new matrix operations to employ them in a more efficient EKF implementation.
		- Changes all across the library to enable compilation in 64 bit targets (without warnings).
		- getCurrentTime now gives high-resolution time (usecs) in Linux.
		- Added the option "justOneOccupiedCellPerRay" to mrpt::slam::COccupancyGridMap2D.
		- Added new applications:
			- map-partition.
			- KF-SLAM.
		- Added new examples:
			- MRML/landmarkRawlogSimulator, a simulator of a robot with a 3D range-bearing sensor.
		- BUGS FIXED:
			- CSemaphore::waitForSignal now also works for an timeout=0 (no timeout).
			- In openCV_cross_correlation: wrong order of (v,u) coordinates! Have been replaced by (x,y) to prevent more errors.
			- Wrong calculation of mean in CGraphPartitioner::SpectralBisection.
			- Wrong calculations in "multiplyByMatrixAndByTranspose"
			- "dateTimeToString" gave wrong data.
			- Out of vector bound exception in RawLogViewer exporter to text files.
			- Wrong normalization of 3D vectors in generateAxisBaseFromDirection.

	- DEC-2007:
		- Speed up in rendering of 3D ellipsoids by computing eigenvectors only once.
		- Implemented RO-SLAM with SOG (mrpt::slam::CBeaconMap)
		- Added a method to generate permutations of vectors (See utils::RandomGenerator).
		- Started RawLogViewer 2.1: Added a new module for laser scan animations.
		- Added a new cross-platform 3DSceneViewer application.
		- Deleted the old application x3DSceneViewer
		- New example: MRML/geometry3D
		- BUGS FIXED:
			- Wrong initialization of CMatrix from a CPoint3D
			- Wrong calculation of yaw/pitch/roll fields in CPose3D when composing poses.

  <h2>Version 0.5.2 (Released December 26, 2007)</h2>
	- DEC-2007:
		- Release of RawLogViewer 2.0, the first portable (win32/linux-gtk) version.
		- Old win32 version "RawLogsViewer" removed from the repository!
		- GUI classes (CDisplayWindow, CDisplayWindow3D) have been rewritten in:
			- Windows: Native MSW API.
			- Linux: GTK2
		- New features to RawLogViewer (change sensor poses,...)
		- Added general abstract methods to CObservation for getting/setting the sensor pose.
		- Added to RawLogViewer: Import a directory of images as a rawlog.
		- utils::CDirectoryExplorer rewritten & ported to Linux.
		- BUG FIXED: 'system::sleep' was aborted by signals in Linux. It now resumes until the desired delay.
		- Linux implementation for CSerialPort.
		- RawLogViewer: ScanMatching module finished.
		- New class for landmark observations by bearing and range (See mrpt::slam::CObservationBearingRange).
		- Timestamps have been added to CAction's.
		- BUG FIXED: Invalid encoder info in CActionRobotMovement2D.
		- New methods added to CRawlog to enable a better encapsulation of the internal list of objects as "private".
	- NOV-2007:
		- BUG FIXED: CObservationGPS didn't load from CStream in Linux. Serialization version 1 is now portable.
		- Added the sprintf-like function "format" for std::string's.
		- Integration of xmlParser library within utils::CSimpleDatabase.
		- A new class for managing the custom USB board that interfaces SRF10 ultrasonic range finders. Class hwdrivers::CBoardSonars.
		- Class hwdrivers::CBoardENoses has been finished and tested with the real devices.
		- Many includes in "utils_defs.h" moved to those source files really requiring them, to speed up compilation.
		- Fixs to allow compiling using the free Borland C++ 5.5.1 compiler from CMake makefiles.
		- Added new sample for eNose board interface.

  <h2>Version 0.5.1 (Released for BABEL, November 13, 2007)</h2>
	- NOV-2007:
		- BUG FIXED: math::generateAxisBaseFromDirection now returns all the three vectors normalized.
		- Implemented Sum of Gaussians (SOG) as a way to create the PDF of a beacon for RO-SLAM (in mrpt::slam::CBeaconMaps).
		- Added a new example to "samples/MRML": beaconRawlogSimulator.
		- Added a new class for interfacing an "e-Noses" board via USB, in hwdrivers::CBoardENoses.
		- OpenCV added as a monolithic, static linking library to avoid DLL dependencies (for Windows).
		- New wiki-based website. Old doxygen-based documentation headers (.h) removed.
		- BUG FIXED: Memory leaks in the MRPT class registration system and in utils::CTicTac have been removed (Using "Visual Leak Detector" it seems there are no more leaks by now...).
		- BUG FIXED: THROW_EXCEPTION_XXX macros redesigned to avoid eventual exceptions in wxWidgets applications.

	- OCT-2007:
		- Methods "computeMatchingWith2D" modified for a sensible usage of the "const" modifier.
		- Changed mrpt::slam::CMetricMapsAlignmentAlgorithm::Align to avoid the warning "break strict-aliasing rules" about the CPosePDF**.
		- Added tutorial: Serialization.
		- Added new class mrpt::poses::CPose3DPDFSOG for Sum of Gaussians-representation of a 6D pose probability density.
		- Reactive Navigation Library ported from Win32 API to standard C++.
		- Resampling methods now are separated in a generic, static method bayes::CParticleFilterCapable::computeResampling.

  <h2>Version 0.4 (Released for BABEL, October 13, 2007)</h2>
	- OCT-2007:
		- BUG FIXED: Loading grayscale images CMRPTImageFloat now forces to load images from files as grayscale always.
		- BUG FIXED: To allow inserting into gridmaps laser scans taken with the sensor bottom-up.
		- All the makefiles of MRPT has been moved to CMake.
	- SEP-2007:
		- Structure of "include" directory changed to include the prefix "<MRPT/...". This is for leading to a one-directory install into "usr/include" in Linux systems.
		- CSemaphore implemented for Linux using pthreads.
		- CDisplayWindow3D is now based on GLUT and works in Windows & Linux.
		- Added a new application by Antonio J. Ortiz de Galistea: a MonoSLAM demo.
		- Different PF resampling methods are now supported. See CParticleFilter::resample.
		- CParticleFilter now has a centralized structure for all the PF-related options.
		- BUG FIXED: CDisplayWindow2D now has an extra (global) thread to process OpenCV messages without the need for the application to call "waitForKey".
		- Added a new procedure into CMultiMetricMapPDF for expanding the potential range of observation likelihoods without having a numerical overflow.
		- Add Class for Sonar SRF10 Interface (AJOGD).
		- CMRPTImage now is a wrapper class over OpenCV. More image file types are supported now.
		- CDisplayWindow now completely portable between windows/Linux thorugh OpenCV.
	- AUG-2007:
		- BUG FIXED: In utils::CConfigFile.
		- Started new application RawLogViewer using wxWidGets for a portable version (windows/linux).
		- Added utils::getAllRegisteredClasses to obtain at runtime the list of all MRPT registered classes.
		- Started the porting towards "bakefiles"
		- A new function added to obtain the compilation date and the library version (including SVN). See utils::SystemUtils.
		- Started a new version of the application "RawLogViewer" in portable wxWidGets for linux compatibility!.
		- Borland C++ 5.5 not supported any more, due to a lot of internal compiler errors. We use now BCC version 6.0.
		- Range-Only SLAM will be integrated into existing SLAM classes through the new class mrpt::slam::CBeaconMap, now fully integrated into mrpt::slam::CMultiMetricMap.
		- A new class for integrating different PDF representations of beacons (mrpt::slam::CBeacon) and the corresponding map (mrpt::slam::CBeaconMap).
	- JUL-2007:
		- A new class of CAction for 6D movements (mrpt::slam::CActionRobotMovement3D).
		- CStream & CSerializable now have more consistent "const" declarations.

  <hr>
  <h2>Version 0.3 (Released for BABEL v3.800, July 2007)</h2>

	- JUL-2007:
		- A new class for Range-Only Localization (mrpt::slam::CRejectionSamplingRangeOnlyLocalization).
		- Range-Only SLAM is now supported with a new map class (mrpt::slam::CBeaconMap), which has been also integrated in mrpt::slam::CMultiMetricMap.
		- A new class for parsing messages from/to a USB FTDI device (hwdrivers::CInterfaceFTDIMessages).
		- Added a new class for 3D Point PDF representation as a SOG (poses::CPoint3DPFGSOG).


  <hr>
  <h2>Version 0.2</h2>

	- JUN-2007:
		- From now on MRPT is updated through Subversion (SVN).
		- Start solving portability issues towards a full Linux support.
	- MAY-2007:
		- Included the makefile project for "Code::Blocks" compiler, for supporting Linux GCC C++ compiler.
	- FEB-2007:
		- BUG FIXED: In "CSerializable::duplicate()"
		- Added new config file-like interfaces. See utils::CConfigFileBase and derived classes.
		- Added utils::CStringList.
	- JAN-2007:
		- New fast image correlation method based on 2D FFT. See CMRPTImage::cross_correlation_FFT
		- 2D FFT functions added to utils::MATH
		- The class utils::CConfigFile now can read entries as "std::vector"'s.
		- New utilities added to utils::MRPT_OS for tokenizing strings.

  <hr>
  <h2>Version ALFA 0.1 (Published with BABEL v3.0.0, Jan-2007)</h2>

	- JAN-2007:
		- The classes "utils::CBitmapXX" have been removed, and BMP image format operations appropriately integrated into existing utils::CMRPTImage and utils::CMRPTImageFloat classes.
		- Now 3D scenes are supported through "opengl::COpenGLScene", objects in "mrpt::opengl" namespace, and an external 3D Scene viewer application for Windows.
	- DEC-2006:
		- Addition of TCP/IP sockets, through classes utils::CServerTCPSocket and utils::CClientTCPSocket, allowing serialization of MRPT objects through a TCP socket.
		- New classes in HWDRIVERS namespace allow using serial ports and interfacing GPS units.
		- A new interface utils::CMRPTCanvas has been defined for enabling drawing primitives to be implemented in graphical classes.
		- New class gui::CDisplayWindow for visualization of images in a GUI.
		- Portability issues solved for compatibility with Microsoft Visual Studio 2005 (VC8), including the new standard C++ library "secure" functions.
		- A new class "mrpt::slam::CMultiMetricMap" has been introduced for storing any set of metric maps, in a much more convenient and flexible way that the previous (non existing now) class "mrpt::slam::CHybridMetricMap"
	- NOV-2006:
		- The new Optimal Auxiliary Particle Filter has been implemented in "poses::CPosePDFParticles", and in "mrpt::slam::CMultiMetricMapPDF"
		- BUG FIXED: In matrix inversion, into class "math::CMatrixTemplateNumeric".
		- RANSAC method added for correspondences-pair lists, in "mrpt::slam::CICP::robustRigidTransformation"
	- OCT-2006:
		- The Dieter Fox's algorithm "KLD-sampling" for adative particle filter has been implemented in the class "poses::CPosePDFParticles"
		- Major changes in the way bayes::CParticleFilter works: Now there are four diferent particle filter algorithms defined.
		- New utils::MATH functions added (chi-square and normal quantiles, etc...)
		- A new probabilistic motion model has been added to "mrpt::slam::CActionRobotMovement2D", the particles draw process described in Thrun's 2006 book.
	- SEP-2006:
		- The Lu & Milios algorithm now works with any user-supplied matrix of pose constrains. See "mrpt::slam::CConsistentObservationAlignment".
		- A new generic matrix template has been created, "math::CMatrixTemplate" and "math::CMatrixTemplateNumeric", which are now the base for math::CMatrix and math::CMatrixD.
		- Template functions defined for dealing with STL's vectors: basic math operations, printing to screen,... in "utils::MATH"
		- The mrpt::slam::CICP algorithm now also deals with mrpt::slam::CLandmarksMap metric maps.
	- AUG-2006:
		- A new SLAM framework has been implemented in the main class mrpt::slam::CHierarchicalMappingFramework
		- A new class added for managing INI-like config files "utils::CConfigFile".
		- Hill-climbing algorithm "utils::CHillClimbing" added to the library.
		- Improved SIFT features detection, triangulation and matching in "mrpt::slam::CLandmarksMap" for pairs of stereo images.
	- JUN-2006:
		- New functions added to "poses::CPointPDFGaussian" for Bayesian fusion, correspondence likelihood,...
	- MAY-2006:
		- Introduction of "pixel to 3D" functions in vision
		- SIFT features extractor moved to vision
	- ABR-2006:
		- mrpt::slam::CLandmarksMap now works with SIFT features: loading from images, fusing,...
		- SIFT features extractor in "utils::CMRPTImage"
	- FEB-2006:
		- The class mrpt::slam::COccupancyGrid2D now uses 16bit for storing cell values, and many new options added.
		- Rao-Blackwellized Particle filters now supported in class mrpt::slam::CMultiMetricMapPDF
	- JAN-2006:
		- Landmarks-based maps now supported with mrpt::slam::CLandmarksMap
		- ZIP compression supported with the introduction of classes in the new namespace compress::zip.
		- Rao-Balckwellized particle filter mapping supported with mrpt::slam::CMetricMapBuilderRBPF
		- Points map are now fused considering the weights of points (mrpt::slam::CSimplePointsMap)
		- Definition of a new class mrpt::slam::CMetricMapBuilding for grouping map building methods.
		- Addition of a new class for 3D occupancy grid building.
		- New types of points map derived from mrpt::slam::CMetricMap.
	- DEC-2005:
		- New methods added to MRML, for circular robots paths planning. See the base class mrpt::slam::CPathPlanningMethod
		- The method by Lu & Milios for consistent maps alignment has been integrated into the MRML library, in the mrpt::slam::CConsistentObservationAlignment
		- The CObservation-derived classes has been modified to adhere to the "BABEL modules proposal for robotics architecture" (Technical report, dec.2005)
		- Metrics maps has been grouped using a common base class: mrpt::slam::CMetricMap
		- The spectral-based method for maps partitioning has been integrated into the MRML library, in the class mrpt::slam::CIncrementalMapPartitioner.
		- CObservationLaserRangeScan renamed as CObservation2DRangeScan.
	- NOV-2005:
		- New types of observations added (mrpt::slam::CObservation descendant classes) for images (from a camera) and for sonar readings.
	- OCT-2005:
		- New class added: A simple SLAM method for 2D localization and simple, metric maps building (non-hierarchical global maps). See mrpt::slam::CSimple2DSLAM.
		- Addition of "streaming versioning" for mrpt::utils::CSerializable classes.
		- A new observation type has been introduced, the mrpt::slam::CObservationIRRing.
		- Introduction of 3D poses using 4x4 transformation matrices and yaw/pitch/roll angles.
		- Polymorphism mechanishs for mrpt::utils::CSerializable derived classes and correct streaming using "<<" and ">>" operators has been provided through a set of "#define"'s and functions. See CSerializable.h
	- SEP-2005:
		- Reactive Navigator totally rewritten for integration into MRPT applications repository (See MRPT::reactivenav::CReactiveNavigationSystem).
		- Added MRPT applications repository section.
	- AUG-2005:
		- Particle filters basic algorithm added to UTILS library.
 		- Bitmap classes (utils::CBitmap) totally rewritten for a sensible use of classes inheritance.
	- JUN-2005:
		- First version of the library! there are a few classes for matrix manipulation, 2D point map management, and an implementation of the ICP algorithm.

*/

