/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Perception and Robotics               |
   |      research group, University of Malaga (Spain).                        |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

/** FILE: mrpt/core.h
	USE: This file includes all the headers of the library "libmrpt-core".
	      This includes several namespaces: 
			mrpt::utils
			mrpt::system
			mrpt::utils
			mrpt::math
			mrpt::bayes
			mrpt::opengl
			...
  */
#ifndef mrpt_core_H
#define mrpt_core_H

#include <mrpt/config.h>
#include <mrpt/version.h>

#include "bayes.h"
#include "compress.h"
#include "gui.h"
#include "math_mrpt.h"
#include "opengl.h"
#include "poses.h"
#include "random.h"
#include "scan_matching.h"
#include "slam.h"
#include "synch.h"
#include "system.h"
#include "utils.h"
#include "vision.h"
#include "topography.h"

#endif

