/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef mrpt_utils_H
#define mrpt_utils_H

#include <mrpt/utils/utils_defs.h>

/** This is the global namespace for all Mobile Robot Porgramming Toolkit (MRPT) libraries.
 */
namespace mrpt
{
	/** You must call mrpt::registerAllClasses() before parsing objects from binary streams of classes
	  *   that are not explicitly used in your application. If it is called more than once, it has no effect.
	  *   Only classes in the libmrpt-core are registered here.
	  */
	void MRPTDLLIMPEXP registerAllClasses();
}

#include <mrpt/utils/CDebugOutputCapable.h>
#include <mrpt/utils/CStringList.h>

// CStream related classes:
#include <mrpt/utils/CSerializable.h>
#include <mrpt/utils/CStream.h>
#include <mrpt/utils/CMemoryStream.h>
#include <mrpt/utils/CMemoryChunk.h>
#include <mrpt/utils/CStdOutStream.h>
#include <mrpt/utils/CFileStream.h>

#include <mrpt/utils/CFileInputStream.h>
#include <mrpt/utils/CFileOutputStream.h>
#include <mrpt/utils/CFileGZInputStream.h>
#include <mrpt/utils/CFileGZOutputStream.h>

// TCP sockets:
#include <mrpt/utils/CServerTCPSocket.h>
#include <mrpt/utils/CClientTCPSocket.h>

#include <mrpt/utils/CEnhancedMetaFile.h>
#include <mrpt/utils/CMRPTCanvas.h>
#include <mrpt/utils/CMRPTImage.h>
#include <mrpt/utils/CMRPTImageFloat.h>
#include <mrpt/utils/CMappedImage.h>
#include <mrpt/utils/CTicTac.h>
#include <mrpt/utils/CSimpleDatabase.h>
#include <mrpt/utils/CPropertiesValuesList.h>
#include <mrpt/utils/CMHPropertiesValuesList.h>
#include <mrpt/utils/CTypeSelector.h>
#include <mrpt/utils/CLoadableOptions.h>
#include <mrpt/utils/CMRPTMessage.h>

#include <mrpt/utils/CConfigFile.h>
#include <mrpt/utils/CConfigFileMemory.h>
#include <mrpt/utils/CMessageQueue.h>
#include <mrpt/utils/CDynamicGrid.h>

#include <mrpt/utils/CConsoleRedirector.h>
#include <mrpt/utils/stl_extensions.h>
#include <mrpt/utils/metaprogramming.h>
#include <mrpt/utils/exceptions.h>

#endif

