/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */


/**************************************************************************
 Application: mono-slam

  - 2007:
	The first version of this application, the corresponding classes
	and config files were developed by Antonio J. Ortiz de Galisteo
	as part of his Master Thesis at the University of Malaga (2007).

  - Jan-May 2009:
	- mono-slam updated and integrated back into MRPT by M.A. Amiri Atashgah (MAAA)
	  at the University of Sharif Technology, Tehran, Iran (2009).
	- Application converted into a GUI program (Jose Luis Blanco).

 **************************************************************************/

#include "mono_slamMain.h"
#include "mono_slamApp.h"
#include "CAboutBox.h"
#include "CDlgCalibParams.h"
#include "CDlgCalibrationWizard.h"

#include <wx/msgdlg.h>
#include <wx/artprov.h>
#include <wx/dirdlg.h>


//(*InternalHeaders(mono_slamDialog)
#include <wx/settings.h>
#include <wx/font.h>
#include <wx/intl.h>
#include <wx/string.h>
//*)


#include "imgs/icon_main.xpm"
#include "../wx-common/mrpt_logo.xpm"


mono_slamDialog *theMainWin = NULL;



using namespace std;
using namespace mrpt;
using namespace mrpt::opengl;
using namespace mrpt::vision;
using namespace mrpt::slam;
using namespace mrpt::poses;
using namespace mrpt::utils;
using namespace mrpt::system;
using namespace mrpt::gui;
using namespace mrpt::monoslam;



//(*IdInit(mono_slamDialog)
const long mono_slamDialog::ID_CUSTOM1 = wxNewId();
const long mono_slamDialog::ID_XY_GLCANVAS = wxNewId();
const long mono_slamDialog::ID_CHECKBOX1 = wxNewId();
const long mono_slamDialog::ID_BUTTON3 = wxNewId();
const long mono_slamDialog::ID_BUTTON4 = wxNewId();
const long mono_slamDialog::ID_BUTTON6 = wxNewId();
const long mono_slamDialog::ID_BUTTON5 = wxNewId();
const long mono_slamDialog::ID_CUSTOM2 = wxNewId();
const long mono_slamDialog::ID_BUTTON11 = wxNewId();
const long mono_slamDialog::ID_PANEL1 = wxNewId();
const long mono_slamDialog::ID_BUTTON7 = wxNewId();
const long mono_slamDialog::ID_BUTTON8 = wxNewId();
const long mono_slamDialog::ID_BUTTON9 = wxNewId();
const long mono_slamDialog::ID_BUTTON10 = wxNewId();
const long mono_slamDialog::ID_BUTTON13 = wxNewId();
const long mono_slamDialog::ID_BUTTON14 = wxNewId();
const long mono_slamDialog::ID_PANEL2 = wxNewId();
const long mono_slamDialog::ID_CHECKBOX3 = wxNewId();
const long mono_slamDialog::ID_TEXTCTRL5 = wxNewId();
const long mono_slamDialog::ID_TEXTCTRL4 = wxNewId();
const long mono_slamDialog::ID_BUTTON12 = wxNewId();
const long mono_slamDialog::ID_BUTTON1 = wxNewId();
const long mono_slamDialog::ID_BUTTON2 = wxNewId();
const long mono_slamDialog::ID_TIMER1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(mono_slamDialog,wxDialog)
    //(*EventTable(mono_slamDialog)
    //*)
END_EVENT_TABLE()



// A custom Art provider for customizing the icons:
class MyArtProvider : public wxArtProvider
{
protected:
    virtual wxBitmap CreateBitmap(const wxArtID& id,
                                  const wxArtClient& client,
                                  const wxSize& size);
};

// CreateBitmap function
wxBitmap MyArtProvider::CreateBitmap(const wxArtID& id,
                                     const wxArtClient& client,
                                     const wxSize& size)
{
    if (id == wxART_MAKE_ART_ID(MAIN_ICON))   return wxBitmap(icon_main_xpm);
    if (id == wxART_MAKE_ART_ID(IMG_MRPT_LOGO))  return wxBitmap(mrpt_logo_xpm);

    // Any wxWidgets icons not implemented here
    // will be provided by the default art provider.
    return wxNullBitmap;
}


/* ------------------------------------------------------------------------
				ctor
   ------------------------------------------------------------------------ */
mono_slamDialog::mono_slamDialog(wxWindow* parent,wxWindowID id)
{
	theMainWin = this;

	// Load my custom icons:
#if wxCHECK_VERSION(2, 8, 0)
    wxArtProvider::Push(new MyArtProvider);
#else
    wxArtProvider::PushProvider(new MyArtProvider);
#endif

    //(*Initialize(mono_slamDialog)
    wxFlexGridSizer* FlexGridSizer4;
    wxFlexGridSizer* FlexGridSizer10;
    wxFlexGridSizer* FlexGridSizer3;
    wxFlexGridSizer* FlexGridSizer5;
    wxFlexGridSizer* FlexGridSizer9;
    wxFlexGridSizer* FlexGridSizer2;
    wxFlexGridSizer* FlexGridSizer7;
    wxStaticBoxSizer* StaticBoxSizer3;
    wxGridSizer* GridSizer1;
    wxFlexGridSizer* FlexGridSizer15;
    wxFlexGridSizer* FlexGridSizer8;
    wxFlexGridSizer* FlexGridSizer14;
    wxFlexGridSizer* FlexGridSizer6;
    wxFlexGridSizer* FlexGridSizer17;
    wxStaticBoxSizer* StaticBoxSizer5;
    
    Create(parent, wxID_ANY, _("mono-slam"), wxDefaultPosition, wxDefaultSize, wxCAPTION|wxSYSTEM_MENU|wxRESIZE_BORDER|wxCLOSE_BOX|wxMAXIMIZE_BOX|wxMINIMIZE_BOX, _T("wxID_ANY"));
    Move(wxPoint(100,100));
    FlexGridSizer1 = new wxFlexGridSizer(1, 2, 0, 0);
    FlexGridSizer1->AddGrowableCol(0);
    FlexGridSizer1->AddGrowableCol(1);
    FlexGridSizer1->AddGrowableRow(0);
    FlexGridSizer2 = new wxFlexGridSizer(2, 1, 0, 0);
    FlexGridSizer2->AddGrowableCol(0);
    FlexGridSizer2->AddGrowableRow(1);
    m_realtime2Dview = new mrpt::gui::wxMRPTImageControl(this,ID_CUSTOM1,wxDefaultPosition.x,wxDefaultPosition.y,wxSize(640,480).GetWidth(), wxSize(640,480).GetHeight() );
    FlexGridSizer2->Add(m_realtime2Dview, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    m_realtime3Dview = new CMyGLCanvas(this,ID_XY_GLCANVAS,wxDefaultPosition,wxSize(-1,300),wxTAB_TRAVERSAL,_T("ID_XY_GLCANVAS"));
    FlexGridSizer2->Add(m_realtime3Dview, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer1->Add(FlexGridSizer2, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer3 = new wxFlexGridSizer(5, 1, 0, 0);
    FlexGridSizer3->AddGrowableCol(0);
    FlexGridSizer3->AddGrowableRow(3);
    StaticBoxSizer3 = new wxStaticBoxSizer(wxHORIZONTAL, this, _("Operation"));
    FlexGridSizer6 = new wxFlexGridSizer(2, 3, 0, 0);
    cbStepByStep = new wxCheckBox(this, ID_CHECKBOX1, _("Step by step"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX1"));
    cbStepByStep->SetValue(false);
    FlexGridSizer6->Add(cbStepByStep, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer6->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnReset = new wxButton(this, ID_BUTTON3, _("Reset filter"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
    FlexGridSizer6->Add(btnReset, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnRun = new wxButton(this, ID_BUTTON4, _("Start"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON4"));
    wxFont btnRunFont(wxDEFAULT,wxDEFAULT,wxFONTSTYLE_NORMAL,wxBOLD,false,wxEmptyString,wxFONTENCODING_DEFAULT);
    btnRun->SetFont(btnRunFont);
    FlexGridSizer6->Add(btnRun, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnGoOneStep = new wxButton(this, ID_BUTTON6, _("Go one step..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON6"));
    btnGoOneStep->Disable();
    FlexGridSizer6->Add(btnGoOneStep, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnStop = new wxButton(this, ID_BUTTON5, _("Stop"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
    btnStop->Disable();
    FlexGridSizer6->Add(btnStop, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    StaticBoxSizer3->Add(FlexGridSizer6, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer3->Add(StaticBoxSizer3, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 2);
    boxVideo = new wxStaticBoxSizer(wxVERTICAL, this, _("Video source (select the desired tab)"));
    panCamParams = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
    FlexGridSizer4 = new wxFlexGridSizer(2, 1, 0, 0);
    FlexGridSizer4->AddGrowableCol(0);
    FlexGridSizer4->AddGrowableRow(0);
    m_panelCamera = new mrpt::gui::CPanelCameraSelection(panCamParams,ID_CUSTOM2);
    FlexGridSizer4->Add(m_panelCamera, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer17 = new wxFlexGridSizer(1, 1, 0, 0);
    btnCalibWizard = new wxButton(panCamParams, ID_BUTTON11, _("Calibration Wizard..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON11"));
    FlexGridSizer17->Add(btnCalibWizard, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer4->Add(FlexGridSizer17, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    panCamParams->SetSizer(FlexGridSizer4);
    FlexGridSizer4->Fit(panCamParams);
    FlexGridSizer4->SetSizeHints(panCamParams);
    boxVideo->Add(panCamParams, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer3->Add(boxVideo, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 2);
    boxParams = new wxStaticBoxSizer(wxHORIZONTAL, this, _(" Parameters "));
    GridSizer1 = new wxGridSizer(1, 1, 0, 0);
    panParams = new wxPanel(this, ID_PANEL2, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL2"));
    FlexGridSizer5 = new wxFlexGridSizer(2, 1, 0, 0);
    FlexGridSizer5->AddGrowableCol(0);
    FlexGridSizer7 = new wxFlexGridSizer(1, 3, 0, 0);
    btnLoadParams = new wxButton(panParams, ID_BUTTON7, _("Load from file..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON7"));
    FlexGridSizer7->Add(btnLoadParams, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnSaveParams = new wxButton(panParams, ID_BUTTON8, _("Save to file..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON8"));
    FlexGridSizer7->Add(btnSaveParams, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer5->Add(FlexGridSizer7, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer10 = new wxFlexGridSizer(2, 2, 0, 0);
    FlexGridSizer10->AddGrowableCol(0);
    FlexGridSizer10->AddGrowableCol(1);
    btnParamsMonoslam = new wxButton(panParams, ID_BUTTON9, _("Mono-SLAM params"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON9"));
    FlexGridSizer10->Add(btnParamsMonoslam, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnEditCalib = new wxButton(panParams, ID_BUTTON10, _("Camera calibration"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON10"));
    FlexGridSizer10->Add(btnEditCalib, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnParamsKF = new wxButton(panParams, ID_BUTTON13, _("Kalman Filter"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON13"));
    FlexGridSizer10->Add(btnParamsKF, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnMotionParams = new wxButton(panParams, ID_BUTTON14, _("Motion model"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON14"));
    FlexGridSizer10->Add(btnMotionParams, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer5->Add(FlexGridSizer10, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    panParams->SetSizer(FlexGridSizer5);
    FlexGridSizer5->Fit(panParams);
    FlexGridSizer5->SetSizeHints(panParams);
    GridSizer1->Add(panParams, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    boxParams->Add(GridSizer1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer3->Add(boxParams, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 2);
    StaticBoxSizer5 = new wxStaticBoxSizer(wxHORIZONTAL, this, _("Log"));
    FlexGridSizer8 = new wxFlexGridSizer(2, 1, 0, 0);
    FlexGridSizer8->AddGrowableCol(0);
    FlexGridSizer8->AddGrowableRow(1);
    FlexGridSizer15 = new wxFlexGridSizer(1, 2, 0, 0);
    FlexGridSizer15->AddGrowableCol(1);
    cbSaveLogFile = new wxCheckBox(this, ID_CHECKBOX3, _("Save log to file:"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_CHECKBOX3"));
    cbSaveLogFile->SetValue(false);
    FlexGridSizer15->Add(cbSaveLogFile, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    edLogFile = new wxTextCtrl(this, ID_TEXTCTRL5, _("./monoslam_log.txt"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_TEXTCTRL5"));
    FlexGridSizer15->Add(edLogFile, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer8->Add(FlexGridSizer15, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer14 = new wxFlexGridSizer(1, 1, 0, 0);
    FlexGridSizer14->AddGrowableCol(0);
    FlexGridSizer14->AddGrowableRow(0);
    edLog = new wxTextCtrl(this, ID_TEXTCTRL4, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_AUTO_SCROLL|wxTE_MULTILINE|wxTE_READONLY|wxHSCROLL|wxTE_DONTWRAP|wxVSCROLL|wxALWAYS_SHOW_SB, wxDefaultValidator, _T("ID_TEXTCTRL4"));
    wxFont edLogFont = wxSystemSettings::GetFont(wxSYS_OEM_FIXED_FONT);
    if ( !edLogFont.Ok() ) edLogFont = wxSystemSettings::GetFont(wxSYS_DEFAULT_GUI_FONT);
    edLogFont.SetPointSize(7);
    edLog->SetFont(edLogFont);
    FlexGridSizer14->Add(edLog, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer8->Add(FlexGridSizer14, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    StaticBoxSizer5->Add(FlexGridSizer8, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    FlexGridSizer3->Add(StaticBoxSizer5, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    FlexGridSizer9 = new wxFlexGridSizer(1, 3, 0, 0);
    btnHelp = new wxButton(this, ID_BUTTON12, _("Help..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON12"));
    FlexGridSizer9->Add(btnHelp, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnAbout = new wxButton(this, ID_BUTTON1, _("About..."), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
    FlexGridSizer9->Add(btnAbout, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    btnQuit = new wxButton(this, ID_BUTTON2, _("Quit"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
    FlexGridSizer9->Add(btnQuit, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
    FlexGridSizer3->Add(FlexGridSizer9, 1, wxALL|wxALIGN_RIGHT|wxALIGN_TOP, 2);
    FlexGridSizer1->Add(FlexGridSizer3, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
    SetSizer(FlexGridSizer1);
    timDoOneStep.SetOwner(this, ID_TIMER1);
    FlexGridSizer1->Fit(this);
    FlexGridSizer1->SetSizeHints(this);
    
    Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnResetClick);
    Connect(ID_BUTTON4,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnRunClick);
    Connect(ID_BUTTON6,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnGoOneStepClick);
    Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnStopClick);
    Connect(ID_BUTTON11,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnCalibWizardClick);
    Connect(ID_BUTTON7,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnLoadParamsClick);
    Connect(ID_BUTTON8,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnSaveParamsClick);
    Connect(ID_BUTTON9,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnParamsMonoslamClick);
    Connect(ID_BUTTON10,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnEditCalibClick);
    Connect(ID_BUTTON13,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnParamsKFClick);
    Connect(ID_BUTTON14,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnMotionParamsClick);
    Connect(ID_BUTTON12,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnHelpClick);
    Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnAbout);
    Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&mono_slamDialog::OnbtnQuitClick);
    Connect(ID_TIMER1,wxEVT_TIMER,(wxObjectEventFunction)&mono_slamDialog::OntimDoOneStepTrigger);
    //*)


	m_myRedirector = new CMyRedirector(edLog, false, 40, true);


	m_realtime3Dview->clearColorR = 0.2;
	m_realtime3Dview->clearColorG = 0.2;
	m_realtime3Dview->clearColorB = 0.2;

	m_realtime3Dview->cameraZoomDistance = 5.0;


	// Setup the mono-slam object:
	// this->m_monoslam...

    // Extra init:
    {
		CImage	auxImg(640,480);

		auxImg.textOut(10,10,"* Image capture stopped *", TColor::white );

		m_realtime2Dview->AssignImage( auxImg );
    }


    {
    wxIcon FrameIcon;
    FrameIcon.CopyFromBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("MAIN_ICON")),wxART_FRAME_ICON));
    SetIcon(FrameIcon);
    }

	SetTitle(_U( (string("Monocular SLAM ")+string(MONOSLAM_VERSION) + string(" - Part of the MRPT project")).c_str()  ));

	// Prepare 3d view:
	update3DView(false);


	wxMessageBox(_("This application is NOT functional yet.\n Please, contact the MRPT authors if you are interested in helping."),_("**Warning**"));

}

/* ------------------------------------------------------------------------
				Dtor
   ------------------------------------------------------------------------ */
mono_slamDialog::~mono_slamDialog()
{
    //(*Destroy(mono_slamDialog)
    //*)
    delete m_myRedirector;
    m_myRedirector = NULL;

	// Close video source:
	m_monoslam.m_camera.clear();
}

/* ------------------------------------------------------------------------
				update3DView
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnQuitClick(wxCommandEvent& event)
{
	Close();
}

/* ------------------------------------------------------------------------
				OnAbout
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnAbout(wxCommandEvent& event)
{
	CAboutBox dlg(this);
	dlg.ShowModal();
}


/* ------------------------------------------------------------------------
				update3DView
   ------------------------------------------------------------------------ */
void mono_slamDialog::update3DView(bool refresh )
{
	m_realtime3Dview->m_openGLScene->clear();

	if (!m_realtime3Dview->m_openGLScene->getByName("world_axis"))
	{
		m_realtime3Dview->m_openGLScene->insert( CAxis::Create(-10,-10,-10, 10,10,10,  2.5, 2.0, true) );
	}


	if (refresh)
		m_realtime3Dview->Refresh();

}


/* ------------------------------------------------------------------------
				update3DView
   ------------------------------------------------------------------------ */
void mono_slamDialog::Onm_realtime2DviewResize(wxSizeEvent& event)
{
	// m_realtime2Dview->Refresh();
}

/* ------------------------------------------------------------------------
				RUN
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnRunClick(wxCommandEvent& event)
{
	// Open the video source:
	if (!prepareVideoSource())
		return;


	//pagesCameras->Disable();
	//cbGrayscale->Disable();
	panCamParams->Disable();
	panParams->Disable();

	btnStop->Enable();
	
	if (cbStepByStep->GetValue())
		btnGoOneStep->Enable();

	btnRun->Disable();

	// Reset the MonoSLAM state:
	m_monoslam.resetFilterState();

	timDoOneStep.Start(2,true); // One shot
}

/* ------------------------------------------------------------------------
				1 STEP
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnGoOneStepClick(wxCommandEvent& event)
{
	timDoOneStep.Start(2,true); // One shot
}

/* ------------------------------------------------------------------------
				STOP
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnStopClick(wxCommandEvent& event)
{
	btnStop->Disable();
	btnRun->Enable();
	btnGoOneStep->Disable();

	//pagesCameras->Enable();
	//cbGrayscale->Enable();
	panCamParams->Enable();
	panParams->Enable();
	

	if (m_monoslam.m_camera)
		m_monoslam.m_camera.clear();
}

/* ------------------------------------------------------------------------
				RESET
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnResetClick(wxCommandEvent& event)
{
	// Reset the MonoSLAM state:
	m_monoslam.resetFilterState();
}


/* ------------------------------------------------------------------------
				prepareVideoSource
   ------------------------------------------------------------------------ */
bool mono_slamDialog::prepareVideoSource()
{
	try
	{
		if (m_monoslam.m_camera) m_monoslam.m_camera.clear();
		m_monoslam.m_camera = mrpt::hwdrivers::prepareVideoSourceFromPanel(m_panelCamera);
		if (!m_monoslam.m_camera) { try { wxCommandEvent  dum; this->OnbtnStopClick(dum); } catch(...) {} }
		return true;
	}
	catch(std::exception &e)
	{
		try { wxCommandEvent  dum; this->OnbtnStopClick(dum); } catch(...) {}
		cerr << endl << e.what() << endl;
		wxMessageBox(_("Couldn't open video source"),_("Error"));
		return false;
	}
}

/* ------------------------------------------------------------------------
				prepareVideoSource
   ------------------------------------------------------------------------ */
void mono_slamDialog::OntimDoOneStepTrigger(wxTimerEvent& event)
{
	try
	{
		if (btnRun->IsEnabled()) return;

		ASSERT_(m_monoslam.m_camera)

		// This is done WITHIN CMonoSlamInterface:
		/*CObservationPtr obs = m_monoslam.m_camera->getNextFrame();
		ASSERT_(obs)
		ASSERT_(IS_CLASS(obs,CObservationImage))

		// get the observation:
		CObservationImagePtr  obs_img = CObservationImagePtr(obs);*/

		// Send image to mono-slam for processing:
		// ------------------------------------------------------
		this->m_monoslam.go_one_step();

		// get image to show in 2D:
		// -----------------------------
		CImage  &img_to_show = m_monoslam.m_progress2D;
		//obs_img->image;


		// Estimate FPS:
		// ------------------------------------------------------
		static CTicTac  tictac;
		static double last_FPS = 1;
		static const double fps_est_alpha = 0.1;

		double this_FPS = 1.0/std::max(0.001,tictac.Tac());
		tictac.Tic();
		last_FPS = fps_est_alpha*this_FPS + (1-fps_est_alpha)*last_FPS;
		img_to_show.textOut(10,10,format("%.02f FPS",last_FPS), TColor::white );

		// Resize the display area, if needed:
		if (std::abs( (int)(this->m_realtime2Dview->GetClientSize().GetWidth()) - int(img_to_show.getWidth()) )>30 )
		{
			this->m_realtime2Dview->SetSize( img_to_show.getWidth(), img_to_show.getHeight() );
			this->m_realtime2Dview->SetMinSize( wxSize(img_to_show.getWidth(), img_to_show.getHeight()) );
			this->FlexGridSizer1->RecalcSizes();
			this->Fit();
		}


		m_realtime2Dview->AssignImage( img_to_show );
		m_realtime2Dview->Refresh(false);

		wxTheApp->Yield();


		// Prepare to run the next step, unless in step-by-step mode:
		if (!cbStepByStep->GetValue())
			timDoOneStep.Start(2,true); // One shot

	}
	catch(std::exception &e)
	{
		try { wxCommandEvent  dum; this->OnbtnStopClick(dum); } catch(...) {}
		cerr << endl << e.what() << endl;
		wxMessageBox(_("Error..."),_("Error"));
		return;
	}
}


void mono_slamDialog::OnbtnEditCalibClick(wxCommandEvent& event)
{
	CDlgCalibParams	dlg(this);
	if (dlg.ShowModal() == wxID_OK)
	{

	}
}

void mono_slamDialog::OnbtnCalibWizardClick(wxCommandEvent& event)
{
	CDlgCalibrationWizard   dlgCalibWizard(this);

	// Create dialog:
	{
		CImage	auxImg(640,480);
		auxImg.textOut(10,10,"* Image capture stopped *", TColor::white );
		dlgCalibWizard.m_realtimeCalibView->AssignImage(auxImg);
	}
	dlgCalibWizard.ShowModal();
}

// Help
void mono_slamDialog::OnbtnHelpClick(wxCommandEvent& event)
{

}

// Load all params:
void mono_slamDialog::OnbtnLoadParamsClick(wxCommandEvent& event)
{
	try
	{
		wxFileDialog dialog(this, _("Load configuration file"),_("."), _(""),_("Configuration files (*.ini,*.cfg)|*.ini;*.cfg|All files (*.*)|*.*"), wxFD_OPEN | wxFD_FILE_MUST_EXIST );
		if (dialog.ShowModal() == wxID_OK)
		{
			CConfigFile	cfg( string(dialog.GetPath().mb_str()) );
			m_monoslam.loadParameters( cfg );
		}
	}
	catch(std::exception &e)
	{
		cerr << endl << e.what() << endl;
		wxMessageBox( wxString::Format(_("Error loading file:\n%s"),e.what()),_("Error"));
	}
}

// Save all params:
void mono_slamDialog::OnbtnSaveParamsClick(wxCommandEvent& event)
{
	try
	{
		wxFileDialog dialog(this, _("Save configuration file"),_("."), _(""),_("Configuration files (*.ini,*.cfg)|*.ini;*.cfg|All files (*.*)|*.*"), wxFD_SAVE | wxFD_OVERWRITE_PROMPT );
		if (dialog.ShowModal() == wxID_OK)
		{
			CConfigFile	cfg( string(dialog.GetPath().mb_str()) );
			m_monoslam.saveParameters( cfg );
		}
	}
	catch(std::exception &e)
	{
		cerr << endl << e.what() << endl;
		wxMessageBox( wxString::Format(_("Error saving file:\n%s"),e.what()),_("Error"));
	}
}


/* ------------------------------------------------------------------------
				MonoSLAM params
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnParamsMonoslamClick(wxCommandEvent& event)
{
}

/* ------------------------------------------------------------------------
				MotionModel Params
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnMotionParamsClick(wxCommandEvent& event)
{
}

/* ------------------------------------------------------------------------
				KF Params
   ------------------------------------------------------------------------ */
void mono_slamDialog::OnbtnParamsKFClick(wxCommandEvent& event)
{
}
