/* +---------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)               |
   |                          https://www.mrpt.org/                            |
   |                                                                           |
   | Copyright (c) 2005-2020, Individual contributors, see AUTHORS file        |
   | See: https://www.mrpt.org/Authors - All rights reserved.                  |
   | Released under BSD License. See details in https://www.mrpt.org/License   |
   +---------------------------------------------------------------------------+
 */


/** \mainpage The Mobile Robot Programming Toolkit (MRPT)
 *

<div align=center >
	<b>Version: 1.9.9 Git: 938ff0793 Fri May 24 00:36:29 2019 +0200</b> <br>
</div>
<hr>

# About

This is the home of the MRPT C++ library documentation generated by Doxygen.
See:
 - The [CHANGELOG](changelog.html) for this version.
 - Complete list of classes [here](annotated.html).
 - [List of libraries and modules](modules.html).
 - [Collection of MRPT tutorials](https://www.mrpt.org/Tutorials/)

# Libraries / Modules

Click on a library name to explore its contents, or check the [complete list](modules.html).

<div align=center >
\dot
digraph MRPT_LIBS {

	node [shape=box,style=filled, fillcolor="#D0D0D0"];

	bayes [label="mrpt-bayes",URL="group__mrpt__bayes__grp.html"];
	bayes -> math;
	bayes -> config;

	comms [label="mrpt-comms",URL="group__mrpt__comms__grp.html"];
	comms -> io;

	config   [label="mrpt-config",URL="group__mrpt__config__grp.html"];
	config -> expr;
	config -> system;

	containers  [label="mrpt-containers",URL="group__mrpt__containers__grp.html"];
	containers -> core;

	{ rank = sink; 
	core       [label="mrpt-core",URL="group__mrpt__core__grp.html"];
	}

	db         [label="mrpt-db",URL="group__mrpt__db__grp.html"];
	db  -> serialization;
	db  -> system;

	detectors  [label="mrpt-detectors",URL="group__mrpt__detectors__grp.html"];
	detectors -> gui;
	detectors -> slam;

	expr       [label="mrpt-expr",URL="group__mrpt__expr__grp.html"];
	expr -> system;

	graphs     [label="mrpt-graphs",URL="group__mrpt__graphs__grp.html"];
	graphs -> opengl;

	graphslam  [label="mrpt-graphslam",URL="group__mrpt__graphslam__grp.html"];
	graphslam -> gui;
	graphslam -> slam;

	gui        [label="mrpt-gui",URL="group__mrpt__gui__grp.html"];
	gui -> opengl;

	hmtslam    [label="mrpt-hmtslam",URL="group__mrpt__hmtslam__grp.html"];
	hmtslam -> graphslam;

	hwdrivers  [label="mrpt-hwdrivers",URL="group__mrpt__hwdrivers__grp.html"];
	hwdrivers -> comms;
	hwdrivers -> gui;
	hwdrivers -> maps;
	hwdrivers -> vision;

	img [label="mrpt-img",URL="group__mrpt__img__grp.html"];
	img  -> io;
	img  -> math;
	img  -> config;

	io [label="mrpt-io",URL="group__mrpt__io__grp.html"];
	io  -> system;

	kinematics [label="mrpt-kinematics",URL="group__mrpt__kinematics__grp.html"];
	kinematics -> opengl;
	
	maps       [label="mrpt-maps",URL="group__mrpt__maps__grp.html"];
	maps -> graphs;
	maps -> obs;

	math       [label="mrpt-math",URL="group__mrpt__math__grp.html"];
	math -> serialization;
	math -> random;
	math -> system;
	math -> nanoflann;

	{ rank = sink; 
	nanoflann  [label="mrpt-nanoflann",URL="group__nanoflann__grp.html"];
	}

	nav        [label="mrpt-nav",URL="group__mrpt__nav__grp.html"];
	nav -> kinematics;
	nav -> maps;

	obs        [label="mrpt-obs",URL="group__mrpt__obs__grp.html"];
	obs -> opengl;
	obs -> db;
	obs -> tfest;

	opengl     [label="mrpt-opengl", URL="group__mrpt__opengl__grp.html"];
	opengl -> poses;
	opengl -> img;

	pbmap      [label="mrpt-pbmap",URL="group__mrpt__pbmap__grp.html"];
	pbmap -> graphs;

	poses     [label="mrpt-poses",URL="group__mrpt__poses__grp.html"];
	poses -> bayes;
	
	{ rank = sink; 
	random     [label="mrpt-random",URL="group__mrpt__random__grp.html"];
	}

	rtti     [label="mrpt-rtti",URL="group__mrpt__rtti__grp.html"];
	rtti -> core;
	rtti -> typemeta;

	serialization [label="mrpt-serialization",URL="group__mrpt__serialization__grp.html"];
	serialization -> rtti;

	slam       [label="mrpt-slam",URL="group__mrpt__slam__grp.html"];
	slam -> maps;
	slam -> vision;

	system     [label="mrpt-system",URL="group__mrpt__system__grp.html"];
	system -> typemeta;
	system -> containers;

	tfest      [label="mrpt-tfest",URL="group__mrpt__tfest__grp.html"];
	tfest -> poses;

	topography [label="mrpt-topography",URL="group__mrpt__topography__grp.html"];
	topography -> obs;

	{ rank = sink; 
	typemeta [label="mrpt-typemeta (.h)",URL="group__mrpt__typemeta__grp.html"];
	}

	vision     [label="mrpt-vision",URL="group__mrpt__vision__grp.html"];
	vision -> obs;
}

\enddot
</div>

[This page](https://www.mrpt.org/Libraries_tree_layout) explains the library directory layout.

## Dependencies

Check out <a href=dependencies.html >this page</a> to find out what are needed for each of the MRPT build dependencies (opencv, wxWidgets,...)
to decide if you need them for your applications.

## Performance benchmarks

Extensive performance tests are automated by means of the application , which was moved (2018)
to [its own Git repository](https://github.com/MRPT/mrpt-performance-tests).

The results on different platforms, as well as a comparison between different
compilers and platforms are published here: https://performance.mrpt.org/

*/
