/* +------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)            |
   |                          https://www.mrpt.org/                         |
   |                                                                        |
   | Copyright (c) 2005-2020, Individual contributors, see AUTHORS file     |
   | See: https://www.mrpt.org/Authors - All rights reserved.               |
   | Released under BSD License. See: https://www.mrpt.org/License          |
   +------------------------------------------------------------------------+ */

#include <gtest/gtest.h>
#include <mrpt/random/RandomGenerators.h>

TEST(Random, Randomize)
{
	using namespace mrpt::random;

	CRandomGenerator rnd;
	rnd.randomize(1);
	auto r1a = rnd.drawUniform32bit();
	rnd.randomize(2);
	auto r2a = rnd.drawUniform32bit();

	EXPECT_NE(r1a, r2a);

	rnd.randomize(1);
	auto r1abis = rnd.drawUniform32bit();
	EXPECT_EQ(r1a, r1abis);
}

TEST(Random, KnownSequence)
{
	const uint32_t seeds[5] = {1155500485U, 3258920289U, 2969816455U,
							   1886781181U, 2957178843U};

	const uint32_t psr_seq[5][30] = {
		{
			87159525U,   981136246U,  3024579417U, 810904736U,  3227960653U,
			2925322908U, 3041022042U, 8514697U,	238460451U,  3240846511U,
			77705137U,   3667487648U, 2812201483U, 2852662203U, 3563562135U,
			4182703524U, 2338642573U, 2453315481U, 893072632U,  555674637U,
			1958390156U, 2936372696U, 2958209661U, 3206235417U, 1393170953U,
			3459948533U, 3978094773U, 187006958U,  1094993014U, 3697569806U,
		},
		{
			740306787U,  1213665442U, 129332614U,  337857013U,  2827697054U,
			3921115624U, 3306026490U, 1982870663U, 3991370713U, 3031672994U,
			2187111251U, 2916846545U, 1508932967U, 4099179631U, 1795296805U,
			729143648U,  3078055758U, 2112818007U, 2996444232U, 2352470411U,
			1889456200U, 823633826U,  4271544093U, 3164819009U, 3155209922U,
			934184739U,  948314756U,  566002989U,  209716310U,  424306665U,
		},
		{
			4240204481U, 2332672160U, 2972009226U, 2500467979U, 2795915919U,
			772807544U,  3550866598U, 2774481806U, 2630334347U, 145201545U,
			1244209075U, 3412246962U, 412965843U,  1254713838U, 2414279976U,
			1634686767U, 1198938400U, 2482335177U, 3662174704U, 2090231824U,
			73364990U,   151986868U,  3009478209U, 4042788106U, 2315167490U,
			3883378205U, 1405261027U, 2984375936U, 4084849752U, 151767298U,
		},
		{
			2442517705U, 3154299563U, 627772564U,  609815136U,  80940975U,
			1175442950U, 1488732740U, 1806874014U, 1160095287U, 288113135U,
			750941403U,  1902059558U, 2231364929U, 1702611100U, 4036287674U,
			1609309781U, 1569584333U, 4232782017U, 682338830U,  3379158924U,
			2048597387U, 249255365U,  217448606U,  3204242587U, 2391908062U,
			1116368730U, 72649517U,   1674133514U, 1285581724U, 1072863427U,
		},
		{
			1465891278U, 2717027808U, 3786898353U, 1843368031U, 60506783U,
			2698460302U, 3794204567U, 735403158U,  2154018573U, 354675041U,
			955687956U,  54804884U,   3250611262U, 2708021793U, 3768186789U,
			3803268914U, 1902115381U, 1003259193U, 1253851151U, 2465171896U,
			464381829U,  705115420U,  857237366U,  1403154329U, 2290045722U,
			3880844611U, 251734302U,  1989036956U, 1141049890U, 1462380353U,
		}};

	for (int seed = 0; seed < 5; seed++)
	{
		auto& rnd = mrpt::random::getRandomGenerator();
		mrpt::random::Randomize(seeds[seed]);
		for (int i = 0; i < 30; i++)
		{
			const auto v = rnd.drawUniform32bit();
			EXPECT_EQ(v, psr_seq[seed][i])
				<< "seed=" << seed << " i=" << i << "\n";
		}
	}
}
