/*
 * merror.c
 * 
 * This file is part of msmtp, an SMTP client.
 *
 * Copyright (C) 2004	Martin Lambers <marlam@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */


#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "merror.h"

char errstr_buffer[MERROR_BUFSIZE];
char errstr_tmpbuf[MERROR_BUFSIZE];

/*
 * merror()
 *
 * see merror.h
 */

merror_t merror(int number, char *format, ...)
{
    merror_t e;
    va_list args;

    e.number = number;
    if (format)
    {
	e.errstr = errstr_buffer;
    	va_start(args, format);
	vsnprintf(errstr_tmpbuf, MERROR_BUFSIZE, format, args);
	va_end(args);
	strcpy(errstr_buffer, errstr_tmpbuf);
    }
    else
    {
	e.errstr = NULL;
    }
    
    return e;
}


/*
 * merror_ok()
 *
 * see merror.h
 */

int merror_ok(merror_t e)
{
    return (e.number == EOK);
}
