
#include <stdio.h>
#include <stddef.h>
#include <wchar.h>

/*
 * Takes a UTF-32 code as input and outputs UTF-8.
 * Based on  Roman Czyborra:  http://czyborra.com/utf/
 */

void
fputu8(wchar_t c,FILE *fp)
{
  if (c < 0x80) {		/* ASCII */
    putc (c,fp);
  }
  else if (c < 0x800) {
    putc (0xC0 | c>>6,fp);
    putc (0x80 | (c & 0x3F),fp);
  }
  else if (c < 0x10000) {
    putc (0xE0 | c>>12,fp);
    putc (0x80 | (c>>6 & 0x3F),fp);
    putc (0x80 | (c & 0x3F),fp);
  }
  else if (c < 0x200000) {	/* 2^21 */
    putc (0xF0 | c>>18,fp);
    putc (0x80 | (c>>12 & 0x3F),fp);
    putc (0x80 | (c>>6 & 0x3F),fp);
    putc (0x80 | (c & 0x3F),fp);
  }
}

/* 
 * Convert a null terminated UTF-32 string to UTF-8 and write it out.
 */

void
putu8s(wchar_t *str,FILE *fp)
{
  wchar_t *ptr;
  wchar_t c;

  ptr = str;
  while( (c = *ptr++) != L'\0'){
    fputu8(c,fp);
  }
}


