/* Map MCU preprocessor definitions to chip-specific include files.
 *
 * This file is automatically generated from TI-provided data.  Each device
 * is mapped to a genericized name by ignoring differences in memory type,
 * end-equipment optimization, and some other variances.  Preprocessor
 * directives are generated to include the appropriate header for each
 * device.  Generic names, such as msp430x1611, are recognized only if
 * they are sufficient to uniquely identify a device.  When this is not
 * the case, a comment indicates why a generic is excluded: normally
 * because devices have different peripherals or memory maps.
 */
#ifndef __msp430_h_
#define __msp430_h_

/** Date upstream material received from TI */
#define __MSP430MCU_UPSTREAM__ 20110509
/** Date of msp430mcu package release */
#define __MSP430MCU__ 20110612

/** Bit-markers for type of CPU present.
 * Check equality against __MSP430_CPU__. */
typedef enum msp430_cpu_e
{
  MSP430_CPU_MSP430 = 0x0000,
  MSP430_CPU_MSP430X = 0x0002,
  MSP430_CPU_MSP430XV2 = 0x0003,
  MSP430_CPU = 0x0003
} msp430_cpu_e;

/** Bit-markers for type of hardware multiplier present.
 * Check equality against __MSP430_MPY__ (undefined if not present). */
typedef enum msp430_mpy_e
{
  MSP430_MPY_NONE = 0x0000,
  MSP430_MPY_16 = 0x0010,
  MSP430_MPY_16SE = 0x0011,
  MSP430_MPY_32 = 0x0020,
  MSP430_MPY_32DW = 0x0022,
  MSP430_MPY = 0x0030
} msp430_mpy_e;


#if defined(__CC430_5133__) || defined(__CC430X5133__) || defined(__CC430F5133__)
#include <cc430f5133.h>
#endif /* Genericizable */

#if defined(__CC430_5135__) || defined(__CC430X5135__) || defined(__CC430F5135__)
#include <cc430f5135.h>
#endif /* Genericizable */

#if defined(__CC430_5137__) || defined(__CC430X5137__) || defined(__CC430F5137__)
#include <cc430f5137.h>
#endif /* Genericizable */

#if defined(__CC430_6125__) || defined(__CC430X6125__) || defined(__CC430F6125__)
#include <cc430f6125.h>
#endif /* Genericizable */

#if defined(__CC430_6126__) || defined(__CC430X6126__) || defined(__CC430F6126__)
#include <cc430f6126.h>
#endif /* Genericizable */

#if defined(__CC430_6127__) || defined(__CC430X6127__) || defined(__CC430F6127__)
#include <cc430f6127.h>
#endif /* Genericizable */

#if defined(__CC430_6135__) || defined(__CC430X6135__) || defined(__CC430F6135__)
#include <cc430f6135.h>
#endif /* Genericizable */

#if defined(__CC430_6137__) || defined(__CC430X6137__) || defined(__CC430F6137__)
#include <cc430f6137.h>
#endif /* Genericizable */

#if defined(__MSP430_091__) || defined(__MSP430X091__) || defined(__MSP430C091__)
#include <msp430c091.h>
#endif /* Genericizable */

#if defined(__MSP430L092__)
#include <msp430l092.h>
#endif /* Device mismatch msp430_092 */

#if defined(__MSP430C092__)
#include <msp430c092.h>
#endif /* Device mismatch msp430_092 */

#if defined(__MSP430_110__) || defined(__MSP430X110__) || defined(__MSP430F110__)
#include <msp430f110.h>
#endif /* Genericizable */

#if defined(__MSP430F1101__)
#include <msp430f1101.h>
#endif /* Multi-device msp430_1101 */

#if defined(__MSP430F1101A__)
#include <msp430f1101a.h>
#endif /* Multi-device msp430_1101 */

#if defined(__MSP430_111__) || defined(__MSP430X111__) || defined(__MSP430C111__)
#include <msp430c111.h>
#endif /* Genericizable */

#if defined(__MSP430F1111__)
#include <msp430f1111.h>
#endif /* Device mismatch msp430_1111 */

#if defined(__MSP430F1111A__)
#include <msp430f1111a.h>
#endif /* Device mismatch msp430_1111 */

#if defined(__MSP430C1111__)
#include <msp430c1111.h>
#endif /* Device mismatch msp430_1111 */

#if defined(__MSP430E112__)
#include <msp430e112.h>
#endif /* Device mismatch msp430_112 */

#if defined(__MSP430F112__)
#include <msp430f112.h>
#endif /* Device mismatch msp430_112 */

#if defined(__MSP430P112__)
#include <msp430p112.h>
#endif /* Device mismatch msp430_112 */

#if defined(__MSP430C112__)
#include <msp430c112.h>
#endif /* Device mismatch msp430_112 */

#if defined(__MSP430F1121__)
#include <msp430f1121.h>
#endif /* Device mismatch msp430_1121 */

#if defined(__MSP430F1121A__)
#include <msp430f1121a.h>
#endif /* Device mismatch msp430_1121 */

#if defined(__MSP430C1121__)
#include <msp430c1121.h>
#endif /* Device mismatch msp430_1121 */

#if defined(__MSP430_1122__) || defined(__MSP430X1122__) || defined(__MSP430F1122__)
#include <msp430f1122.h>
#endif /* Genericizable */

#if defined(__MSP430_1132__) || defined(__MSP430X1132__) || defined(__MSP430F1132__)
#include <msp430f1132.h>
#endif /* Genericizable */

#if defined(__MSP430_122__) || defined(__MSP430X122__) || defined(__MSP430F122__)
#include <msp430f122.h>
#endif /* Genericizable */

#if defined(__MSP430_1222__) || defined(__MSP430X1222__) || defined(__MSP430F1222__)
#include <msp430f1222.h>
#endif /* Genericizable */

#if defined(__MSP430_123__) || defined(__MSP430X123__) || defined(__MSP430F123__)
#include <msp430f123.h>
#endif /* Genericizable */

#if defined(__MSP430_1232__) || defined(__MSP430X1232__) || defined(__MSP430F1232__)
#include <msp430f1232.h>
#endif /* Genericizable */

#if defined(__MSP430_133__) || defined(__MSP430X133__) || defined(__MSP430F133__)
#include <msp430f133.h>
#endif /* Genericizable */

#if defined(__MSP430_1331__) || defined(__MSP430X1331__) || defined(__MSP430C1331__)
#include <msp430c1331.h>
#endif /* Genericizable */

#if defined(__MSP430_135__) || defined(__MSP430X135__) || defined(__MSP430F135__)
#include <msp430f135.h>
#endif /* Genericizable */

#if defined(__MSP430_1351__) || defined(__MSP430X1351__) || defined(__MSP430C1351__)
#include <msp430c1351.h>
#endif /* Genericizable */

#if defined(__MSP430_147__) || defined(__MSP430X147__) || defined(__MSP430F147__)
#include <msp430f147.h>
#endif /* Genericizable */

#if defined(__MSP430_1471__) || defined(__MSP430X1471__) || defined(__MSP430F1471__)
#include <msp430f1471.h>
#endif /* Genericizable */

#if defined(__MSP430_148__) || defined(__MSP430X148__) || defined(__MSP430F148__)
#include <msp430f148.h>
#endif /* Genericizable */

#if defined(__MSP430_1481__) || defined(__MSP430X1481__) || defined(__MSP430F1481__)
#include <msp430f1481.h>
#endif /* Genericizable */

#if defined(__MSP430_149__) || defined(__MSP430X149__) || defined(__MSP430F149__)
#include <msp430f149.h>
#endif /* Genericizable */

#if defined(__MSP430_1491__) || defined(__MSP430X1491__) || defined(__MSP430F1491__)
#include <msp430f1491.h>
#endif /* Genericizable */

#if defined(__MSP430_155__) || defined(__MSP430X155__) || defined(__MSP430F155__)
#include <msp430f155.h>
#endif /* Genericizable */

#if defined(__MSP430_156__) || defined(__MSP430X156__) || defined(__MSP430F156__)
#include <msp430f156.h>
#endif /* Genericizable */

#if defined(__MSP430_157__) || defined(__MSP430X157__) || defined(__MSP430F157__)
#include <msp430f157.h>
#endif /* Genericizable */

#if defined(__MSP430_1610__) || defined(__MSP430X1610__) || defined(__MSP430F1610__)
#include <msp430f1610.h>
#endif /* Genericizable */

#if defined(__MSP430_1611__) || defined(__MSP430X1611__) || defined(__MSP430F1611__)
#include <msp430f1611.h>
#endif /* Genericizable */

#if defined(__MSP430_1612__) || defined(__MSP430X1612__) || defined(__MSP430F1612__)
#include <msp430f1612.h>
#endif /* Genericizable */

#if defined(__MSP430_167__) || defined(__MSP430X167__) || defined(__MSP430F167__)
#include <msp430f167.h>
#endif /* Genericizable */

#if defined(__MSP430_168__) || defined(__MSP430X168__) || defined(__MSP430F168__)
#include <msp430f168.h>
#endif /* Genericizable */

#if defined(__MSP430_169__) || defined(__MSP430X169__) || defined(__MSP430F169__)
#include <msp430f169.h>
#endif /* Genericizable */

#if defined(__MSP430G2001__)
#include <msp430g2001.h>
#endif /* Device mismatch msp430_2001 */

#if defined(__MSP430F2001__)
#include <msp430f2001.h>
#endif /* Device mismatch msp430_2001 */

#if defined(__MSP430_2002__) || defined(__MSP430X2002__) || defined(__MSP430F2002__)
#include <msp430f2002.h>
#endif /* Genericizable */

#if defined(__MSP430_2003__) || defined(__MSP430X2003__) || defined(__MSP430F2003__)
#include <msp430f2003.h>
#endif /* Genericizable */

#if defined(__MSP430_2011__) || defined(__MSP430X2011__) || defined(__MSP430F2011__)
#include <msp430f2011.h>
#endif /* Genericizable */

#if defined(__MSP430_2012__) || defined(__MSP430X2012__) || defined(__MSP430F2012__)
#include <msp430f2012.h>
#endif /* Genericizable */

#if defined(__MSP430_2013__) || defined(__MSP430X2013__) || defined(__MSP430F2013__)
#include <msp430f2013.h>
#endif /* Genericizable */

#if defined(__MSP430G2101__)
#include <msp430g2101.h>
#endif /* Header mismatch msp430_2101 */

#if defined(__MSP430F2101__)
#include <msp430f2101.h>
#endif /* Header mismatch msp430_2101 */

#if defined(__MSP430_2102__) || defined(__MSP430X2102__) || defined(__MSP430G2102__)
#include <msp430g2102.h>
#endif /* Genericizable */

#if defined(__MSP430G2111__)
#include <msp430g2111.h>
#endif /* Device mismatch msp430_2111 */

#if defined(__MSP430F2111__)
#include <msp430f2111.h>
#endif /* Device mismatch msp430_2111 */

#if defined(__MSP430F2112__)
#include <msp430f2112.h>
#endif /* Device mismatch msp430_2112 */

#if defined(__MSP430G2112__)
#include <msp430g2112.h>
#endif /* Device mismatch msp430_2112 */

#if defined(__MSP430_2113__) || defined(__MSP430X2113__) || defined(__MSP430G2113__)
#include <msp430g2113.h>
#endif /* Genericizable */

#if defined(__MSP430F2121__)
#include <msp430f2121.h>
#endif /* Device mismatch msp430_2121 */

#if defined(__MSP430G2121__)
#include <msp430g2121.h>
#endif /* Device mismatch msp430_2121 */

#if defined(__MSP430_2122__) || defined(__MSP430X2122__) || defined(__MSP430F2122__)
#include <msp430f2122.h>
#endif /* Genericizable */

#if defined(__MSP430F2131__)
#include <msp430f2131.h>
#endif /* Device mismatch msp430_2131 */

#if defined(__MSP430G2131__)
#include <msp430g2131.h>
#endif /* Device mismatch msp430_2131 */

#if defined(__MSP430F2132__)
#include <msp430f2132.h>
#endif /* Device mismatch msp430_2132 */

#if defined(__MSP430G2132__)
#include <msp430g2132.h>
#endif /* Device mismatch msp430_2132 */

#if defined(__MSP430_2152__) || defined(__MSP430X2152__) || defined(__MSP430G2152__)
#include <msp430g2152.h>
#endif /* Genericizable */

#if defined(__MSP430_2153__) || defined(__MSP430X2153__) || defined(__MSP430G2153__)
#include <msp430g2153.h>
#endif /* Genericizable */

#if defined(__MSP430_2201__) || defined(__MSP430X2201__) || defined(__MSP430G2201__)
#include <msp430g2201.h>
#endif /* Genericizable */

#if defined(__MSP430_2202__) || defined(__MSP430X2202__) || defined(__MSP430G2202__)
#include <msp430g2202.h>
#endif /* Genericizable */

#if defined(__MSP430_2203__) || defined(__MSP430X2203__) || defined(__MSP430G2203__)
#include <msp430g2203.h>
#endif /* Genericizable */

#if defined(__MSP430_221__) || defined(__MSP430X221__) || defined(__MSP430AFE221__)
#include <msp430afe221.h>
#endif /* Genericizable */

#if defined(__MSP430_2211__) || defined(__MSP430X2211__) || defined(__MSP430G2211__)
#include <msp430g2211.h>
#endif /* Genericizable */

#if defined(__MSP430_2212__) || defined(__MSP430X2212__) || defined(__MSP430G2212__)
#include <msp430g2212.h>
#endif /* Genericizable */

#if defined(__MSP430_2213__) || defined(__MSP430X2213__) || defined(__MSP430G2213__)
#include <msp430g2213.h>
#endif /* Genericizable */

#if defined(__MSP430_222__) || defined(__MSP430X222__) || defined(__MSP430AFE222__)
#include <msp430afe222.h>
#endif /* Genericizable */

#if defined(__MSP430_2221__) || defined(__MSP430X2221__) || defined(__MSP430G2221__)
#include <msp430g2221.h>
#endif /* Genericizable */

#if defined(__MSP430_223__) || defined(__MSP430X223__) || defined(__MSP430AFE223__)
#include <msp430afe223.h>
#endif /* Genericizable */

#if defined(__MSP430_2231__) || defined(__MSP430X2231__) || defined(__MSP430G2231__)
#include <msp430g2231.h>
#endif /* Genericizable */

#if defined(__MSP430G2232__)
#include <msp430g2232.h>
#endif /* Device mismatch msp430_2232 */

#if defined(__MSP430F2232__)
#include <msp430f2232.h>
#endif /* Device mismatch msp430_2232 */

#if defined(__MSP430_2233__) || defined(__MSP430X2233__) || defined(__MSP430G2233__)
#include <msp430g2233.h>
#endif /* Genericizable */

#if defined(__MSP430_2234__) || defined(__MSP430X2234__) || defined(__MSP430F2234__)
#include <msp430f2234.h>
#endif /* Genericizable */

#if defined(__MSP430G2252__)
#include <msp430g2252.h>
#endif /* Device mismatch msp430_2252 */

#if defined(__MSP430F2252__)
#include <msp430f2252.h>
#endif /* Device mismatch msp430_2252 */

#if defined(__MSP430_2253__) || defined(__MSP430X2253__) || defined(__MSP430G2253__)
#include <msp430g2253.h>
#endif /* Genericizable */

#if defined(__MSP430_2254__) || defined(__MSP430X2254__) || defined(__MSP430F2254__)
#include <msp430f2254.h>
#endif /* Genericizable */

#if defined(__MSP430_2272__) || defined(__MSP430X2272__) || defined(__MSP430F2272__)
#include <msp430f2272.h>
#endif /* Genericizable */

#if defined(__MSP430_2274__) || defined(__MSP430X2274__) || defined(__MSP430F2274__)
#include <msp430f2274.h>
#endif /* Genericizable */

#if defined(__MSP430_2302__) || defined(__MSP430X2302__) || defined(__MSP430G2302__)
#include <msp430g2302.h>
#endif /* Genericizable */

#if defined(__MSP430_2303__) || defined(__MSP430X2303__) || defined(__MSP430G2303__)
#include <msp430g2303.h>
#endif /* Genericizable */

#if defined(__MSP430_231__) || defined(__MSP430X231__) || defined(__MSP430AFE231__)
#include <msp430afe231.h>
#endif /* Genericizable */

#if defined(__MSP430_2312__) || defined(__MSP430X2312__) || defined(__MSP430G2312__)
#include <msp430g2312.h>
#endif /* Genericizable */

#if defined(__MSP430_2313__) || defined(__MSP430X2313__) || defined(__MSP430G2313__)
#include <msp430g2313.h>
#endif /* Genericizable */

#if defined(__MSP430_232__) || defined(__MSP430X232__) || defined(__MSP430AFE232__)
#include <msp430afe232.h>
#endif /* Genericizable */

#if defined(__MSP430AFE233__)
#include <msp430afe233.h>
#endif /* Device mismatch msp430_233 */

#if defined(__MSP430F233__)
#include <msp430f233.h>
#endif /* Device mismatch msp430_233 */

#if defined(__MSP430_2330__) || defined(__MSP430X2330__) || defined(__MSP430F2330__)
#include <msp430f2330.h>
#endif /* Genericizable */

#if defined(__MSP430_2332__) || defined(__MSP430X2332__) || defined(__MSP430G2332__)
#include <msp430g2332.h>
#endif /* Genericizable */

#if defined(__MSP430_2333__) || defined(__MSP430X2333__) || defined(__MSP430G2333__)
#include <msp430g2333.h>
#endif /* Genericizable */

#if defined(__MSP430_235__) || defined(__MSP430X235__) || defined(__MSP430F235__)
#include <msp430f235.h>
#endif /* Genericizable */

#if defined(__MSP430_2350__) || defined(__MSP430X2350__) || defined(__MSP430F2350__)
#include <msp430f2350.h>
#endif /* Genericizable */

#if defined(__MSP430_2352__) || defined(__MSP430X2352__) || defined(__MSP430G2352__)
#include <msp430g2352.h>
#endif /* Genericizable */

#if defined(__MSP430_2353__) || defined(__MSP430X2353__) || defined(__MSP430G2353__)
#include <msp430g2353.h>
#endif /* Genericizable */

#if defined(__MSP430_2370__) || defined(__MSP430X2370__) || defined(__MSP430F2370__)
#include <msp430f2370.h>
#endif /* Genericizable */

#if defined(__MSP430_2402__) || defined(__MSP430X2402__) || defined(__MSP430G2402__)
#include <msp430g2402.h>
#endif /* Genericizable */

#if defined(__MSP430_2403__) || defined(__MSP430X2403__) || defined(__MSP430G2403__)
#include <msp430g2403.h>
#endif /* Genericizable */

#if defined(__MSP430_2410__) || defined(__MSP430X2410__) || defined(__MSP430F2410__)
#include <msp430f2410.h>
#endif /* Genericizable */

#if defined(__MSP430_2412__) || defined(__MSP430X2412__) || defined(__MSP430G2412__)
#include <msp430g2412.h>
#endif /* Genericizable */

#if defined(__MSP430_2413__) || defined(__MSP430X2413__) || defined(__MSP430G2413__)
#include <msp430g2413.h>
#endif /* Genericizable */

#if defined(__MSP430_2416__) || defined(__MSP430X2416__) || defined(__MSP430F2416__)
#include <msp430f2416.h>
#endif /* Genericizable */

#if defined(__MSP430_2417__) || defined(__MSP430X2417__) || defined(__MSP430F2417__)
#include <msp430f2417.h>
#endif /* Genericizable */

#if defined(__MSP430_2418__) || defined(__MSP430X2418__) || defined(__MSP430F2418__)
#include <msp430f2418.h>
#endif /* Genericizable */

#if defined(__MSP430_2419__) || defined(__MSP430X2419__) || defined(__MSP430F2419__)
#include <msp430f2419.h>
#endif /* Genericizable */

#if defined(__MSP430_2432__) || defined(__MSP430X2432__) || defined(__MSP430G2432__)
#include <msp430g2432.h>
#endif /* Genericizable */

#if defined(__MSP430_2433__) || defined(__MSP430X2433__) || defined(__MSP430G2433__)
#include <msp430g2433.h>
#endif /* Genericizable */

#if defined(__MSP430_2452__) || defined(__MSP430X2452__) || defined(__MSP430G2452__)
#include <msp430g2452.h>
#endif /* Genericizable */

#if defined(__MSP430_2453__) || defined(__MSP430X2453__) || defined(__MSP430G2453__)
#include <msp430g2453.h>
#endif /* Genericizable */

#if defined(__MSP430_247__) || defined(__MSP430X247__) || defined(__MSP430F247__)
#include <msp430f247.h>
#endif /* Genericizable */

#if defined(__MSP430_2471__) || defined(__MSP430X2471__) || defined(__MSP430F2471__)
#include <msp430f2471.h>
#endif /* Genericizable */

#if defined(__MSP430_248__) || defined(__MSP430X248__) || defined(__MSP430F248__)
#include <msp430f248.h>
#endif /* Genericizable */

#if defined(__MSP430_2481__) || defined(__MSP430X2481__) || defined(__MSP430F2481__)
#include <msp430f2481.h>
#endif /* Genericizable */

#if defined(__MSP430_249__) || defined(__MSP430X249__) || defined(__MSP430F249__)
#include <msp430f249.h>
#endif /* Genericizable */

#if defined(__MSP430_2491__) || defined(__MSP430X2491__) || defined(__MSP430F2491__)
#include <msp430f2491.h>
#endif /* Genericizable */

#if defined(__MSP430_251__) || defined(__MSP430X251__) || defined(__MSP430AFE251__)
#include <msp430afe251.h>
#endif /* Genericizable */

#if defined(__MSP430_2513__) || defined(__MSP430X2513__) || defined(__MSP430G2513__)
#include <msp430g2513.h>
#endif /* Genericizable */

#if defined(__MSP430_252__) || defined(__MSP430X252__) || defined(__MSP430AFE252__)
#include <msp430afe252.h>
#endif /* Genericizable */

#if defined(__MSP430_253__) || defined(__MSP430X253__) || defined(__MSP430AFE253__)
#include <msp430afe253.h>
#endif /* Genericizable */

#if defined(__MSP430_2533__) || defined(__MSP430X2533__) || defined(__MSP430G2533__)
#include <msp430g2533.h>
#endif /* Genericizable */

#if defined(__MSP430_2553__) || defined(__MSP430X2553__) || defined(__MSP430G2553__)
#include <msp430g2553.h>
#endif /* Genericizable */

#if defined(__MSP430_2616__) || defined(__MSP430X2616__) || defined(__MSP430F2616__)
#include <msp430f2616.h>
#endif /* Genericizable */

#if defined(__MSP430_2617__) || defined(__MSP430X2617__) || defined(__MSP430F2617__)
#include <msp430f2617.h>
#endif /* Genericizable */

#if defined(__MSP430_2618__) || defined(__MSP430X2618__) || defined(__MSP430F2618__)
#include <msp430f2618.h>
#endif /* Genericizable */

#if defined(__MSP430_2619__) || defined(__MSP430X2619__) || defined(__MSP430F2619__)
#include <msp430f2619.h>
#endif /* Genericizable */

#if defined(__MSP430_311__) || defined(__MSP430X311__) || defined(__MSP430C311S__)
#include <msp430c311s.h>
#endif /* Genericizable */

#if defined(__MSP430_312__) || defined(__MSP430X312__) || defined(__MSP430C312__)
#include <msp430c312.h>
#endif /* Genericizable */

#if defined(__MSP430C313__)
#include <msp430c313.h>
#endif /* Multi-device msp430_313 */

#if defined(__MSP430P313__)
#include <msp430p313.h>
#endif /* Multi-device msp430_313 */

#if defined(__MSP430E313__)
#include <msp430e313.h>
#endif /* Multi-device msp430_313 */

#if defined(__MSP430_314__) || defined(__MSP430X314__) || defined(__MSP430C314__)
#include <msp430c314.h>
#endif /* Genericizable */

#if defined(__MSP430P315S__)
#include <msp430p315s.h>
#endif /* Multi-device msp430_315 */

#if defined(__MSP430E315__)
#include <msp430e315.h>
#endif /* Multi-device msp430_315 */

#if defined(__MSP430P315__)
#include <msp430p315.h>
#endif /* Multi-device msp430_315 */

#if defined(__MSP430C315__)
#include <msp430c315.h>
#endif /* Multi-device msp430_315 */

#if defined(__MSP430_323__) || defined(__MSP430X323__) || defined(__MSP430C323__)
#include <msp430c323.h>
#endif /* Genericizable */

#if defined(__MSP430P325__)
#include <msp430p325.h>
#endif /* Multi-device msp430_325 */

#if defined(__MSP430E325__)
#include <msp430e325.h>
#endif /* Multi-device msp430_325 */

#if defined(__MSP430C325__)
#include <msp430c325.h>
#endif /* Multi-device msp430_325 */

#if defined(__MSP430_336__) || defined(__MSP430X336__) || defined(__MSP430C336__)
#include <msp430c336.h>
#endif /* Genericizable */

#if defined(__MSP430P337__)
#include <msp430p337.h>
#endif /* Multi-device msp430_337 */

#if defined(__MSP430C337__)
#include <msp430c337.h>
#endif /* Multi-device msp430_337 */

#if defined(__MSP430E337__)
#include <msp430e337.h>
#endif /* Multi-device msp430_337 */

#if defined(__MSP430F412__)
#include <msp430f412.h>
#endif /* Device mismatch msp430_412 */

#if defined(__MSP430C412__)
#include <msp430c412.h>
#endif /* Device mismatch msp430_412 */

#if defined(__MSP430F413__)
#include <msp430f413.h>
#endif /* Device mismatch msp430_413 */

#if defined(__MSP430C413__)
#include <msp430c413.h>
#endif /* Device mismatch msp430_413 */

#if defined(__MSP430_4132__) || defined(__MSP430X4132__) || defined(__MSP430F4132__)
#include <msp430f4132.h>
#endif /* Genericizable */

#if defined(__MSP430_415__) || defined(__MSP430X415__) || defined(__MSP430F415__)
#include <msp430f415.h>
#endif /* Genericizable */

#if defined(__MSP430_4152__) || defined(__MSP430X4152__) || defined(__MSP430F4152__)
#include <msp430f4152.h>
#endif /* Genericizable */

#if defined(__MSP430_417__) || defined(__MSP430X417__) || defined(__MSP430F417__)
#include <msp430f417.h>
#endif /* Genericizable */

#if defined(__MSP430F423__)
#include <msp430f423.h>
#endif /* Device mismatch msp430_423 */

#if defined(__MSP430FE423__)
#include <msp430fe423.h>
#endif /* Device mismatch msp430_423 */

#if defined(__MSP430FW423__)
#include <msp430fw423.h>
#endif /* Device mismatch msp430_423 */

#if defined(__MSP430F423A__)
#include <msp430f423a.h>
#endif /* Device mismatch msp430_423 */

#if defined(__MSP430FE423A__)
#include <msp430fe423a.h>
#endif /* Device mismatch msp430_423 */

#if defined(__MSP430_4232__) || defined(__MSP430X4232__) || defined(__MSP430FE4232__)
#include <msp430fe4232.h>
#endif /* Genericizable */

#if defined(__MSP430_4242__) || defined(__MSP430X4242__) || defined(__MSP430FE4242__)
#include <msp430fe4242.h>
#endif /* Genericizable */

#if defined(__MSP430FE425__)
#include <msp430fe425.h>
#endif /* Device mismatch msp430_425 */

#if defined(__MSP430FE425A__)
#include <msp430fe425a.h>
#endif /* Device mismatch msp430_425 */

#if defined(__MSP430FW425__)
#include <msp430fw425.h>
#endif /* Device mismatch msp430_425 */

#if defined(__MSP430F425A__)
#include <msp430f425a.h>
#endif /* Device mismatch msp430_425 */

#if defined(__MSP430F425__)
#include <msp430f425.h>
#endif /* Device mismatch msp430_425 */

#if defined(__MSP430FG4250__)
#include <msp430fg4250.h>
#endif /* Header mismatch msp430_4250 */

#if defined(__MSP430F4250__)
#include <msp430f4250.h>
#endif /* Header mismatch msp430_4250 */

#if defined(__MSP430_4252__) || defined(__MSP430X4252__) || defined(__MSP430FE4252__)
#include <msp430fe4252.h>
#endif /* Genericizable */

#if defined(__MSP430FG4260__)
#include <msp430fg4260.h>
#endif /* Header mismatch msp430_4260 */

#if defined(__MSP430F4260__)
#include <msp430f4260.h>
#endif /* Header mismatch msp430_4260 */

#if defined(__MSP430F427A__)
#include <msp430f427a.h>
#endif /* Device mismatch msp430_427 */

#if defined(__MSP430FE427__)
#include <msp430fe427.h>
#endif /* Device mismatch msp430_427 */

#if defined(__MSP430F427__)
#include <msp430f427.h>
#endif /* Device mismatch msp430_427 */

#if defined(__MSP430FW427__)
#include <msp430fw427.h>
#endif /* Device mismatch msp430_427 */

#if defined(__MSP430FE427A__)
#include <msp430fe427a.h>
#endif /* Device mismatch msp430_427 */

#if defined(__MSP430F4270__)
#include <msp430f4270.h>
#endif /* Header mismatch msp430_4270 */

#if defined(__MSP430FG4270__)
#include <msp430fg4270.h>
#endif /* Header mismatch msp430_4270 */

#if defined(__MSP430_4272__) || defined(__MSP430X4272__) || defined(__MSP430FE4272__)
#include <msp430fe4272.h>
#endif /* Genericizable */

#if defined(__MSP430_428__) || defined(__MSP430X428__) || defined(__MSP430FW428__)
#include <msp430fw428.h>
#endif /* Genericizable */

#if defined(__MSP430_429__) || defined(__MSP430X429__) || defined(__MSP430FW429__)
#include <msp430fw429.h>
#endif /* Genericizable */

#if defined(__MSP430_435__) || defined(__MSP430X435__) || defined(__MSP430F435__)
#include <msp430f435.h>
#endif /* Genericizable */

#if defined(__MSP430_4351__) || defined(__MSP430X4351__) || defined(__MSP430F4351__)
#include <msp430f4351.h>
#endif /* Genericizable */

#if defined(__MSP430_436__) || defined(__MSP430X436__) || defined(__MSP430F436__)
#include <msp430f436.h>
#endif /* Genericizable */

#if defined(__MSP430_4361__) || defined(__MSP430X4361__) || defined(__MSP430F4361__)
#include <msp430f4361.h>
#endif /* Genericizable */

#if defined(__MSP430FG437__)
#include <msp430fg437.h>
#endif /* Header mismatch msp430_437 */

#if defined(__MSP430F437__)
#include <msp430f437.h>
#endif /* Header mismatch msp430_437 */

#if defined(__MSP430_4371__) || defined(__MSP430X4371__) || defined(__MSP430F4371__)
#include <msp430f4371.h>
#endif /* Genericizable */

#if defined(__MSP430F438__)
#include <msp430f438.h>
#endif /* Header mismatch msp430_438 */

#if defined(__MSP430FG438__)
#include <msp430fg438.h>
#endif /* Header mismatch msp430_438 */

#if defined(__MSP430F439__)
#include <msp430f439.h>
#endif /* Header mismatch msp430_439 */

#if defined(__MSP430FG439__)
#include <msp430fg439.h>
#endif /* Header mismatch msp430_439 */

#if defined(__MSP430_447__) || defined(__MSP430X447__) || defined(__MSP430F447__)
#include <msp430f447.h>
#endif /* Genericizable */

#if defined(__MSP430_448__) || defined(__MSP430X448__) || defined(__MSP430F448__)
#include <msp430f448.h>
#endif /* Genericizable */

#if defined(__MSP430_4481__) || defined(__MSP430X4481__) || defined(__MSP430F4481__)
#include <msp430f4481.h>
#endif /* Genericizable */

#if defined(__MSP430_449__) || defined(__MSP430X449__) || defined(__MSP430F449__)
#include <msp430f449.h>
#endif /* Genericizable */

#if defined(__MSP430_4491__) || defined(__MSP430X4491__) || defined(__MSP430F4491__)
#include <msp430f4491.h>
#endif /* Genericizable */

#if defined(__MSP430CG4616__)
#include <msp430cg4616.h>
#endif /* Header mismatch msp430_4616 */

#if defined(__MSP430F4616__)
#include <msp430f4616.h>
#endif /* Header mismatch msp430_4616 */

#if defined(__MSP430FG4616__)
#include <msp430fg4616.h>
#endif /* Header mismatch msp430_4616 */

#if defined(__MSP430_46161__) || defined(__MSP430X46161__) || defined(__MSP430F46161__)
#include <msp430f46161.h>
#endif /* Genericizable */

#if defined(__MSP430F4617__)
#include <msp430f4617.h>
#endif /* Header mismatch msp430_4617 */

#if defined(__MSP430CG4617__)
#include <msp430cg4617.h>
#endif /* Header mismatch msp430_4617 */

#if defined(__MSP430FG4617__)
#include <msp430fg4617.h>
#endif /* Header mismatch msp430_4617 */

#if defined(__MSP430_46171__) || defined(__MSP430X46171__) || defined(__MSP430F46171__)
#include <msp430f46171.h>
#endif /* Genericizable */

#if defined(__MSP430FG4618__)
#include <msp430fg4618.h>
#endif /* Header mismatch msp430_4618 */

#if defined(__MSP430CG4618__)
#include <msp430cg4618.h>
#endif /* Header mismatch msp430_4618 */

#if defined(__MSP430F4618__)
#include <msp430f4618.h>
#endif /* Header mismatch msp430_4618 */

#if defined(__MSP430_46181__) || defined(__MSP430X46181__) || defined(__MSP430F46181__)
#include <msp430f46181.h>
#endif /* Genericizable */

#if defined(__MSP430FG4619__)
#include <msp430fg4619.h>
#endif /* Header mismatch msp430_4619 */

#if defined(__MSP430F4619__)
#include <msp430f4619.h>
#endif /* Header mismatch msp430_4619 */

#if defined(__MSP430CG4619__)
#include <msp430cg4619.h>
#endif /* Header mismatch msp430_4619 */

#if defined(__MSP430_46191__) || defined(__MSP430X46191__) || defined(__MSP430F46191__)
#include <msp430f46191.h>
#endif /* Genericizable */

#if defined(__MSP430_47126__) || defined(__MSP430X47126__) || defined(__MSP430F47126__)
#include <msp430f47126.h>
#endif /* Genericizable */

#if defined(__MSP430_47127__) || defined(__MSP430X47127__) || defined(__MSP430F47127__)
#include <msp430f47127.h>
#endif /* Genericizable */

#if defined(__MSP430_47163__) || defined(__MSP430X47163__) || defined(__MSP430F47163__)
#include <msp430f47163.h>
#endif /* Genericizable */

#if defined(__MSP430_47166__) || defined(__MSP430X47166__) || defined(__MSP430F47166__)
#include <msp430f47166.h>
#endif /* Genericizable */

#if defined(__MSP430_47167__) || defined(__MSP430X47167__) || defined(__MSP430F47167__)
#include <msp430f47167.h>
#endif /* Genericizable */

#if defined(__MSP430_47173__) || defined(__MSP430X47173__) || defined(__MSP430F47173__)
#include <msp430f47173.h>
#endif /* Genericizable */

#if defined(__MSP430_47176__) || defined(__MSP430X47176__) || defined(__MSP430F47176__)
#include <msp430f47176.h>
#endif /* Genericizable */

#if defined(__MSP430_47177__) || defined(__MSP430X47177__) || defined(__MSP430F47177__)
#include <msp430f47177.h>
#endif /* Genericizable */

#if defined(__MSP430_47183__) || defined(__MSP430X47183__) || defined(__MSP430F47183__)
#include <msp430f47183.h>
#endif /* Genericizable */

#if defined(__MSP430_47186__) || defined(__MSP430X47186__) || defined(__MSP430F47186__)
#include <msp430f47186.h>
#endif /* Genericizable */

#if defined(__MSP430_47187__) || defined(__MSP430X47187__) || defined(__MSP430F47187__)
#include <msp430f47187.h>
#endif /* Genericizable */

#if defined(__MSP430_47193__) || defined(__MSP430X47193__) || defined(__MSP430F47193__)
#include <msp430f47193.h>
#endif /* Genericizable */

#if defined(__MSP430_47196__) || defined(__MSP430X47196__) || defined(__MSP430F47196__)
#include <msp430f47196.h>
#endif /* Genericizable */

#if defined(__MSP430_47197__) || defined(__MSP430X47197__) || defined(__MSP430F47197__)
#include <msp430f47197.h>
#endif /* Genericizable */

#if defined(__MSP430FG477__)
#include <msp430fg477.h>
#endif /* Header mismatch msp430_477 */

#if defined(__MSP430F477__)
#include <msp430f477.h>
#endif /* Header mismatch msp430_477 */

#if defined(__MSP430F478__)
#include <msp430f478.h>
#endif /* Header mismatch msp430_478 */

#if defined(__MSP430FG478__)
#include <msp430fg478.h>
#endif /* Header mismatch msp430_478 */

#if defined(__MSP430_4783__) || defined(__MSP430X4783__) || defined(__MSP430F4783__)
#include <msp430f4783.h>
#endif /* Genericizable */

#if defined(__MSP430_4784__) || defined(__MSP430X4784__) || defined(__MSP430F4784__)
#include <msp430f4784.h>
#endif /* Genericizable */

#if defined(__MSP430F479__)
#include <msp430f479.h>
#endif /* Header mismatch msp430_479 */

#if defined(__MSP430FG479__)
#include <msp430fg479.h>
#endif /* Header mismatch msp430_479 */

#if defined(__MSP430_4793__) || defined(__MSP430X4793__) || defined(__MSP430F4793__)
#include <msp430f4793.h>
#endif /* Genericizable */

#if defined(__MSP430_4794__) || defined(__MSP430X4794__) || defined(__MSP430F4794__)
#include <msp430f4794.h>
#endif /* Genericizable */

#if defined(__MSP430_5131__) || defined(__MSP430X5131__) || defined(__MSP430F5131__)
#include <msp430f5131.h>
#endif /* Genericizable */

#if defined(__MSP430_5132__) || defined(__MSP430X5132__) || defined(__MSP430F5132__)
#include <msp430f5132.h>
#endif /* Genericizable */

#if defined(__MSP430_5151__) || defined(__MSP430X5151__) || defined(__MSP430F5151__)
#include <msp430f5151.h>
#endif /* Genericizable */

#if defined(__MSP430_5152__) || defined(__MSP430X5152__) || defined(__MSP430F5152__)
#include <msp430f5152.h>
#endif /* Genericizable */

#if defined(__MSP430_5171__) || defined(__MSP430X5171__) || defined(__MSP430F5171__)
#include <msp430f5171.h>
#endif /* Genericizable */

#if defined(__MSP430_5172__) || defined(__MSP430X5172__) || defined(__MSP430F5172__)
#include <msp430f5172.h>
#endif /* Genericizable */

#if defined(__MSP430_5190__) || defined(__MSP430X5190__) || defined(__MSP430BT5190__)
#include <msp430bt5190.h>
#endif /* Genericizable */

#if defined(__MSP430_5304__) || defined(__MSP430X5304__) || defined(__MSP430F5304__)
#include <msp430f5304.h>
#endif /* Genericizable */

#if defined(__MSP430_5308__) || defined(__MSP430X5308__) || defined(__MSP430F5308__)
#include <msp430f5308.h>
#endif /* Genericizable */

#if defined(__MSP430_5309__) || defined(__MSP430X5309__) || defined(__MSP430F5309__)
#include <msp430f5309.h>
#endif /* Genericizable */

#if defined(__MSP430_5310__) || defined(__MSP430X5310__) || defined(__MSP430F5310__)
#include <msp430f5310.h>
#endif /* Genericizable */

#if defined(__MSP430_5324__) || defined(__MSP430X5324__) || defined(__MSP430F5324__)
#include <msp430f5324.h>
#endif /* Genericizable */

#if defined(__MSP430_5325__) || defined(__MSP430X5325__) || defined(__MSP430F5325__)
#include <msp430f5325.h>
#endif /* Genericizable */

#if defined(__MSP430_5326__) || defined(__MSP430X5326__) || defined(__MSP430F5326__)
#include <msp430f5326.h>
#endif /* Genericizable */

#if defined(__MSP430_5327__) || defined(__MSP430X5327__) || defined(__MSP430F5327__)
#include <msp430f5327.h>
#endif /* Genericizable */

#if defined(__MSP430_5328__) || defined(__MSP430X5328__) || defined(__MSP430F5328__)
#include <msp430f5328.h>
#endif /* Genericizable */

#if defined(__MSP430_5329__) || defined(__MSP430X5329__) || defined(__MSP430F5329__)
#include <msp430f5329.h>
#endif /* Genericizable */

#if defined(__MSP430_5340__) || defined(__MSP430X5340__) || defined(__MSP430F5340__)
#include <msp430f5340.h>
#endif /* Genericizable */

#if defined(__MSP430_5341__) || defined(__MSP430X5341__) || defined(__MSP430F5341__)
#include <msp430f5341.h>
#endif /* Genericizable */

#if defined(__MSP430_5342__) || defined(__MSP430X5342__) || defined(__MSP430F5342__)
#include <msp430f5342.h>
#endif /* Genericizable */

#if defined(__MSP430F5418A__)
#include <msp430f5418a.h>
#endif /* Device mismatch msp430_5418 */

#if defined(__MSP430F5418__)
#include <msp430f5418.h>
#endif /* Device mismatch msp430_5418 */

#if defined(__MSP430F5419A__)
#include <msp430f5419a.h>
#endif /* Device mismatch msp430_5419 */

#if defined(__MSP430F5419__)
#include <msp430f5419.h>
#endif /* Device mismatch msp430_5419 */

#if defined(__MSP430F5435__)
#include <msp430f5435.h>
#endif /* Device mismatch msp430_5435 */

#if defined(__MSP430F5435A__)
#include <msp430f5435a.h>
#endif /* Device mismatch msp430_5435 */

#if defined(__MSP430F5436__)
#include <msp430f5436.h>
#endif /* Device mismatch msp430_5436 */

#if defined(__MSP430F5436A__)
#include <msp430f5436a.h>
#endif /* Device mismatch msp430_5436 */

#if defined(__MSP430F5437__)
#include <msp430f5437.h>
#endif /* Device mismatch msp430_5437 */

#if defined(__MSP430F5437A__)
#include <msp430f5437a.h>
#endif /* Device mismatch msp430_5437 */

#if defined(__MSP430F5438A__)
#include <msp430f5438a.h>
#endif /* Device mismatch msp430_5438 */

#if defined(__MSP430F5438__)
#include <msp430f5438.h>
#endif /* Device mismatch msp430_5438 */

#if defined(__MSP430_5500__) || defined(__MSP430X5500__) || defined(__MSP430F5500__)
#include <msp430f5500.h>
#endif /* Genericizable */

#if defined(__MSP430_5501__) || defined(__MSP430X5501__) || defined(__MSP430F5501__)
#include <msp430f5501.h>
#endif /* Genericizable */

#if defined(__MSP430_5502__) || defined(__MSP430X5502__) || defined(__MSP430F5502__)
#include <msp430f5502.h>
#endif /* Genericizable */

#if defined(__MSP430_5503__) || defined(__MSP430X5503__) || defined(__MSP430F5503__)
#include <msp430f5503.h>
#endif /* Genericizable */

#if defined(__MSP430_5504__) || defined(__MSP430X5504__) || defined(__MSP430F5504__)
#include <msp430f5504.h>
#endif /* Genericizable */

#if defined(__MSP430_5505__) || defined(__MSP430X5505__) || defined(__MSP430F5505__)
#include <msp430f5505.h>
#endif /* Genericizable */

#if defined(__MSP430_5506__) || defined(__MSP430X5506__) || defined(__MSP430F5506__)
#include <msp430f5506.h>
#endif /* Genericizable */

#if defined(__MSP430_5507__) || defined(__MSP430X5507__) || defined(__MSP430F5507__)
#include <msp430f5507.h>
#endif /* Genericizable */

#if defined(__MSP430_5508__) || defined(__MSP430X5508__) || defined(__MSP430F5508__)
#include <msp430f5508.h>
#endif /* Genericizable */

#if defined(__MSP430_5509__) || defined(__MSP430X5509__) || defined(__MSP430F5509__)
#include <msp430f5509.h>
#endif /* Genericizable */

#if defined(__MSP430_5510__) || defined(__MSP430X5510__) || defined(__MSP430F5510__)
#include <msp430f5510.h>
#endif /* Genericizable */

#if defined(__MSP430_5513__) || defined(__MSP430X5513__) || defined(__MSP430F5513__)
#include <msp430f5513.h>
#endif /* Genericizable */

#if defined(__MSP430_5514__) || defined(__MSP430X5514__) || defined(__MSP430F5514__)
#include <msp430f5514.h>
#endif /* Genericizable */

#if defined(__MSP430_5515__) || defined(__MSP430X5515__) || defined(__MSP430F5515__)
#include <msp430f5515.h>
#endif /* Genericizable */

#if defined(__MSP430_5517__) || defined(__MSP430X5517__) || defined(__MSP430F5517__)
#include <msp430f5517.h>
#endif /* Genericizable */

#if defined(__MSP430_5519__) || defined(__MSP430X5519__) || defined(__MSP430F5519__)
#include <msp430f5519.h>
#endif /* Genericizable */

#if defined(__MSP430_5521__) || defined(__MSP430X5521__) || defined(__MSP430F5521__)
#include <msp430f5521.h>
#endif /* Genericizable */

#if defined(__MSP430_5522__) || defined(__MSP430X5522__) || defined(__MSP430F5522__)
#include <msp430f5522.h>
#endif /* Genericizable */

#if defined(__MSP430_5524__) || defined(__MSP430X5524__) || defined(__MSP430F5524__)
#include <msp430f5524.h>
#endif /* Genericizable */

#if defined(__MSP430_5525__) || defined(__MSP430X5525__) || defined(__MSP430F5525__)
#include <msp430f5525.h>
#endif /* Genericizable */

#if defined(__MSP430_5526__) || defined(__MSP430X5526__) || defined(__MSP430F5526__)
#include <msp430f5526.h>
#endif /* Genericizable */

#if defined(__MSP430_5527__) || defined(__MSP430X5527__) || defined(__MSP430F5527__)
#include <msp430f5527.h>
#endif /* Genericizable */

#if defined(__MSP430_5528__) || defined(__MSP430X5528__) || defined(__MSP430F5528__)
#include <msp430f5528.h>
#endif /* Genericizable */

#if defined(__MSP430_5529__) || defined(__MSP430X5529__) || defined(__MSP430F5529__)
#include <msp430f5529.h>
#endif /* Genericizable */

#if defined(__MSP430_5630__) || defined(__MSP430X5630__) || defined(__MSP430F5630__)
#include <msp430f5630.h>
#endif /* Genericizable */

#if defined(__MSP430_5631__) || defined(__MSP430X5631__) || defined(__MSP430F5631__)
#include <msp430f5631.h>
#endif /* Genericizable */

#if defined(__MSP430_5632__) || defined(__MSP430X5632__) || defined(__MSP430F5632__)
#include <msp430f5632.h>
#endif /* Genericizable */

#if defined(__MSP430_5633__) || defined(__MSP430X5633__) || defined(__MSP430F5633__)
#include <msp430f5633.h>
#endif /* Genericizable */

#if defined(__MSP430_5634__) || defined(__MSP430X5634__) || defined(__MSP430F5634__)
#include <msp430f5634.h>
#endif /* Genericizable */

#if defined(__MSP430_5635__) || defined(__MSP430X5635__) || defined(__MSP430F5635__)
#include <msp430f5635.h>
#endif /* Genericizable */

#if defined(__MSP430_5636__) || defined(__MSP430X5636__) || defined(__MSP430F5636__)
#include <msp430f5636.h>
#endif /* Genericizable */

#if defined(__MSP430_5637__) || defined(__MSP430X5637__) || defined(__MSP430F5637__)
#include <msp430f5637.h>
#endif /* Genericizable */

#if defined(__MSP430_5638__) || defined(__MSP430X5638__) || defined(__MSP430F5638__)
#include <msp430f5638.h>
#endif /* Genericizable */

#if defined(__MSP430_5720__) || defined(__MSP430X5720__) || defined(__MSP430FR5720__)
#include <msp430fr5720.h>
#endif /* Genericizable */

#if defined(__MSP430_5725__) || defined(__MSP430X5725__) || defined(__MSP430FR5725__)
#include <msp430fr5725.h>
#endif /* Genericizable */

#if defined(__MSP430_5728__) || defined(__MSP430X5728__) || defined(__MSP430FR5728__)
#include <msp430fr5728.h>
#endif /* Genericizable */

#if defined(__MSP430_5729__) || defined(__MSP430X5729__) || defined(__MSP430FR5729__)
#include <msp430fr5729.h>
#endif /* Genericizable */

#if defined(__MSP430_5730__) || defined(__MSP430X5730__) || defined(__MSP430FR5730__)
#include <msp430fr5730.h>
#endif /* Genericizable */

#if defined(__MSP430_5735__) || defined(__MSP430X5735__) || defined(__MSP430FR5735__)
#include <msp430fr5735.h>
#endif /* Genericizable */

#if defined(__MSP430_5738__) || defined(__MSP430X5738__) || defined(__MSP430FR5738__)
#include <msp430fr5738.h>
#endif /* Genericizable */

#if defined(__MSP430_5739__) || defined(__MSP430X5739__) || defined(__MSP430FR5739__)
#include <msp430fr5739.h>
#endif /* Genericizable */

#if defined(__MSP430_6630__) || defined(__MSP430X6630__) || defined(__MSP430F6630__)
#include <msp430f6630.h>
#endif /* Genericizable */

#if defined(__MSP430_6631__) || defined(__MSP430X6631__) || defined(__MSP430F6631__)
#include <msp430f6631.h>
#endif /* Genericizable */

#if defined(__MSP430_6632__) || defined(__MSP430X6632__) || defined(__MSP430F6632__)
#include <msp430f6632.h>
#endif /* Genericizable */

#if defined(__MSP430_6633__) || defined(__MSP430X6633__) || defined(__MSP430F6633__)
#include <msp430f6633.h>
#endif /* Genericizable */

#if defined(__MSP430_6634__) || defined(__MSP430X6634__) || defined(__MSP430F6634__)
#include <msp430f6634.h>
#endif /* Genericizable */

#if defined(__MSP430_6635__) || defined(__MSP430X6635__) || defined(__MSP430F6635__)
#include <msp430f6635.h>
#endif /* Genericizable */

#if defined(__MSP430_6636__) || defined(__MSP430X6636__) || defined(__MSP430F6636__)
#include <msp430f6636.h>
#endif /* Genericizable */

#if defined(__MSP430_6637__) || defined(__MSP430X6637__) || defined(__MSP430F6637__)
#include <msp430f6637.h>
#endif /* Genericizable */

#if defined(__MSP430_6638__) || defined(__MSP430X6638__) || defined(__MSP430F6638__)
#include <msp430f6638.h>
#endif /* Genericizable */

#endif /* __msp430_h_ */
