#ifndef SEMANTIC_ACTIONS_H
#define SEMANTIC_ACTIONS_H

#include <sys/cdefs.h>
#include "parser_types.h"

__BEGIN_DECLS

extern struct rc_setting* parsed_rc_setting;

void emit(struct rc_setting* rc);

struct rc_setting* append_rc(struct rc_setting* prev, struct rc_setting* cur);
struct rc_setting* create_base_delay(int delay);
struct rc_setting* create_inter_delay(int delay);
struct rc_setting* create_inter_delay_list(int delay, struct str_list* str);
struct rc_setting* create_ignore(struct str_list* str);
struct rc_setting* create_max_delay(int delay);
struct rc_setting* create_poll_period(int period);
struct rc_setting* create_sync(struct str_list* str);
struct rc_setting* create_mailbox_prefix(char* prefix, char* sep);
struct rc_setting* create_store(struct rc_store_setting* store_setting);

struct rc_store_setting* append_rc_store(struct rc_store_setting* prev, struct rc_store_setting* cur);
struct rc_store_setting* create_store_name(char* str);
struct rc_store_setting* create_store_watch(struct str_list* str);

struct str_list* append_str(struct str_list* prev, struct str_list* cur);
struct str_list* create_str(char* str);

__END_DECLS

#endif // SEMANTIC_ACTIONS_H
