SET(CPACK_PACKAGE_VERSION_MAJOR "${Mummy_VERSION_MAJOR}")
SET(CPACK_PACKAGE_VERSION_MINOR "${Mummy_VERSION_MINOR}")
SET(CPACK_PACKAGE_VERSION_PATCH "${Mummy_VERSION_PATCH}")
SET(CPACK_PACKAGE_INSTALL_DIRECTORY "mummy ${Mummy_VERSION_MAJOR}.${Mummy_VERSION_MINOR}.${Mummy_VERSION_PATCH}")
SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "${CPACK_PACKAGE_INSTALL_DIRECTORY} - the incredible C# wrapper generator")
SET(CPACK_PACKAGE_VENDOR "Kitware")
SET(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/MummyLicense.txt")
SET(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/MummyLicense.txt")

SET(CPACK_SOURCE_PACKAGE_FILE_NAME
  "mummy-${Mummy_VERSION_MAJOR}.${Mummy_VERSION_MINOR}.${Mummy_VERSION_PATCH}.${Mummy_VERSION_SVN_REVISION}")

IF(NOT DEFINED CPACK_SYSTEM_NAME)
  SET(CPACK_SYSTEM_NAME ${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_PROCESSOR})
ENDIF(NOT DEFINED CPACK_SYSTEM_NAME)
IF(${CPACK_SYSTEM_NAME} MATCHES Windows)
  IF(CMAKE_CL_64)
    SET(CPACK_SYSTEM_NAME win64-${CMAKE_SYSTEM_PROCESSOR})
  ELSE(CMAKE_CL_64)
    SET(CPACK_SYSTEM_NAME win32-${CMAKE_SYSTEM_PROCESSOR})
  ENDIF(CMAKE_CL_64)
ENDIF(${CPACK_SYSTEM_NAME} MATCHES Windows)

IF(NOT DEFINED CPACK_PACKAGE_FILE_NAME)
  SET(CPACK_PACKAGE_FILE_NAME "${CPACK_SOURCE_PACKAGE_FILE_NAME}-${CPACK_SYSTEM_NAME}")
ENDIF(NOT DEFINED CPACK_PACKAGE_FILE_NAME)

IF(WIN32)
  # NSI does not handle unix paths properly. Use Windows style path separator:
#  SET(icon_file "${Mummy_SOURCE_DIR}/TODO-create-a-cool-icon.bmp")
#  STRING(REGEX REPLACE "/" "\\\\" icon_file "${icon_file}")
#  SET(CPACK_PACKAGE_ICON "${icon_file}")

  SET(CPACK_NSIS_DISPLAY_NAME "${CPACK_PACKAGE_DESCRIPTION_SUMMARY}")
  SET(CPACK_NSIS_HELP_LINK "http://www.kitware.com")
  SET(CPACK_NSIS_URL_INFO_ABOUT "http://www.kitware.com")
  SET(CPACK_NSIS_CONTACT "kitware@kitware.com")

  SET(CPACK_GENERATOR "NSIS")
  SET(CPACK_SOURCE_GENERATOR "${CPACK_GENERATOR}")
ENDIF(WIN32)


INCLUDE(CPack)
