/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *	$Id: murasaki_usb.h,v 1.4 2004/02/06 00:23:48 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_USB_H
#define	_MURASAKI_USB_H

/* from linux/usb.h */
#define USB_DEVICE_ID_MATCH_VENDOR      0x0001
#define USB_DEVICE_ID_MATCH_PRODUCT     0x0002
#define USB_DEVICE_ID_MATCH_DEV_LO      0x0004
#define USB_DEVICE_ID_MATCH_DEV_HI      0x0008
#define USB_DEVICE_ID_MATCH_DEV_CLASS       0x0010
#define USB_DEVICE_ID_MATCH_DEV_SUBCLASS    0x0020
#define USB_DEVICE_ID_MATCH_DEV_PROTOCOL    0x0040
#define USB_DEVICE_ID_MATCH_INT_CLASS       0x0080
#define USB_DEVICE_ID_MATCH_INT_SUBCLASS    0x0100
#define USB_DEVICE_ID_MATCH_INT_PROTOCOL    0x0200

#define	MU_SYSFS_INVALID	-1
#define	MU_SYSFS_DEVICE		1
#define	MU_SYSFS_INTERFACE	2

typedef struct {
	unsigned int	vendor;
	unsigned int	product;
	unsigned int	device_lo,device_hi;
} MU_usb_product_t;

typedef struct {
	unsigned int	class;
	unsigned int	subclass;
	unsigned int	protocol;
} MU_usb_type_t;

typedef struct {
	char *name;
	unsigned int match_flags;
	MU_usb_product_t product;
	MU_usb_type_t	device;
	MU_usb_type_t	interface;
} MU_usb_config_t;

extern int get_id_usb_product(mu_op_t *);
extern int get_id_usb_type(mu_op_t *);
/* sysfs */
extern int get_sysfs_product(mu_op_t *);
extern int get_sysfs_type(mu_op_t *);
extern int get_sysfs_interface(mu_op_t *);
extern int get_sysfs_kind(mu_op_t *);

#endif	/* _MURASAKI_USB_H */
