/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: filelist.c,v 1.6 2004/09/12 07:39:01 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<sys/mman.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"

#define		CHAR_RSEP	'\n'


enum string_status {ST_START, ST_IN };

#define	NUM_ERROR -1

/*
 * "list" is allocated, so Don't forget free "list[0]".
 * list[last] == NULL, so arg 3 max need to be list count + 1
 */
int
list_from_file(char *fname,list_t *lst)
{
	char *buf,*ptr;
	int size;
	enum string_status status = ST_START;

	if ((buf = alloc_read(fname,&size)) == NULL || size == 0) {
		if (lst->size > 0) {
			lst->list[0] = NULL;	/* end mark:not used */
			lst->used = 0;
		}
		return GOOD;
	}

	for (ptr = buf,lst->used = 0;ptr < buf + size;ptr++) {
		if (status == ST_START) {
			if (lst->used == lst->size) {
				if (realloc_list(lst) == INVALID)
					return INVALID;
			}
			lst->list[lst->used++] = ptr;
			status = ST_IN;
		} else {
			if (*ptr == CHAR_RSEP) {
				*ptr = '\0';
				status = ST_START;
			}
		}
	}
	lst->list[lst->used] = NULL;	/* end mark:not used */

	return GOOD;
}
