/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: permission.c,v 1.6 2004/09/12 17:30:27 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>
#include	<pwd.h>		/* for getpwnam */

#include	"murasaki.h"

static uid_t
name2uid(char *name)
{
	struct passwd *pw;

	pw = getpwnam(name);
	return pw->pw_uid;
}

int
check_file_x(char *path,int msg_level)
{
	struct stat st;
	uid_t uid;

	if (stat(path,&st) == -1) {
		LOG(MU_MSG_WHISPER,msg_level,"%s stat error %m",path);
		return INVALID;
	}
	uid = name2uid(MU_OWNER);
	if (st.st_uid != uid) {
		LOG(MU_MSG_WHISPER,msg_level,"UID(%d) of %s is not %s.",
			st.st_uid,path,MU_OWNER);
		return INVALID;
	}
	if (st.st_mode & 0022) {
		LOG(MU_MSG_WHISPER,msg_level,"The mode(%03o) of %s is writable for not owner.",
			st.st_mode,path);
		return INVALID;
	}

	return GOOD;
}

