/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: script.c,v 1.13 2004/09/12 07:49:59 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>	/* for exit(3) */
#include	<string.h>
#include	<unistd.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/wait.h>
#include	<limits.h>

#include	"murasaki.h"

#define	SCRIPT_MAX_ARG	3
#define	SCRIPT_START	"start"
#define	SCRIPT_STOP	"stop"

/* 
 * called: exec_module_script,exec_device_script
 */
static void
exec_scriptlist(mu_op_t *opp, int process)
{
	int i;
	char *cmd[SCRIPT_MAX_ARG];
	char path[PATH_MAX];

	if (opp->action == ACTION_ADD)
		cmd[1] = SCRIPT_START;
	else 
		cmd[1] = SCRIPT_STOP;
	cmd[2] = NULL;
	/*
	 * cmd[0] must be specified as a full path.
	 * If script name does not begin with '/',
	 *  script file is recognized as under MU_SCRIPT_DIR.
	 */
	for(i=0;i < opp->script_list.used;i++) {
		if (opp->script_list.list[i][0] != '/') {
			strcpy(path,MU_SCRIPT_DIR);
			strcat(path+sizeof(MU_SCRIPT_DIR)-1,"/");
			strcat(path+sizeof(MU_SCRIPT_DIR),opp->script_list.list[i]);
			cmd[0] = path;
		} else {
			cmd[0] = opp->script_list.list[i];
		}
		/*
		 * checking uid and mode.
		 * uid: MU_OWNER(default root)
		 * mode: not writable for 'group' and 'other'.
		 */
		if (check_file_x(cmd[0],opp->msg_level) == INVALID) {
			LOG_OPP_WHISPER("Murasaki stop executing \"%s\" because of danger",cmd[0]);
		} else {
			LOG_OPP_STD("Executing \"%s\" \"%s\"",
				cmd[0],cmd[1]);
			if (process == FORK_OFF && (i+1 == opp->script_list.used)) {
				executing(opp,cmd,FORK_OFF);
			} else {
				executing(opp,cmd,FORK_ON);
			}
		}
	}
}

/*
 * called:exec_script
 */
static void
exec_module_script(mu_op_t *opp,int timing)
{
	/*
	 * execute script files
	 */
	if (get_module_script(opp,timing) == INVALID) {
		LOG_OPP_TRACE("get_modulescript return INVALID");
		exit(1);
	}
	if (opp->script_list.used > 0)
		exec_scriptlist(opp,FORK_ON);
}

/*
 * [xxx]: yyy
 * xxx = device
 * yyy = executable script(or binary)
 */
void
exec_device_script(mu_op_t *opp, int timing)
{
	int fork_flag;

	/* expand [device] into script_list[] */
	if (get_device_script(opp,timing) == INVALID) {
		/* error message is not need */
		exit(1);
	}
	/* if executable script exists , call exec_scriptlist() */
	if (opp->script_list.used > 0) {
		if (timing == PRECALL) 
			fork_flag = FORK_ON;
		else
			fork_flag = FORK_OFF;	/* never come back */
		exec_scriptlist(opp,fork_flag);
	}
}

/*
 * called ieee1394(opp->end), usb(opp->end), pci(end_pci)
 */
void
exec_script(mu_op_t *opp,int timing)
{
	exec_module_script(opp,timing);
	exec_device_script(opp,timing);
}
