/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: value.c,v 1.5 2004/09/12 07:51:06 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<unistd.h>
#include	<stdlib.h>	/* strtoul */

#include	"murasaki.h"

#define	XVALUE_LEN	12	/* 32bits */

int
sysfs_value(char *fname,unsigned int *ret,int base,int max_sleep,int msg_level)
{
	int fd;
	char buf[XVALUE_LEN+1];
	ssize_t len;
	int sleep_count;

	for(sleep_count = 0;sleep_count < max_sleep;sleep_count++) {
		if (access(fname,R_OK) != -1)
			break;
		LOG(MU_MSG_TRACE,msg_level,"sysfs_value %s: sleep %d",fname,sleep_count);
		sleep(1);
	}

	if ((fd = open(fname,O_RDONLY)) == -1) {
		LOG(MU_MSG_TRACE,msg_level,"open error \"%s\": %m",fname);
		return INVALID;
	}
	if ((len = read(fd,buf,XVALUE_LEN)) <= 0) {
		LOG(MU_MSG_TRACE,msg_level,"read error \"%s\": %m",fname);
		return INVALID;
	}
	close(fd);
	buf[len] = '\0';
	*ret = strtoul(buf,NULL,base);
	LOG(MU_MSG_TRACE,msg_level,"%s=%d 0x%x",fname,*ret,*ret);

	return GOOD;
}
