/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: type.c,v 3.8 2004/09/12 07:58:32 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_usb.h"

#define		SEP	'/'

/*
 * format: d/d/d
 */

static int
get_type_sub(MU_usb_type_t *tp,char *ptr)
{
	char *sep;

	tp->class = strtoul(ptr,&sep,10);	/* class */
	if (*sep != SEP)
		return INVALID;

	ptr = sep+1;
	tp->subclass = strtoul(ptr,&sep,10);	/* subclass */
	if (*sep != SEP)
		return INVALID;

	ptr = sep+1;
	tp->protocol = strtoul(ptr,NULL,10);	/* protocol */

	return GOOD;	
}

int
get_id_usb_type(mu_op_t *opp)
{
	char *ptr;
	MU_usb_type_t face;
	MU_usb_config_t *config;

	config = opp->config;

	ptr = getenv("TYPE");
	if (ptr != NULL) {
		if (get_type_sub (&face, ptr) == INVALID)
			return INVALID;
		config->device = face;
		LOG_OPP_DESC("class 0x%x subclass 0x%x protocol 0x%x",face.class,face.subclass,face.protocol);
	}

	if (config->device.class == 0) {
		ptr = getenv("INTERFACE");
		if (ptr != NULL) {
			if (get_type_sub(&face, ptr) == INVALID)
				return INVALID;
			config->interface = face;
			LOG_OPP_DESC("Interface class 0x%x subclass 0x%x protocol 0x%x",face.class,face.subclass,face.protocol);
		}
	} else {
		config->interface.class = 0;
		config->interface.subclass = 0;
		config->interface.protocol = 0;
	}

	return GOOD;
}

