//muroard.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010-2011
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_H_
#define _MUROARD_H_

#include "features.h" /* feature config */
#include "deps.h"     /* calc deps of config options */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* Socket includes */
#ifdef __WIN32
#include <windows.h>
#include <winsock2.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#if defined(PF_UNIX)
#include <sys/un.h>
#endif
#include <netdb.h>
#endif

#if !defined(__WIN32) && !defined(TARGET_MICROCONTROLLER)
#include <fcntl.h>
#endif

#ifndef __WIN32
#include <errno.h>
#endif

#ifdef MUROARD_FEATURE_SIGNALS
#include <signal.h>
#endif

#ifdef MUROARD_HAVE_FCHMOD
#include <sys/types.h>
#include <sys/stat.h>
#endif

#include <muroar.h>   /* Roar header file */

#include "para.h"     /* server parameter and config */

#include "memmgr.h"   /* macros for memory functions */

#include "callbacks.h"

#include "network.h"
#include "waveform.h"
#include "proto.h"
#include "driver.h"
#include "dsp.h"
#include "clients.h"
#include "streams.h"
#ifdef MUROARD_FEATURE_CODECFILTER
#include "cf.h"
#endif

int muroard_g_alive;

void muroard_init_signals(void);
void muroard_daemonize(void);
int  muroard_init(void);
void muroard_mainloop(void);
void muroard_shutdown(void);
int muroard_main_initonly (int argc, char * argv[]);
int muroard_main (int argc, char * argv[]);

#endif

//ll
