//dsp.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_DSP_H_
#define _MUROARD_DSP_H_

// macros to test if we need to swap:
#ifdef MUROAR_FEATURE_BYTE_SWAP
#if MUROAR_CODEC_PCM_S == MUROAR_CODEC_PCM_S_BE
#define dsp_need_swap_s(c) ((c) == MUROAR_CODEC_PCM_S_BE ? 0 : 1)
#define dsp_need_swap_u(c) ((c) == MUROAR_CODEC_PCM_U_BE ? 0 : 1)
#else
#define dsp_need_swap_s(c) ((c) == MUROAR_CODEC_PCM_S_BE ? 1 : 0)
#define dsp_need_swap_u(c) ((c) == MUROAR_CODEC_PCM_U_BE ? 1 : 0)
#endif
#endif

int dsp_mixer(int16_t * out, int16_t ** in, size_t num);

#ifdef MUROAR_FEATURE_UPMIX
void dsp_upmix(void * data, size_t samples);
#endif
#ifdef MUROAR_FEATURE_DOWNMIX
void dsp_downmix(void * data, size_t samples);
#endif
#ifdef MUROAR_FEATURE_UPSCALE
void dsp_upscale(void * data, size_t samples);
#endif
#ifdef MUROAR_FEATURE_DOWNSCALE
void dsp_downscale(void * data, size_t samples);
#endif

#ifdef MUROAR_FEATURE_BYTE_SWAP
void dsp_swap16(int16_t * data, size_t samples);
#endif

#endif

//ll
