//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: midisyncimpl.cpp,v 1.1.1.1 2003/10/27 18:54:31 wschweer Exp $
//
//  (C) Copyright 1999/2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "midisyncimpl.h"
#include "sync.h"
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>

//---------------------------------------------------------
//   syncChanged
//    val = 1  -  Master Mode
//          0  -  Slave Mode
//---------------------------------------------------------

void MidiSyncConfig::syncChanged(int val)
      {
      acceptMTCCheckbox->setEnabled(val);
      acceptMCCheckbox->setEnabled(val);
      acceptMMCCheckbox->setEnabled(val);
      }

//---------------------------------------------------------
//   MidiSyncConfig
//    Midi Sync Config
//---------------------------------------------------------

MidiSyncConfig::MidiSyncConfig(QWidget* parent, const char* name)
  : MidiSyncConfigBase(parent, name)
      {
      connect(okButton, SIGNAL(clicked()), SLOT(ok()));
      connect(applyButton, SIGNAL(clicked()), SLOT(apply()));
      connect(cancelButton, SIGNAL(clicked()), SLOT(cancel()));

      connect(syncMode, SIGNAL(clicked(int)), SLOT(syncChanged(int)));
      bool ext = extSyncFlag.value();
      syncMode->setButton(int(ext));

      dstDevId->setValue(txDeviceId);
      srcDevId->setValue(rxDeviceId);
      srcSyncPort->setValue(rxSyncPort + 1);
      dstSyncPort->setValue(txSyncPort + 1);

      mtcSync->setChecked(genMTCSync);
      mcSync->setChecked(genMCSync);
      midiMachineControl->setChecked(genMMC);

      acceptMTCCheckbox->setChecked(acceptMTC);
      acceptMCCheckbox->setChecked(acceptMC);
      acceptMMCCheckbox->setChecked(acceptMMC);

      mtcSyncType->setCurrentItem(mtcType);

      mtcOffH->setValue(mtcOffset.h());
      mtcOffM->setValue(mtcOffset.m());
      mtcOffS->setValue(mtcOffset.s());
      mtcOffF->setValue(mtcOffset.f());
      mtcOffSf->setValue(mtcOffset.sf());

      syncChanged(ext);
      }

//---------------------------------------------------------
//   ok Pressed
//---------------------------------------------------------

void MidiSyncConfig::ok()
      {
      apply();
      cancel();
      }

//---------------------------------------------------------
//   cancel Pressed
//---------------------------------------------------------

void MidiSyncConfig::cancel()
      {
      close(false);
      }

//---------------------------------------------------------
//   apply Pressed
//---------------------------------------------------------

void MidiSyncConfig::apply()
      {
      txDeviceId  = dstDevId->value();
      rxDeviceId  = srcDevId->value();
      rxSyncPort  = srcSyncPort->value() - 1;
      txSyncPort  = dstSyncPort->value() - 1;

      genMTCSync  = mtcSync->isChecked();
      genMCSync   = mcSync->isChecked();
      genMMC      = midiMachineControl->isChecked();

      mtcType     = mtcSyncType->currentItem();
      extSyncFlag.setValue(syncMode->id(syncMode->selected()));

      mtcOffset.setH(mtcOffH->value());
      mtcOffset.setM(mtcOffM->value());
      mtcOffset.setS(mtcOffS->value());
      mtcOffset.setF(mtcOffF->value());
      mtcOffset.setSf(mtcOffSf->value());

      acceptMC  = acceptMCCheckbox->isChecked();
      acceptMMC = acceptMMCCheckbox->isChecked();
      acceptMTC = acceptMTCCheckbox->isChecked();
      }

